/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.convert;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.runtime.api.Framework;

public class StoryboardConverter
implements Converter {
    public static final Log log = LogFactory.getLog(StoryboardConverter.class);
    @Deprecated
    public static final String FFMPEG_INFO_COMMAND = "ffmpeg-info";
    public static final String FFMPEG_SCREENSHOT_RESIZE_COMMAND = "ffmpeg-screenshot-resize";
    public static final String ORIGINAL_WIDTH_PARAM = "original_width";
    public static final String ORIGINAL_HEIGHT_PARAM = "original_height";
    public static final String WIDTH_PARAM = "width";
    public static final String HEIGHT_PARAM = "height";
    public static final String THUMBNAIL_NUMBER_PARAM = "thumbnail_number";
    protected Map<String, String> commonParams = new HashMap<String, String>();

    public void init(ConverterDescriptor descriptor) {
        this.commonParams = descriptor.getParameters();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        ArrayList<Double> timecodes = new ArrayList<Double>();
        ArrayList<String> comments = new ArrayList<String>();
        properties.put("timecodes", timecodes);
        properties.put("comments", comments);
        SimpleBlobHolderWithProperties bh = new SimpleBlobHolderWithProperties(blobs, properties);
        Blob blob = blobHolder.getBlob();
        try (CloseableFile source = blob.getCloseableFile("." + FilenameUtils.getExtension((String)blob.getFilename()));){
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
            CmdParameters params = cles.getDefaultCmdParameters();
            params.addNamedParameter("inFilePath", source.getFile().getAbsolutePath());
            Double duration = (Double)parameters.get("duration");
            if (duration == null) {
                log.warn((Object)String.format("Cannot extract storyboard for file '%s' with missing duration info.", blob.getFilename()));
                SimpleBlobHolderWithProperties simpleBlobHolderWithProperties2 = bh;
                return simpleBlobHolderWithProperties2;
            }
            int numberOfThumbnails = this.getNumberOfThumbnails(parameters);
            for (int i = 0; i < numberOfThumbnails; ++i) {
                double timecode = BigDecimal.valueOf((double)i * duration / (double)numberOfThumbnails).setScale(2, RoundingMode.HALF_UP).doubleValue();
                Blob thumbBlob = Blobs.createBlobWithExtension((String)".jpeg");
                params.addNamedParameter("outFilePath", thumbBlob.getFile().getAbsolutePath());
                params.addNamedParameter("position", String.valueOf(timecode));
                this.fillWidthAndHeightParameters(params, parameters);
                ExecResult result = cles.execCommand(FFMPEG_SCREENSHOT_RESIZE_COMMAND, params);
                if (!result.isSuccessful()) {
                    throw result.getError();
                }
                thumbBlob.setMimeType("image/jpeg");
                thumbBlob.setFilename(String.format(Locale.ENGLISH, "%.2f-seconds.jpeg", timecode));
                blobs.add(thumbBlob);
                timecodes.add(timecode);
                comments.add(String.format("%s %d", blob.getFilename(), i));
            }
            SimpleBlobHolderWithProperties simpleBlobHolderWithProperties = bh;
            return simpleBlobHolderWithProperties;
        }
        catch (IOException | CommandException | CommandNotAvailable e) {
            throw new ConversionException("Error extracting story board from '" + blob.getFilename() + "'", e);
        }
    }

    protected int getNumberOfThumbnails(Map<String, Serializable> parameters) {
        int numberOfThumbnails = 9;
        if (parameters.containsKey(THUMBNAIL_NUMBER_PARAM)) {
            numberOfThumbnails = (Integer)parameters.get(THUMBNAIL_NUMBER_PARAM);
        }
        if (this.commonParams.containsKey(THUMBNAIL_NUMBER_PARAM)) {
            numberOfThumbnails = Integer.parseInt(this.commonParams.get(THUMBNAIL_NUMBER_PARAM));
        }
        if (numberOfThumbnails < 1) {
            numberOfThumbnails = 1;
        }
        return numberOfThumbnails;
    }

    protected void fillWidthAndHeightParameters(CmdParameters cmdParameters, Map<String, Serializable> parameters) {
        String screenshotWidth = this.commonParams.getOrDefault(WIDTH_PARAM, "130");
        String screenshotHeight = this.commonParams.getOrDefault(HEIGHT_PARAM, "80");
        if (parameters.containsKey(ORIGINAL_WIDTH_PARAM) && parameters.containsKey(ORIGINAL_HEIGHT_PARAM)) {
            long originalWidth = (Long)parameters.get(ORIGINAL_WIDTH_PARAM);
            long originalHeight = (Long)parameters.get(ORIGINAL_HEIGHT_PARAM);
            if (originalHeight > originalWidth) {
                String temp = screenshotWidth;
                screenshotWidth = screenshotHeight;
                screenshotHeight = temp;
            }
        }
        cmdParameters.addNamedParameter(WIDTH_PARAM, screenshotWidth);
        cmdParameters.addNamedParameter(HEIGHT_PARAM, screenshotHeight);
    }
}

