/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.platform.comment.api.Comment;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentNotFoundException;
import org.nuxeo.ecm.platform.comment.api.exceptions.CommentSecurityException;
import org.nuxeo.ecm.platform.comment.impl.AbstractCommentManager;
import org.nuxeo.ecm.platform.comment.impl.CommentManagerImpl;
import org.nuxeo.ecm.platform.comment.impl.PropertyCommentManager;
import org.nuxeo.ecm.platform.comment.impl.TreeCommentManager;

public class BridgeCommentManager
extends AbstractCommentManager {
    protected final CommentManager first;
    protected final CommentManager second;

    public BridgeCommentManager(CommentManager first, CommentManager second) {
        this.first = first;
        this.second = second;
    }

    public CommentManager getFirst() {
        return this.first;
    }

    public CommentManager getSecond() {
        return this.second;
    }

    @Override
    public List<DocumentModel> getComments(DocumentModel docModel) {
        return Stream.concat(this.first.getComments(docModel).stream(), this.second.getComments(docModel).stream()).distinct().collect(Collectors.toList());
    }

    public List<DocumentModel> getComments(CoreSession session, DocumentModel docModel) throws CommentSecurityException {
        return Stream.concat(this.first.getComments(session, docModel).stream(), this.second.getComments(session, docModel).stream()).distinct().collect(Collectors.toList());
    }

    public DocumentModel createComment(DocumentModel docModel, String comment) {
        return this.second.createComment(docModel, comment);
    }

    public DocumentModel createComment(DocumentModel docModel, String comment, String author) {
        return this.second.createComment(docModel, comment, author);
    }

    public DocumentModel createComment(DocumentModel docModel, DocumentModel comment) throws CommentSecurityException {
        return this.second.createComment(docModel, comment);
    }

    public DocumentModel createComment(DocumentModel docModel, DocumentModel parent, DocumentModel child) {
        return this.second.createComment(docModel, parent, child);
    }

    public void deleteComment(DocumentModel docModel, DocumentModel comment) {
        if (comment.getPropertyValue("comment:parentId") != null) {
            this.second.deleteComment(docModel, comment);
        } else {
            this.first.deleteComment(docModel, comment);
        }
    }

    public List<DocumentModel> getDocumentsForComment(DocumentModel comment) {
        return Stream.concat(this.first.getDocumentsForComment(comment).stream(), this.second.getDocumentsForComment(comment).stream()).distinct().collect(Collectors.toList());
    }

    public DocumentModel getThreadForComment(DocumentModel comment) throws CommentSecurityException {
        if (comment.getPropertyValue("comment:parentId") != null) {
            if (this.second instanceof TreeCommentManager) {
                return this.first.getThreadForComment(comment);
            }
            return this.second.getThreadForComment(comment);
        }
        return this.first.getThreadForComment(comment);
    }

    public DocumentModel createLocatedComment(DocumentModel docModel, DocumentModel comment, String path) throws CommentSecurityException {
        return this.second.createLocatedComment(docModel, comment, path);
    }

    public Comment createComment(CoreSession session, Comment comment) throws CommentNotFoundException, CommentSecurityException {
        return this.second.createComment(session, comment);
    }

    public Comment getComment(CoreSession session, String commentId) throws CommentNotFoundException, CommentSecurityException {
        return this.second.getComment(session, commentId);
    }

    @Override
    public List<Comment> getComments(CoreSession session, String documentId) {
        return Stream.concat(this.first.getComments(session, documentId).stream(), this.second.getComments(session, documentId).stream()).distinct().collect(Collectors.toList());
    }

    public PartialList<Comment> getComments(CoreSession session, String documentId, Long pageSize, Long currentPageIndex, boolean sortAscending) throws CommentSecurityException {
        PartialList firstComments = this.first.getComments(session, documentId, pageSize, currentPageIndex, sortAscending);
        PartialList secondComments = this.second.getComments(session, documentId, pageSize, currentPageIndex, sortAscending);
        List allComments = Stream.concat(firstComments.stream(), secondComments.stream()).distinct().collect(Collectors.toList());
        return new PartialList(allComments, (long)allComments.size());
    }

    public Comment updateComment(CoreSession session, String commentId, Comment comment) throws CommentNotFoundException, CommentSecurityException {
        IdRef commentRef = new IdRef(commentId);
        return (Comment)CoreInstance.doPrivileged((CoreSession)session, arg_0 -> this.lambda$updateComment$0((DocumentRef)commentRef, commentId, session, comment, arg_0));
    }

    public void deleteComment(CoreSession session, String commentId) throws CommentNotFoundException, CommentSecurityException {
        IdRef commentRef = new IdRef(commentId);
        CoreInstance.doPrivileged((CoreSession)session, arg_0 -> this.lambda$deleteComment$1((DocumentRef)commentRef, commentId, session, arg_0));
    }

    public Comment getExternalComment(CoreSession session, String documentId, String entityId) throws CommentNotFoundException, CommentSecurityException {
        return this.second.getExternalComment(session, documentId, entityId);
    }

    public Comment updateExternalComment(CoreSession session, String documentId, String entityId, Comment comment) throws CommentNotFoundException, CommentSecurityException {
        return this.second.updateExternalComment(session, documentId, entityId, comment);
    }

    public void deleteExternalComment(CoreSession session, String documentId, String entityId) throws CommentNotFoundException, CommentSecurityException {
        this.second.deleteExternalComment(session, documentId, entityId);
    }

    public boolean hasFeature(CommentManager.Feature feature) {
        switch (feature) {
            case COMMENTS_LINKED_WITH_PROPERTY: {
                return false;
            }
        }
        throw new UnsupportedOperationException(feature.name());
    }

    @Override
    public DocumentRef getTopLevelDocumentRef(CoreSession session, DocumentRef commentIdRef) {
        return this.execute(session, commentIdRef, cm -> cm.getTopLevelDocumentRef(session, commentIdRef));
    }

    @Override
    protected DocumentModel getTopLevelDocument(CoreSession session, DocumentModel commentDoc) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected DocumentModel getCommentedDocument(CoreSession session, DocumentModel commentDoc) {
        throw new UnsupportedOperationException();
    }

    protected <T> T execute(CoreSession s, DocumentRef documentRef, Function<CommentManager, T> function) {
        return (T)CoreInstance.doPrivileged((CoreSession)s, session -> {
            DocumentModel documentModel = session.getDocument(documentRef);
            if (this.first instanceof CommentManagerImpl && this.second instanceof PropertyCommentManager) {
                if (documentModel.getPropertyValue("comment:parentId") != null) {
                    return function.apply(this.second);
                }
                return function.apply(this.first);
            }
            if (this.first instanceof PropertyCommentManager && this.second instanceof TreeCommentManager) {
                DocumentRef parentRef = documentModel.getParentRef();
                if (session.getDocument(parentRef).getType().equals("HiddenFolder")) {
                    return function.apply(this.first);
                }
                return function.apply(this.second);
            }
            throw new IllegalArgumentException(String.format("Undefined behaviour for document ref: %s, first: %s, second: %s ", documentModel, this.first, this.second));
        });
    }

    private /* synthetic */ void lambda$deleteComment$1(DocumentRef commentRef, String commentId, CoreSession session, CoreSession s) {
        if (!s.exists(commentRef)) {
            throw new CommentNotFoundException("The comment " + commentId + " does not exist");
        }
        if (s.getDocument(commentRef).getPropertyValue("comment:parentId") != null) {
            this.second.deleteComment(session, commentId);
        } else {
            this.first.deleteComment(session, commentId);
        }
    }

    private /* synthetic */ Comment lambda$updateComment$0(DocumentRef commentRef, String commentId, CoreSession session, Comment comment, CoreSession s) {
        if (!s.exists(commentRef)) {
            throw new CommentNotFoundException("The comment " + commentId + " does not exist");
        }
        if (s.getDocument(commentRef).getPropertyValue("comment:parentId") != null) {
            return this.second.updateComment(session, commentId, comment);
        }
        return this.first.updateComment(session, commentId, comment);
    }
}

