/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.migrator.AbstractRepositoryMigrator;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.platform.comment.impl.TreeCommentManager;
import org.nuxeo.ecm.platform.comment.service.CommentService;
import org.nuxeo.ecm.platform.comment.service.CommentServiceConfig;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.QNameResourceImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.migration.MigrationService;

public class CommentsMigrator
extends AbstractRepositoryMigrator {
    private static final Logger log = LogManager.getLogger(CommentsMigrator.class);
    protected static final int BATCH_SIZE = 50;
    public static final String UNMIGRATED_COMMENTS_FOLDER_NAME = "UnMigratedComments";
    public static final String GET_COMMENTS_FOLDERS_QUERY = String.format("SELECT %s FROM Document WHERE %s = '%s' AND %s ='%s'", "ecm:uuid", "ecm:name", "Comments", "ecm:primaryType", "HiddenFolder");

    protected String probeSession(CoreSession session) {
        Graph graph;
        CommentService commentComponent = (CommentService)((Object)Framework.getRuntime().getComponent(CommentService.NAME));
        CommentServiceConfig commentServiceConfig = commentComponent.getConfig();
        if (commentServiceConfig != null && !(graph = ((RelationManager)Framework.getService(RelationManager.class)).getGraph(commentServiceConfig.graphName, session)).getStatements().isEmpty()) {
            return "relation";
        }
        if (this.hasUnsecuredComments(session)) {
            return "property";
        }
        return "secured";
    }

    public void run(String step, MigrationService.MigrationContext migrationContext) {
        if (!Set.of("relation-to-property", "property-to-secured").contains(step)) {
            throw new NuxeoException("Unknown migration step: " + step);
        }
        this.migrationContext = migrationContext;
        this.reportProgress("Initializing", 0L, -1L);
        List repositoryNames = ((RepositoryService)Framework.getService(RepositoryService.class)).getRepositoryNames();
        try {
            repositoryNames.forEach(repoName -> this.migrateRepository(step, migrationContext, (String)repoName));
        }
        catch (AbstractRepositoryMigrator.MigrationShutdownException e) {
            log.trace("Migration is shutdown");
        }
    }

    protected void migrateSession(String step, MigrationService.MigrationContext migrationContext, CoreSession session) {
        if ("relation-to-property".equals(step)) {
            this.migrateSessionRelationToProperty(session, migrationContext);
        } else if ("property-to-secured".equals(step)) {
            this.migrateSessionPropertyToSecured(session, migrationContext);
        }
    }

    protected void migrateSessionRelationToProperty(CoreSession session, MigrationService.MigrationContext migrationContext) {
        CommentService commentComponent = (CommentService)((Object)Framework.getService(CommentService.class));
        CommentServiceConfig commentServiceConfig = commentComponent.getConfig();
        if (commentServiceConfig != null) {
            RelationManager relationManager = (RelationManager)Framework.getService(RelationManager.class);
            Graph graph = relationManager.getGraph(commentServiceConfig.graphName, session);
            List statements = graph.getStatements();
            this.checkShutdownRequested(migrationContext);
            this.processBatched(migrationContext, 50, statements, statement -> this.migrateCommentsFromRelationToProperty(session, relationManager, commentServiceConfig, (Statement)statement), "Migrating comments from Relation to Property");
            this.reportProgress("Done Migrating from Relation to Property", statements.size(), statements.size());
        }
    }

    protected void migrateCommentsFromRelationToProperty(CoreSession session, RelationManager relationManager, CommentServiceConfig config, Statement statement) {
        Map<String, CoreSession> ctxMap = Collections.singletonMap("CoreSession", session);
        QNameResourceImpl object = (QNameResourceImpl)statement.getObject();
        DocumentModel parent = (DocumentModel)relationManager.getResourceRepresentation(config.documentNamespace, (Resource)object, ctxMap);
        QNameResourceImpl subject = (QNameResourceImpl)statement.getSubject();
        DocumentModel comment = (DocumentModel)relationManager.getResourceRepresentation(config.commentNamespace, (Resource)subject, ctxMap);
        if (parent != null && comment != null) {
            comment.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
            comment.setPropertyValue("comment:parentId", (Serializable)((Object)parent.getId()));
            session.saveDocument(comment);
        } else if (parent == null && comment == null) {
            log.warn("Documents {} and {} do not exist, they cannot be migrated", (Object)object.getLocalName(), (Object)subject.getLocalName());
        } else {
            log.warn("Document {} does not exist, it cannot be migrated", new Supplier[]{() -> parent == null ? object.getLocalName() : subject.getLocalName()});
        }
        Graph graph = relationManager.getGraph(config.graphName, session);
        graph.remove(statement);
    }

    protected void migrateSessionPropertyToSecured(CoreSession session, MigrationService.MigrationContext migrationContext) {
        List<String> comments = this.getUnsecuredCommentIds(session);
        TreeCommentManager treeCommentManager = new TreeCommentManager();
        this.processBatched(migrationContext, 50, comments, comment -> this.migrateCommentsFromPropertyToSecured(session, treeCommentManager, new IdRef(comment)), "Migrating comments from Property to Secured");
        int totalOfComments = comments.size();
        int nbeOfUnMigratedComments = this.getUnsecuredCommentIds(session).size();
        if (nbeOfUnMigratedComments == 0) {
            session.query(GET_COMMENTS_FOLDERS_QUERY).forEach(folder -> session.removeDocument(folder.getRef()));
            IdRef[] documentsToRemove = (IdRef[])session.queryProjection(GET_COMMENTS_FOLDERS_QUERY, 0L, 0L).stream().map(m -> new IdRef((String)m.get("ecm:uuid"))).toArray(IdRef[]::new);
            session.removeDocuments((DocumentRef[])documentsToRemove);
            this.reportProgress("Done Migrating from Property to Secured", totalOfComments, totalOfComments);
        } else {
            log.warn("Some comments have not been migrated, see logs for more information. The folder containing these comments will be renamed to {}", (Object)UNMIGRATED_COMMENTS_FOLDER_NAME);
            session.query(GET_COMMENTS_FOLDERS_QUERY).forEach(docModel -> {
                session.move(docModel.getRef(), null, UNMIGRATED_COMMENTS_FOLDER_NAME);
                docModel.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
                session.saveDocument(docModel);
            });
            session.save();
            this.reportProgress("Done Migrating from Property to Secured", totalOfComments - nbeOfUnMigratedComments, totalOfComments);
        }
    }

    protected void migrateCommentsFromPropertyToSecured(CoreSession session, TreeCommentManager treeCommentManager, IdRef commentIdRef) {
        DocumentModel commentDoc = session.getDocument((DocumentRef)commentIdRef);
        String parentId = (String)((Object)commentDoc.getPropertyValue("comment:parentId"));
        if (StringUtils.isEmpty((CharSequence)parentId)) {
            log.warn("The comment document model with IdRef: {} cannot be migrated, because its 'comment:parentId' is not defined", (Object)commentIdRef);
            return;
        }
        IdRef parentDocRef = new IdRef(parentId);
        if (!session.exists((DocumentRef)parentDocRef)) {
            log.warn("The comment document model with IdRef: {} cannot be migrated, because its parent: {} cannot be found", (Object)commentIdRef, (Object)parentId);
            return;
        }
        DocumentModel parentDoc = session.getDocument((DocumentRef)parentDocRef);
        DocumentRef destination = treeCommentManager.getLocationRefOfCommentCreation(session, parentDoc);
        session.move((DocumentRef)commentIdRef, destination, null);
        commentDoc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        ACP acp = session.getACP((DocumentRef)commentIdRef);
        if (acp != null) {
            acp.removeACL("local");
            session.setACP((DocumentRef)commentIdRef, acp, true);
        }
        session.saveDocument(commentDoc);
        session.save();
    }

    protected boolean hasUnsecuredComments(CoreSession session) {
        List<String> folderIds = this.getCommentFolders(session);
        return folderIds.stream().anyMatch(folderId -> session.hasChildren((DocumentRef)new IdRef(folderId)));
    }

    protected List<String> getUnsecuredCommentIds(CoreSession session) {
        List<String> parentIds = this.getCommentFolders(session);
        if (parentIds.isEmpty()) {
            return Collections.emptyList();
        }
        String query = String.format("SELECT %s FROM Comment WHERE %s IN (%s)", "ecm:uuid", "ecm:parentId", this.buildInClause(parentIds));
        return session.queryProjection(query, 0L, 0L).stream().map(m -> (String)m.get("ecm:uuid")).collect(Collectors.toList());
    }

    protected List<String> getCommentFolders(CoreSession session) {
        ArrayList<String> parentIds = new ArrayList<String>();
        List<String> rootCommentsFolderIds = session.queryProjection(GET_COMMENTS_FOLDERS_QUERY, 0L, 0L).stream().map(entry -> (String)entry.get("ecm:uuid")).collect(Collectors.toList());
        if (!rootCommentsFolderIds.isEmpty()) {
            String query = String.format("SELECT %s FROM Document WHERE %s IN (%s) AND %s = '%s'", "ecm:uuid", "ecm:parentId", this.buildInClause(rootCommentsFolderIds), "ecm:primaryType", "HiddenFolder");
            List timestampCommentFoldersIds = session.queryProjection(query, 0L, 0L).stream().map(entry -> (String)entry.get("ecm:uuid")).collect(Collectors.toList());
            parentIds.addAll(rootCommentsFolderIds);
            parentIds.addAll(timestampCommentFoldersIds);
        }
        return parentIds;
    }

    public String probeState() {
        List repositoryNames = ((RepositoryService)Framework.getService(RepositoryService.class)).getRepositoryNames();
        Set probes = repositoryNames.stream().map(arg_0 -> ((CommentsMigrator)this).probeRepository(arg_0)).collect(Collectors.toSet());
        if (probes.contains("relation")) {
            return "relation";
        }
        if (probes.contains("property")) {
            return "property";
        }
        return "secured";
    }

    public void notifyStatusChange() {
        CommentService commentComponent = (CommentService)((Object)Framework.getRuntime().getComponent(CommentService.NAME));
        commentComponent.invalidateCommentManagerImplementation();
    }

    protected String buildInClause(List<String> parentIds) {
        return parentIds.stream().collect(Collectors.joining("', '", "'", "'"));
    }
}

