/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.comment.listener;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.comment.listener.AbstractCommentListener;
import org.nuxeo.ecm.platform.comment.service.CommentServiceConfig;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.runtime.api.Framework;

public class CommentRemovedEventListener
extends AbstractCommentListener
implements EventListener {
    private static final Log log = LogFactory.getLog(CommentRemovedEventListener.class);

    @Override
    protected void doProcess(CoreSession coreSession, RelationManager relationManager, CommentServiceConfig config, DocumentModel docMessage) {
        log.debug((Object)"Processing relations cleanup on Comment removal");
        String typeName = docMessage.getType();
        if ("Comment".equals(typeName) || "Post".equals(typeName)) {
            CommentManager commentManager = (CommentManager)Framework.getService(CommentManager.class);
            if (commentManager.hasFeature(CommentManager.Feature.COMMENTS_LINKED_WITH_PROPERTY)) {
                this.deleteCommentChildren(coreSession, commentManager, docMessage);
                coreSession.save();
            } else if (relationManager != null) {
                CommentRemovedEventListener.onCommentRemoved(relationManager, config, docMessage);
            } else {
                log.info((Object)"Migration in progress or relation manager is missing");
            }
        }
    }

    private static void onCommentRemoved(RelationManager relationManager, CommentServiceConfig config, DocumentModel docModel) {
        Resource commentRes = relationManager.getResource(config.commentNamespace, (Serializable)docModel, null);
        if (commentRes == null) {
            log.warn((Object)"Could not adapt document model to relation resource; check the service relation adapters configuration");
            return;
        }
        Graph graph = relationManager.getGraph(config.graphName, docModel.getCoreSession());
        List statementList = graph.getStatements((Node)commentRes, null, null);
        graph.remove(statementList);
    }
}

