/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.InternalMapPBStructure;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPb
implements IDataStructurePB {
    protected InternalMapPBStructure weightedLits;
    protected BigInteger degree;
    protected int assertiveLiteral = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.MapPb");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    MapPb(PBConstr cpb) {
        this.weightedLits = new InternalMapPBStructure(cpb);
        this.degree = cpb.getDegree();
    }

    MapPb(int size) {
        this.weightedLits = new InternalMapPBStructure(size);
        this.degree = BigInteger.ZERO;
    }

    @Override
    public boolean isCardinality() {
        int i = 0;
        while (i < this.size()) {
            if (!this.weightedLits.getCoef(i).equals(BigInteger.ONE)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isLongSufficient() {
        BigInteger som = BigInteger.ZERO;
        int i = 0;
        while (i < this.size() && som.bitLength() < 64) {
            if (!$assertionsDisabled && this.weightedLits.getCoef(i).compareTo(BigInteger.ZERO) < 0) {
                throw new AssertionError();
            }
            som = som.add(this.weightedLits.getCoef(i));
            ++i;
        }
        return som.bitLength() < 64;
    }

    @Override
    public int getAssertiveLiteral() {
        return this.assertiveLiteral;
    }

    @Override
    public BigInteger saturation() {
        if (!$assertionsDisabled && this.degree.signum() <= 0) {
            throw new AssertionError();
        }
        BigInteger minimum = this.degree;
        int ind = 0;
        while (ind < this.size()) {
            if (!$assertionsDisabled && this.weightedLits.getCoef(ind).signum() <= 0) {
                throw new AssertionError();
            }
            if (this.degree.compareTo(this.weightedLits.getCoef(ind)) < 0) {
                this.changeCoef(ind, this.degree);
            }
            if (!$assertionsDisabled && this.weightedLits.getCoef(ind).signum() <= 0) {
                throw new AssertionError();
            }
            minimum = minimum.min(this.weightedLits.getCoef(ind));
            ++ind;
        }
        if (minimum.equals(this.degree) && minimum.compareTo(BigInteger.ONE) > 0) {
            this.degree = BigInteger.ONE;
            ind = 0;
            while (ind < this.size()) {
                this.changeCoef(ind, BigInteger.ONE);
                ++ind;
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(PBConstr cpb, BigInteger deg, BigInteger[] reducedCoefs, VarActivityListener val) {
        return this.cuttingPlane(cpb, deg, reducedCoefs, BigInteger.ONE, val);
    }

    @Override
    public BigInteger cuttingPlane(PBConstr cpb, BigInteger degreeCons, BigInteger[] reducedCoefs, BigInteger coefMult, VarActivityListener val) {
        this.degree = this.degree.add(degreeCons);
        if (!$assertionsDisabled && this.degree.signum() <= 0) {
            throw new AssertionError();
        }
        if (reducedCoefs == null) {
            int i = 0;
            while (i < cpb.size()) {
                val.varBumpActivity(cpb.get(i));
                this.cuttingPlaneStep(cpb.get(i), this.multiplyCoefficient(cpb.getCoef(i), coefMult));
                ++i;
            }
        } else {
            int i = 0;
            while (i < cpb.size()) {
                val.varBumpActivity(cpb.get(i));
                this.cuttingPlaneStep(cpb.get(i), this.multiplyCoefficient(reducedCoefs[i], coefMult));
                ++i;
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(int[] lits, BigInteger[] reducedCoefs, BigInteger deg) {
        return this.cuttingPlane(lits, reducedCoefs, deg, BigInteger.ONE);
    }

    @Override
    public BigInteger cuttingPlane(int[] lits, BigInteger[] reducedCoefs, BigInteger degreeCons, BigInteger coefMult) {
        this.degree = this.degree.add(degreeCons);
        if (!$assertionsDisabled && this.degree.signum() <= 0) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < lits.length) {
            this.cuttingPlaneStep(lits[i], reducedCoefs[i].multiply(coefMult));
            ++i;
        }
        return this.degree;
    }

    private void cuttingPlaneStep(int lit, BigInteger coef) {
        if (!$assertionsDisabled && coef.signum() < 0) {
            throw new AssertionError();
        }
        int nlit = lit ^ 1;
        if (coef.signum() > 0) {
            if (this.weightedLits.containsKey(nlit)) {
                if (!$assertionsDisabled && this.weightedLits.containsKey(lit)) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.weightedLits.get(nlit) == null) {
                    throw new AssertionError();
                }
                if (this.weightedLits.get(nlit).compareTo(coef) < 0) {
                    BigInteger tmp = this.weightedLits.get(nlit);
                    this.setCoef(lit, coef.subtract(tmp));
                    if (!$assertionsDisabled && this.weightedLits.get(lit).signum() <= 0) {
                        throw new AssertionError();
                    }
                    this.degree = this.degree.subtract(tmp);
                    this.removeCoef(nlit);
                } else if (this.weightedLits.get(nlit).equals(coef)) {
                    this.degree = this.degree.subtract(coef);
                    this.removeCoef(nlit);
                } else {
                    this.decreaseCoef(nlit, coef);
                    if (!$assertionsDisabled && this.weightedLits.get(nlit).signum() <= 0) {
                        throw new AssertionError();
                    }
                    this.degree = this.degree.subtract(coef);
                }
            } else {
                if (!$assertionsDisabled && this.weightedLits.containsKey(lit) && this.weightedLits.get(lit).signum() <= 0) {
                    throw new AssertionError();
                }
                if (this.weightedLits.containsKey(lit)) {
                    this.increaseCoef(lit, coef);
                } else {
                    this.setCoef(lit, coef);
                }
                if (!$assertionsDisabled && this.weightedLits.get(lit).signum() <= 0) {
                    throw new AssertionError();
                }
            }
        }
        if (!$assertionsDisabled && this.weightedLits.containsKey(nlit) && this.weightedLits.containsKey(lit)) {
            throw new AssertionError();
        }
    }

    @Override
    public void buildConstraintFromConflict(IVecInt resLits, IVec<BigInteger> resCoefs) {
        resLits.clear();
        resCoefs.clear();
        this.weightedLits.copyCoefs(resCoefs);
        this.weightedLits.copyLits(resLits);
    }

    @Override
    public void buildConstraintFromMapPb(int[] resLits, BigInteger[] resCoefs) {
        if (!$assertionsDisabled && resLits.length != resCoefs.length) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resLits.length != this.size()) {
            throw new AssertionError();
        }
        this.weightedLits.copyCoefs(resCoefs);
        this.weightedLits.copyLits(resLits);
    }

    @Override
    public BigInteger getDegree() {
        return this.degree;
    }

    @Override
    public int size() {
        return this.weightedLits.size();
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        int ind = 0;
        while (ind < this.size()) {
            stb.append(this.weightedLits.getCoef(ind));
            stb.append(".");
            stb.append(Lits.toString((int)this.weightedLits.getLit(ind)));
            stb.append(" ");
            ++ind;
        }
        return new StringBuffer(String.valueOf(stb.toString())).append(" >= ").append(this.degree).toString();
    }

    private BigInteger multiplyCoefficient(BigInteger coef, BigInteger mult) {
        if (coef.equals(BigInteger.ONE)) {
            return mult;
        }
        return coef.multiply(mult);
    }

    void increaseCoef(int lit, BigInteger incCoef) {
        this.weightedLits.put(lit, this.weightedLits.get(lit).add(incCoef));
    }

    void decreaseCoef(int lit, BigInteger decCoef) {
        this.weightedLits.put(lit, this.weightedLits.get(lit).subtract(decCoef));
    }

    void setCoef(int lit, BigInteger newValue) {
        this.weightedLits.put(lit, newValue);
    }

    void changeCoef(int indLit, BigInteger newValue) {
        this.weightedLits.changeCoef(indLit, newValue);
    }

    void removeCoef(int lit) {
        this.weightedLits.remove(lit);
    }
}

