/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import com.thetransactioncompany.cors.CORSConfigurationException;
import com.thetransactioncompany.cors.HeaderName;
import com.thetransactioncompany.cors.Origin;
import com.thetransactioncompany.cors.OriginException;
import com.thetransactioncompany.cors.ValidatedOrigin;
import com.thetransactioncompany.util.PropertyParseException;
import com.thetransactioncompany.util.PropertyRetriever;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class CORSConfiguration {
    public final boolean allowGenericHttpRequests;
    public final boolean allowAnyOrigin;
    public final Set<ValidatedOrigin> allowedOrigins;
    public final boolean allowSubdomains;
    public final Set<String> supportedMethods;
    public final boolean supportAnyHeader;
    public final Set<String> supportedHeaders;
    public final Set<String> exposedHeaders;
    public final boolean supportsCredentials;
    public final int maxAge;
    public final boolean tagRequests;

    public final boolean isAllowedOrigin(Origin origin) {
        if (this.allowAnyOrigin) {
            return true;
        }
        if (origin == null) {
            return false;
        }
        if (this.allowedOrigins.contains(origin)) {
            return true;
        }
        if (this.allowSubdomains) {
            return this.isAllowedSubdomainOrigin(origin);
        }
        return false;
    }

    public final boolean isAllowedSubdomainOrigin(Origin origin) {
        try {
            ValidatedOrigin validatedOrigin = origin.validate();
            String scheme = validatedOrigin.getScheme();
            String suffix = validatedOrigin.getSuffix();
            for (ValidatedOrigin allowedOrigin : this.allowedOrigins) {
                if (!suffix.endsWith("." + allowedOrigin.getSuffix()) || !scheme.equalsIgnoreCase(allowedOrigin.getScheme())) continue;
                return true;
            }
        }
        catch (OriginException e) {
            return false;
        }
        return false;
    }

    public final boolean isSupportedMethod(String method) {
        return this.supportedMethods.contains(method);
    }

    public final boolean isSupportedHeader(String header) {
        return this.supportAnyHeader || this.supportedHeaders.contains(header);
    }

    protected static String[] parseWords(String s) {
        String s1 = s.trim();
        if (s1.isEmpty()) {
            return new String[0];
        }
        return s1.split("\\s*,\\s*|\\s+");
    }

    public CORSConfiguration(Properties props) throws CORSConfigurationException {
        try {
            String headerSpec;
            PropertyRetriever pr = new PropertyRetriever(props);
            this.allowGenericHttpRequests = pr.getOptBoolean("cors.allowGenericHttpRequests", true);
            String originSpec = pr.getOptString("cors.allowOrigin", "*").trim();
            this.allowedOrigins = new HashSet<ValidatedOrigin>();
            if (originSpec.equals("*")) {
                this.allowAnyOrigin = true;
            } else {
                String[] urls;
                this.allowAnyOrigin = false;
                for (String url : urls = CORSConfiguration.parseWords(originSpec)) {
                    try {
                        this.allowedOrigins.add(new Origin(url).validate());
                    }
                    catch (OriginException e) {
                        throw new PropertyParseException("Bad origin URL in property cors.allowOrigin: " + url);
                    }
                }
            }
            this.allowSubdomains = pr.getOptBoolean("cors.allowSubdomains", false);
            String methodSpec = pr.getOptString("cors.supportedMethods", "GET, POST, HEAD, OPTIONS").trim().toUpperCase();
            this.supportedMethods = new HashSet<String>();
            for (String methodName : CORSConfiguration.parseWords(methodSpec)) {
                this.supportedMethods.add(methodName);
            }
            try {
                headerSpec = pr.getString("cors.supportedHeaders");
            }
            catch (PropertyParseException e) {
                headerSpec = "*";
            }
            if (headerSpec.equals("*")) {
                this.supportAnyHeader = true;
                this.supportedHeaders = Collections.unmodifiableSet(new HashSet());
            } else {
                this.supportAnyHeader = false;
                String[] headers = CORSConfiguration.parseWords(headerSpec);
                this.supportedHeaders = new HashSet<String>();
                for (String header : headers) {
                    try {
                        this.supportedHeaders.add(HeaderName.formatCanonical(header));
                    }
                    catch (IllegalArgumentException e) {
                        throw new PropertyParseException("Bad header field name in property cors.supportedHeaders: " + header);
                    }
                }
            }
            this.exposedHeaders = new HashSet<String>();
            for (String header : CORSConfiguration.parseWords(pr.getOptString("cors.exposedHeaders", ""))) {
                try {
                    this.exposedHeaders.add(HeaderName.formatCanonical(header));
                }
                catch (IllegalArgumentException e) {
                    throw new PropertyParseException("Bad header field name in property cors.exposedHeaders: " + header);
                }
            }
            this.supportsCredentials = pr.getOptBoolean("cors.supportsCredentials", true);
            this.maxAge = pr.getOptInt("cors.maxAge", -1);
            this.tagRequests = pr.getOptBoolean("cors.tagRequests", false);
        }
        catch (PropertyParseException e) {
            throw new CORSConfigurationException(e.getMessage());
        }
    }
}

