/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm.extensions;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.nuxeo.ecm.platform.rendering.fm.i18n.ResourceComposite;

public class LocaleMessagesMethod
implements TemplateMethodModelEx {
    protected ResourceComposite bundle;

    public LocaleMessagesMethod(ResourceComposite bundle) {
        this.setBundle(bundle);
    }

    public void setBundle(ResourceComposite bundle) {
        this.bundle = bundle;
        if (this.bundle == null) {
            this.bundle = new ResourceComposite();
        }
    }

    public ResourceComposite getBundle() {
        return this.bundle;
    }

    public Object exec(List arguments) throws TemplateModelException {
        String value;
        int size = arguments.size();
        if (size < 2) {
            throw new TemplateModelException("Invalid number of arguments for messages(key, local [, args ..]) method");
        }
        SimpleScalar scalar = (SimpleScalar)arguments.get(0);
        if (scalar == null) {
            throw new TemplateModelException("the argument is not defined");
        }
        String key = scalar.getAsString();
        scalar = (SimpleScalar)arguments.get(1);
        if (scalar == null) {
            throw new TemplateModelException("the argument is not defined");
        }
        String locale = scalar.getAsString();
        try {
            value = this.bundle.getString(key, new Locale(locale));
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
        if (size > 2) {
            String[] args = new String[size - 2];
            for (int i = 0; i < args.length; ++i) {
                args[i] = ((SimpleScalar)arguments.get(i + 2)).getAsString();
            }
            value = MessageFormat.format(value, args);
        }
        return value;
    }
}

