/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sat4j.specs.IVec;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Vec<T>
implements IVec<T> {
    private static final long serialVersionUID = 1L;
    private int nbelem;
    private T[] myarray;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.core.Vec");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Vec() {
        this(5);
    }

    public Vec(T[] elts) {
        this.myarray = elts;
        this.nbelem = elts.length;
    }

    public Vec(int size) {
        this.myarray = new Object[size];
    }

    public Vec(int size, T pad) {
        this.myarray = new Object[size];
        int i = 0;
        while (i < size) {
            this.myarray[i] = pad;
            ++i;
        }
        this.nbelem = size;
    }

    @Override
    public int size() {
        return this.nbelem;
    }

    @Override
    public void shrink(int nofelems) {
        while (nofelems-- > 0) {
            this.myarray[--this.nbelem] = null;
        }
    }

    @Override
    public void shrinkTo(int newsize) {
        int i = this.nbelem;
        while (i > newsize) {
            this.myarray[i - 1] = null;
            --i;
        }
        this.nbelem = newsize;
    }

    @Override
    public void pop() {
        this.myarray[--this.nbelem] = null;
    }

    @Override
    public void growTo(int newsize, T pad) {
        this.ensure(newsize);
        int i = this.nbelem;
        while (i < newsize) {
            this.myarray[i] = pad;
            ++i;
        }
        this.nbelem = newsize;
    }

    @Override
    public void ensure(int nsize) {
        if (nsize >= this.myarray.length) {
            Object[] narray = new Object[Math.max(nsize, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, narray, 0, this.nbelem);
            this.myarray = narray;
        }
    }

    @Override
    public IVec<T> push(T elem) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = elem;
        return this;
    }

    @Override
    public void unsafePush(T elem) {
        this.myarray[this.nbelem++] = elem;
    }

    @Override
    public void insertFirst(T elem) {
        if (this.nbelem > 0) {
            this.push(this.myarray[0]);
            this.myarray[0] = elem;
            return;
        }
        this.push(elem);
    }

    @Override
    public void insertFirstWithShifting(T elem) {
        if (this.nbelem > 0) {
            this.ensure(this.nbelem + 1);
            int i = this.nbelem;
            while (i > 0) {
                this.myarray[i] = this.myarray[i - 1];
                --i;
            }
            this.myarray[0] = elem;
            ++this.nbelem;
            return;
        }
        this.push(elem);
    }

    @Override
    public void clear() {
        Arrays.fill(this.myarray, 0, this.nbelem, null);
        this.nbelem = 0;
    }

    @Override
    public T last() {
        return this.myarray[this.nbelem - 1];
    }

    @Override
    public T get(int index) {
        return this.myarray[index];
    }

    @Override
    public void set(int index, T elem) {
        this.myarray[index] = elem;
    }

    @Override
    public void remove(T elem) {
        int j = 0;
        while (this.myarray[j] != elem) {
            if (!$assertionsDisabled && j >= this.size()) {
                throw new AssertionError();
            }
            ++j;
        }
        System.arraycopy(this.myarray, j + 1, this.myarray, j, this.size() - j - 1);
        this.myarray[--this.nbelem] = null;
    }

    @Override
    public T delete(int index) {
        T ith = this.myarray[index];
        this.myarray[index] = this.myarray[--this.nbelem];
        this.myarray[this.nbelem] = null;
        return ith;
    }

    @Override
    public void copyTo(IVec<T> copy) {
        Vec ncopy = (Vec)copy;
        int nsize = this.nbelem + ncopy.nbelem;
        copy.ensure(nsize);
        System.arraycopy(this.myarray, 0, ncopy.myarray, ncopy.nbelem, this.nbelem);
        ncopy.nbelem = nsize;
    }

    @Override
    public <E> void copyTo(E[] dest) {
        System.arraycopy(this.myarray, 0, dest, 0, this.nbelem);
    }

    @Override
    public void moveTo(IVec<T> dest) {
        this.copyTo(dest);
        this.clear();
    }

    @Override
    public void moveTo(int dest, int source) {
        if (dest != source) {
            this.myarray[dest] = this.myarray[source];
            this.myarray[source] = null;
        }
    }

    @Override
    public T[] toArray() {
        return this.myarray;
    }

    public String toString() {
        StringBuffer stb = new StringBuffer();
        int i = 0;
        while (i < this.nbelem - 1) {
            stb.append(this.myarray[i]);
            stb.append(",");
            ++i;
        }
        if (this.nbelem > 0) {
            stb.append(this.myarray[this.nbelem - 1]);
        }
        return stb.toString();
    }

    void selectionSort(int from, int to, Comparator<T> cmp) {
        int i = from;
        while (i < to - 1) {
            int best_i = i;
            int j = i + 1;
            while (j < to) {
                if (cmp.compare(this.myarray[j], this.myarray[best_i]) < 0) {
                    best_i = j;
                }
                ++j;
            }
            T tmp = this.myarray[i];
            this.myarray[i] = this.myarray[best_i];
            this.myarray[best_i] = tmp;
            ++i;
        }
    }

    void sort(int from, int to, Comparator<T> cmp) {
        int width = to - from;
        if (width <= 15) {
            this.selectionSort(from, to, cmp);
        } else {
            T pivot = this.myarray[width / 2 + from];
            int i = from - 1;
            int j = to;
            while (true) {
                if (cmp.compare(this.myarray[++i], pivot) < 0) {
                    continue;
                }
                while (cmp.compare(pivot, this.myarray[--j]) < 0) {
                }
                if (i >= j) break;
                T tmp = this.myarray[i];
                this.myarray[i] = this.myarray[j];
                this.myarray[j] = tmp;
            }
            this.sort(from, i, cmp);
            this.sort(i, to, cmp);
        }
    }

    @Override
    public void sort(Comparator<T> comparator) {
        this.sort(0, this.nbelem, comparator);
    }

    @Override
    public void sortUnique(Comparator<T> cmp) {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem, cmp);
        int i = 1;
        T last = this.myarray[0];
        int j = 1;
        while (j < this.nbelem) {
            if (cmp.compare(last, this.myarray[j]) < 0) {
                last = this.myarray[i] = this.myarray[j];
                ++i;
            }
            ++j;
        }
        this.nbelem = i;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IVec) {
            IVec v = (IVec)obj;
            if (v.size() != this.size()) {
                return false;
            }
            int i = 0;
            while (i < this.size()) {
                if (!v.get(i).equals(this.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int sum = 0;
        int i = 0;
        while (i < this.nbelem) {
            sum += this.myarray[i].hashCode() / this.nbelem;
            ++i;
        }
        return sum;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Vec.this.nbelem;
            }

            @Override
            public T next() {
                if (this.i == Vec.this.nbelem) {
                    throw new NoSuchElementException();
                }
                return Vec.this.myarray[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        return this.nbelem == 0;
    }

    @Override
    public boolean contains(T e) {
        int i = 0;
        while (i < this.nbelem) {
            if (this.myarray[i].equals(e)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int indexOf(T element) {
        int i = 0;
        while (i < this.nbelem) {
            if (this.myarray[i].equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

