/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.LifeCycleException;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskComment;

public class TaskImpl
implements Task {
    private static final long serialVersionUID = 1L;
    private DocumentModel doc;

    public TaskImpl(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public void addComment(String author, String text) {
        ArrayList<TaskComment> existingTasks = (ArrayList<TaskComment>)this.getPropertyValue("nt:taskComments");
        if (existingTasks == null) {
            existingTasks = new ArrayList<TaskComment>();
        }
        existingTasks.add(new TaskComment(author, text));
        this.setPropertyValue("nt:taskComments", existingTasks);
    }

    @Override
    public void cancel(CoreSession coreSession) {
        this.followTransition(coreSession, "cancel");
    }

    @Override
    public void end(CoreSession coreSession) {
        this.followTransition(coreSession, "end");
    }

    protected void followTransition(CoreSession coreSession, String transition) throws LifeCycleException {
        if (!coreSession.getAllowedStateTransitions(this.doc.getRef()).contains(transition)) {
            throw new LifeCycleException("Cannot follow transition " + transition + " on the document " + this.doc.getPathAsString());
        }
        coreSession.followTransition(this.doc.getRef(), transition);
    }

    @Override
    public List<String> getActors() {
        return (List)this.getPropertyValue("nt:actors");
    }

    @Override
    public List<TaskComment> getComments() {
        List taskCommentsProperty = (List)this.getPropertyValue("nt:taskComments");
        ArrayList<TaskComment> taskComments = new ArrayList<TaskComment>(taskCommentsProperty.size());
        for (Map taskCommentMap : taskCommentsProperty) {
            taskComments.add(new TaskComment(taskCommentMap));
        }
        return taskComments;
    }

    @Override
    public Date getCreated() {
        return this.getDatePropertyValue("dublincore:created");
    }

    protected Date getDatePropertyValue(String propertyName) {
        Calendar cal = (Calendar)this.doc.getPropertyValue(propertyName);
        if (cal != null) {
            return cal.getTime();
        }
        return null;
    }

    @Override
    public List<String> getDelegatedActors() {
        return (List)this.getPropertyValue("nt:delegatedActors");
    }

    @Override
    public String getDescription() {
        return (String)this.getPropertyValue("dublincore:description");
    }

    @Override
    public String getDirective() {
        return (String)this.getPropertyValue("nt:directive");
    }

    @Override
    public DocumentModel getDocument() {
        return this.doc;
    }

    @Override
    public Date getDueDate() {
        return this.getDatePropertyValue("nt:dueDate");
    }

    @Override
    public String getId() {
        return this.doc.getId();
    }

    @Override
    public String getInitiator() {
        return (String)this.getPropertyValue("nt:initiator");
    }

    @Override
    public String getName() {
        return (String)this.getPropertyValue("nt:name");
    }

    @Override
    public String getProcessId() {
        return (String)this.getPropertyValue("nt:processId");
    }

    @Override
    public String getProcessName() {
        return (String)this.getPropertyValue("nt:processName");
    }

    protected <T> T getPropertyValue(String propertyName) {
        ArrayList<Object> value = this.doc.getPropertyValue(propertyName);
        if (value instanceof Object[]) {
            value = new ArrayList<Object>(Arrays.asList((Object[])value));
        }
        return (T)value;
    }

    @Override
    public List<String> getTargetDocumentsIds() {
        return (List)this.getPropertyValue("nt:targetDocumentsIds");
    }

    @Override
    public String getType() {
        return (String)this.getPropertyValue("nt:type");
    }

    @Override
    public String getVariable(String key) {
        Map<String, String> variables = this.getVariables();
        return variables.get(key);
    }

    @Override
    public Map<String, String> getVariables() {
        List variables = (List)this.getPropertyValue("nt:task_variables");
        HashMap<String, String> variableMap = new HashMap<String, String>(variables.size());
        for (Map map : variables) {
            variableMap.put((String)map.get("key"), (String)map.get("value"));
        }
        return variableMap;
    }

    @Override
    public Boolean hasEnded() {
        return "ended".equals(this.doc.getCurrentLifeCycleState());
    }

    @Override
    public Boolean isAccepted() {
        Boolean isAccepted = (Boolean)this.getPropertyValue("nt:accepted");
        return isAccepted == null ? false : isAccepted;
    }

    @Override
    public Boolean isCancelled() {
        return "cancelled".equals(this.doc.getCurrentLifeCycleState());
    }

    @Override
    public Boolean isOpened() {
        return "opened".equals(this.doc.getCurrentLifeCycleState());
    }

    @Override
    public void setAccepted(Boolean accepted) {
        this.setPropertyValue("nt:accepted", accepted);
    }

    @Override
    public void setActors(List<String> users) {
        this.setPropertyValue("nt:actors", users);
    }

    @Override
    public void setCreated(Date created) {
        this.setPropertyValue("dublincore:created", created);
    }

    @Override
    public void setDelegatedActors(List<String> delegatedActors) {
        this.setPropertyValue("nt:delegatedActors", delegatedActors);
    }

    @Override
    public void setDescription(String description) {
        this.setPropertyValue("dublincore:description", description);
    }

    @Override
    public void setDirective(String directive) {
        this.setPropertyValue("nt:directive", directive);
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.setPropertyValue("nt:dueDate", dueDate);
    }

    @Override
    public void setInitiator(String initiator) {
        this.setPropertyValue("nt:initiator", initiator);
    }

    @Override
    public void setName(String name) {
        this.setPropertyValue("nt:name", name);
    }

    @Override
    public void setProcessId(String processId) {
        this.setPropertyValue("nt:processId", processId);
    }

    @Override
    public void setProcessName(String processName) {
        this.setPropertyValue("nt:processName", processName);
    }

    protected void setPropertyValue(String propertyName, Object value) {
        if (value != null) {
            if (value instanceof Date) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)value);
                this.doc.setPropertyValue(propertyName, (Serializable)cal);
            } else {
                this.doc.setPropertyValue(propertyName, (Serializable)value);
            }
        }
    }

    @Override
    public void setTargetDocumentsIds(List<String> ids) {
        this.setPropertyValue("nt:targetDocumentsIds", ids);
    }

    @Override
    public void setType(String type) {
        this.setPropertyValue("nt:type", type);
    }

    @Override
    public void setVariable(String key, String value) {
        ArrayList variables = (ArrayList)this.getPropertyValue("nt:task_variables");
        if (variables == null) {
            variables = new ArrayList();
        }
        HashMap<String, String> variableMap = new HashMap<String, String>(2);
        variableMap.put("key", key);
        variableMap.put("value", value);
        variables.add(variableMap);
        this.setPropertyValue("nt:task_variables", variables);
    }

    @Override
    public void setVariables(Map<String, String> variables) {
        ArrayList variablesProperty = (ArrayList)this.getPropertyValue("nt:task_variables");
        if (variablesProperty == null) {
            variablesProperty = new ArrayList();
        }
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            if (entry.getValue() == null) continue;
            HashMap<String, Serializable> variable = new HashMap<String, Serializable>(2);
            variable.put("key", (Serializable)((Object)entry.getKey()));
            variable.put("value", (Serializable)((Object)entry.getValue()));
            variablesProperty.add(variable);
        }
        this.setPropertyValue("nt:task_variables", variablesProperty);
    }
}

