/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.jetbrains.annotations.NotNull;

class MyJavaFileManager
implements JavaFileManager {
    private final StandardJavaFileManager fileManager;
    private final Map<String, ByteArrayOutputStream> buffers = new LinkedHashMap<String, ByteArrayOutputStream>();

    MyJavaFileManager(StandardJavaFileManager fileManager) {
        this.fileManager = fileManager;
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        return (Iterable)this.invokeNamedMethodIfAvailable(location, "listLocationsForModules");
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) throws IOException {
        return (String)this.invokeNamedMethodIfAvailable(location, "inferModuleName");
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.fileManager.getClassLoader(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return this.fileManager.list(location, packageName, kinds, recurse);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return this.fileManager.inferBinaryName(location, file);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return this.fileManager.isSameFile(a, b);
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        return this.fileManager.handleOption(current, remaining);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.fileManager.hasLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        if (location == StandardLocation.CLASS_OUTPUT && this.buffers.containsKey(className) && kind == JavaFileObject.Kind.CLASS) {
            final byte[] bytes = this.buffers.get(className).toByteArray();
            return new SimpleJavaFileObject(URI.create(className), kind){

                @Override
                @NotNull
                public InputStream openInputStream() {
                    return new ByteArrayInputStream(bytes);
                }
            };
        }
        return this.fileManager.getJavaFileForInput(location, className, kind);
    }

    @Override
    @NotNull
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        return new SimpleJavaFileObject(URI.create(className), kind){

            @Override
            @NotNull
            public OutputStream openOutputStream() {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                MyJavaFileManager.this.buffers.put(className, baos);
                return baos;
            }
        };
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        return this.fileManager.getFileForInput(location, packageName, relativeName);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        return this.fileManager.getFileForOutput(location, packageName, relativeName, sibling);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.fileManager.close();
    }

    @Override
    public int isSupportedOption(String option) {
        return this.fileManager.isSupportedOption(option);
    }

    public void clearBuffers() {
        this.buffers.clear();
    }

    @NotNull
    public Map<String, byte[]> getAllBuffers() {
        LinkedHashMap<String, byte[]> ret = new LinkedHashMap<String, byte[]>(this.buffers.size() * 2);
        for (Map.Entry<String, ByteArrayOutputStream> entry : this.buffers.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().toByteArray());
        }
        return ret;
    }

    private <T> T invokeNamedMethodIfAvailable(JavaFileManager.Location location, String name) {
        Method[] methods;
        for (Method method : methods = this.fileManager.getClass().getDeclaredMethods()) {
            if (!method.getName().equals(name) || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != JavaFileManager.Location.class) continue;
            try {
                return (T)method.invoke((Object)this.fileManager, location);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException("Unable to invoke method " + name);
            }
            catch (InvocationTargetException e) {
                throw new UnsupportedOperationException("Unable to invoke method " + name);
            }
        }
        throw new UnsupportedOperationException("Unable to find method " + name);
    }
}

