/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.el;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.nuxeo.ecm.platform.el.ExpressionResolver;
import org.nuxeo.ecm.platform.el.Functions;

public class ExpressionContext
extends ELContext {
    private static final Map<String, Method> DEFAULT_FUNCTIONS = Stream.of(Functions.class.getMethods()).filter(m -> Modifier.isStatic(m.getModifiers())).collect(Collectors.toUnmodifiableMap(m -> "nx:" + m.getName(), Function.identity()));
    protected final ELResolver resolver = new ExpressionResolver();
    protected final FunctionMapper functionMapper = new MyFunctionMapper();
    protected final VariableMapper variableMapper = new MyVariableMapper();

    public ELResolver getELResolver() {
        return this.resolver;
    }

    public FunctionMapper getFunctionMapper() {
        return this.functionMapper;
    }

    public VariableMapper getVariableMapper() {
        return this.variableMapper;
    }

    private static class MyFunctionMapper
    extends FunctionMapper {
        private final Map<String, Method> map = new HashMap<String, Method>();

        private MyFunctionMapper() {
        }

        public Method resolveFunction(String prefix, String localName) {
            String key = prefix + ":" + localName;
            return this.map.getOrDefault(key, DEFAULT_FUNCTIONS.get(key));
        }

        public void mapFunction(String prefix, String localName, Method method) {
            this.map.put(prefix + ":" + localName, method);
        }
    }

    private static class MyVariableMapper
    extends VariableMapper {
        protected final Map<String, ValueExpression> map = new HashMap<String, ValueExpression>();

        private MyVariableMapper() {
        }

        public ValueExpression resolveVariable(String variable) {
            return this.map.get(variable);
        }

        public ValueExpression setVariable(String variable, ValueExpression expression) {
            return this.map.put(variable, expression);
        }
    }
}

