/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.BooleanLiteral;
import org.nuxeo.ecm.core.query.sql.model.DateLiteral;
import org.nuxeo.ecm.core.query.sql.model.DoubleLiteral;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IntegerLiteral;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.LiteralList;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;

public class LDAPFilterBuilder {
    protected static final String DATE_CAST = "DATE";
    protected final LDAPDirectory directory;
    public StringBuilder filter = new StringBuilder();
    public int paramIndex = 0;
    public final List<Serializable> params = new ArrayList<Serializable>();

    public LDAPFilterBuilder(LDAPDirectory directory) {
        this.directory = directory;
    }

    public void walk(Expression expression) {
        if (expression instanceof MultiExpression && ((MultiExpression)expression).predicates.isEmpty()) {
            return;
        }
        this.walkExpression(expression);
    }

    public void walkExpression(Expression expr) {
        String cast;
        Operator op = expr.operator;
        Operand lvalue = expr.lvalue;
        Operand rvalue = expr.rvalue;
        Reference ref = lvalue instanceof Reference ? (Reference)lvalue : null;
        String name = ref != null ? ref.name : null;
        String string = cast = ref != null ? ref.cast : null;
        if (DATE_CAST.equals(cast)) {
            this.checkDateLiteralForCast(op, rvalue, name);
        }
        if (op == Operator.SUM) {
            throw new QueryParseException("SUM");
        }
        if (op == Operator.SUB) {
            throw new QueryParseException("SUB");
        }
        if (op == Operator.MUL) {
            throw new QueryParseException("MUL");
        }
        if (op == Operator.DIV) {
            throw new QueryParseException("DIV");
        }
        if (op == Operator.LT) {
            this.walkLt(lvalue, rvalue);
        } else if (op == Operator.GT) {
            this.walkGt(lvalue, rvalue);
        } else if (op == Operator.EQ) {
            this.walkEq(lvalue, rvalue);
        } else if (op == Operator.NOTEQ) {
            this.walkNotEq(lvalue, rvalue);
        } else if (op == Operator.LTEQ) {
            this.walkLtEq(lvalue, rvalue);
        } else if (op == Operator.GTEQ) {
            this.walkGtEq(lvalue, rvalue);
        } else if (op == Operator.AND) {
            if (expr instanceof MultiExpression) {
                this.walkAndMultiExpression((MultiExpression)expr);
            } else {
                this.walkAnd(expr);
            }
        } else if (op == Operator.NOT) {
            this.walkNot(lvalue);
        } else if (op == Operator.OR) {
            if (expr instanceof MultiExpression) {
                this.walkOrMultiExpression((MultiExpression)expr);
            } else {
                this.walkOr(expr);
            }
        } else if (op == Operator.LIKE) {
            this.walkLike(lvalue, rvalue, true, false);
        } else if (op == Operator.ILIKE) {
            this.walkLike(lvalue, rvalue, true, true);
        } else if (op == Operator.NOTLIKE) {
            this.walkLike(lvalue, rvalue, false, false);
        } else if (op == Operator.NOTILIKE) {
            this.walkLike(lvalue, rvalue, false, true);
        } else if (op == Operator.IN) {
            this.walkIn(lvalue, rvalue, true);
        } else if (op == Operator.NOTIN) {
            this.walkIn(lvalue, rvalue, false);
        } else if (op == Operator.ISNULL) {
            this.walkIsNull(lvalue);
        } else if (op == Operator.ISNOTNULL) {
            this.walkIsNotNull(lvalue);
        } else if (op == Operator.BETWEEN) {
            this.walkBetween(lvalue, rvalue, true);
        } else if (op == Operator.NOTBETWEEN) {
            this.walkBetween(lvalue, rvalue, false);
        } else {
            throw new QueryParseException("Unknown operator: " + op);
        }
    }

    protected void checkDateLiteralForCast(Operator op, Operand value, String name) {
        if (op == Operator.BETWEEN || op == Operator.NOTBETWEEN) {
            LiteralList l = (LiteralList)value;
            this.checkDateLiteralForCast((Operand)l.get(0), name);
            this.checkDateLiteralForCast((Operand)l.get(1), name);
        } else {
            this.checkDateLiteralForCast(value, name);
        }
    }

    protected void checkDateLiteralForCast(Operand value, String name) {
        if (value instanceof DateLiteral && !((DateLiteral)value).onlyDate) {
            throw new QueryParseException("DATE() cast must be used with DATE literal, not TIMESTAMP: " + name);
        }
    }

    public void walkNot(Operand value) {
        this.filter.append("(!");
        this.walkOperand(value);
        this.filter.append(')');
    }

    public void walkIsNull(Operand value) {
        this.filter.append("(!");
        this.walkIsNotNull(value);
        this.filter.append(')');
    }

    public void walkIsNotNull(Operand value) {
        this.filter.append('(');
        this.walkReference(value);
        this.filter.append("=*)");
    }

    public void walkAndMultiExpression(MultiExpression expr) {
        this.walkMulti("&", expr.predicates);
    }

    public void walkAnd(Expression expr) {
        this.walkMulti("&", Arrays.asList(expr.lvalue, expr.rvalue));
    }

    public void walkOrMultiExpression(MultiExpression expr) {
        this.walkMulti("|", expr.predicates);
    }

    public void walkOr(Expression expr) {
        this.walkMulti("|", Arrays.asList(expr.lvalue, expr.rvalue));
    }

    protected void walkMulti(String op, List<? extends Operand> values) {
        if (values.size() == 1) {
            this.walkOperand(values.get(0));
        } else {
            this.filter.append('(');
            this.filter.append(op);
            for (Operand operand : values) {
                this.walkOperand(operand);
            }
            this.filter.append(')');
        }
    }

    public void walkEq(Operand lvalue, Operand rvalue) {
        this.walkBinOp("=", lvalue, rvalue);
    }

    public void walkNotEq(Operand lvalue, Operand rvalue) {
        this.filter.append("(!");
        this.walkEq(lvalue, rvalue);
        this.filter.append(')');
    }

    public void walkLt(Operand lvalue, Operand rvalue) {
        this.walkBinOp("<", lvalue, rvalue);
    }

    public void walkGt(Operand lvalue, Operand rvalue) {
        this.walkBinOp(">", lvalue, rvalue);
    }

    public void walkLtEq(Operand lvalue, Operand rvalue) {
        this.walkBinOp("<=", lvalue, rvalue);
    }

    public void walkGtEq(Operand lvalue, Operand rvalue) {
        this.walkBinOp(">=", lvalue, rvalue);
    }

    protected void walkBinOp(String op, Operand lvalue, Operand rvalue) {
        this.filter.append('(');
        Field field = this.walkReference(lvalue);
        this.filter.append(op);
        if (field.getType() instanceof BooleanType) {
            rvalue = this.makeBoolean(rvalue);
        }
        this.walkLiteral(rvalue);
        this.filter.append(')');
    }

    protected Operand makeBoolean(Operand rvalue) {
        long v;
        if (rvalue instanceof BooleanLiteral) {
            return rvalue;
        }
        if (!(rvalue instanceof IntegerLiteral) || (v = ((IntegerLiteral)rvalue).value) != 0L && v != 1L) {
            throw new QueryParseException("Boolean expressions require boolean or literal 0 or 1 as right argument");
        }
        return new BooleanLiteral(v == 1L);
    }

    public void walkBetween(Operand lvalue, Operand rvalue, boolean positive) {
        LiteralList list = (LiteralList)rvalue;
        Literal left = (Literal)list.get(0);
        Literal right = (Literal)list.get(1);
        if (!positive) {
            this.filter.append("(!");
        }
        this.filter.append("(&");
        this.walkGtEq(lvalue, (Operand)left);
        this.walkLtEq(lvalue, (Operand)right);
        this.filter.append(')');
        if (!positive) {
            this.filter.append(')');
        }
    }

    public void walkIn(Operand lvalue, Operand rvalue, boolean positive) {
        if (!positive) {
            this.filter.append("(!");
        }
        this.filter.append("(|");
        for (Literal value : (LiteralList)rvalue) {
            this.walkEq(lvalue, (Operand)value);
        }
        this.filter.append(')');
        if (!positive) {
            this.filter.append(')');
        }
    }

    public void walkLike(Operand lvalue, Operand rvalue, boolean positive, boolean caseInsensitive) {
        if (!(rvalue instanceof StringLiteral)) {
            throw new QueryParseException("Invalid LIKE, right hand side must be a string: " + rvalue);
        }
        String like = ((StringLiteral)rvalue).value;
        if (caseInsensitive) {
            like = like.toLowerCase();
        }
        if (!positive) {
            this.filter.append("(!");
        }
        this.filter.append('(');
        this.walkReference(lvalue);
        this.filter.append('=');
        this.walkLikeWildcard(like);
        this.filter.append(')');
        if (!positive) {
            this.filter.append(')');
        }
    }

    public void walkLikeWildcard(String like) {
        StringBuilder param = new StringBuilder();
        char[] chars = like.toCharArray();
        boolean escape = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            boolean escapeNext = false;
            if (escape) {
                param.append(c);
            } else {
                switch (c) {
                    case '%': {
                        if (param.length() != 0) {
                            this.addFilterParam((Serializable)((Object)param.toString()));
                            param.setLength(0);
                        }
                        this.filter.append('*');
                        break;
                    }
                    case '_': {
                        param.append(c);
                        break;
                    }
                    case '\\': {
                        escapeNext = true;
                        break;
                    }
                    default: {
                        param.append(c);
                    }
                }
            }
            escape = escapeNext;
        }
        if (escape) {
            throw new QueryParseException("Invalid LIKE parameter ending with escape character");
        }
        if (param.length() != 0) {
            this.addFilterParam((Serializable)((Object)param.toString()));
        }
    }

    public void walkOperand(Operand operand) {
        if (operand instanceof Literal) {
            this.walkLiteral(operand);
        } else if (operand instanceof Function) {
            this.walkFunction((Function)operand);
        } else if (operand instanceof Expression) {
            this.walkExpression((Expression)operand);
        } else if (operand instanceof Reference) {
            this.walkReference(operand);
        } else {
            throw new QueryParseException("Unknown operand: " + operand);
        }
    }

    public void walkLiteral(Operand operand) {
        if (!(operand instanceof Literal)) {
            throw new QueryParseException("Requires literal instead of: " + operand);
        }
        Literal lit = (Literal)operand;
        if (lit instanceof BooleanLiteral) {
            this.walkBooleanLiteral((BooleanLiteral)lit);
        } else if (lit instanceof DateLiteral) {
            this.walkDateLiteral((DateLiteral)lit);
        } else if (lit instanceof DoubleLiteral) {
            this.walkDoubleLiteral((DoubleLiteral)lit);
        } else if (lit instanceof IntegerLiteral) {
            this.walkIntegerLiteral((IntegerLiteral)lit);
        } else if (lit instanceof StringLiteral) {
            this.walkStringLiteral((StringLiteral)lit);
        } else {
            throw new QueryParseException("Unknown literal: " + lit);
        }
    }

    public void walkBooleanLiteral(BooleanLiteral lit) {
        this.addFilterParam(Boolean.valueOf(lit.value));
    }

    public void walkDateLiteral(DateLiteral lit) {
        if (lit.onlyDate) {
            throw new QueryParseException("Cannot use only date in LDAP query: " + lit);
        }
        this.addFilterParam(lit.toCalendar());
    }

    public void walkDoubleLiteral(DoubleLiteral lit) {
        this.addFilterParam(Double.valueOf(lit.value));
    }

    public void walkIntegerLiteral(IntegerLiteral lit) {
        this.addFilterParam(Long.valueOf(lit.value));
    }

    public void walkStringLiteral(StringLiteral lit) {
        this.addFilterParam((Serializable)((Object)lit.value));
    }

    protected void addFilterParam(Serializable value) {
        this.filter.append('{');
        this.filter.append(this.paramIndex++);
        this.filter.append('}');
        this.params.add(value);
    }

    public Object walkFunction(Function func) {
        throw new QueryParseException(func.name);
    }

    public Field walkReference(Operand value) {
        if (!(value instanceof Reference)) {
            throw new QueryParseException("Invalid query, left hand side must be a property: " + value);
        }
        String name = ((Reference)value).name;
        if (this.directory.isReference(name)) {
            throw new QueryParseException("Column: " + name + " is a reference and cannot be queried for directory: " + this.directory.getName());
        }
        Field field = (Field)this.directory.getSchemaFieldMap().get(name);
        if (field == null) {
            throw new QueryParseException("No column: " + name + " for directory: " + this.directory.getName());
        }
        String backend = this.directory.getFieldMapper().getBackendField(name);
        this.filter.append(backend);
        return field;
    }
}

