/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javasimon.Simon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataCollector {
    private final Map<Simon, List<Double>> data = new LinkedHashMap<Simon, List<Double>>();
    private int samples;

    public AbstractDataCollector(Simon ... simons) {
        for (Simon simon : simons) {
            this.data.put(simon, new ArrayList());
        }
    }

    public final void collect() {
        for (Simon simon : this.data.keySet()) {
            this.data.get(simon).add(this.obtainValue(simon));
        }
        ++this.samples;
    }

    public final int sampleCount() {
        return this.samples;
    }

    public final Set<Simon> getSimons() {
        return Collections.unmodifiableSet(this.data.keySet());
    }

    public final List<Double> valuesFor(Simon simon) {
        return Collections.unmodifiableList(this.data.get(simon));
    }

    public abstract double obtainValue(Simon var1);
}

