/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import java.util.regex.Pattern;

public final class Replacer {
    private final Pattern from;
    private final String to;
    private final boolean repeatUntilUnchanged;

    public Replacer(String from, String to) {
        this(from, to, false);
    }

    public Replacer(String from, String to, boolean repeatUntilUnchanged) {
        this.from = Pattern.compile(from);
        this.to = to;
        this.repeatUntilUnchanged = repeatUntilUnchanged;
    }

    public String process(String in) {
        if (this.repeatUntilUnchanged) {
            String retVal = in;
            String old = "";
            while (!old.equals(retVal)) {
                old = retVal;
                retVal = this.from.matcher(retVal).replaceAll(this.to);
            }
            return retVal;
        }
        return this.from.matcher(in).replaceAll(this.to);
    }

    public String toString() {
        return "Replacer{from='" + this.from.pattern() + '\'' + ", to='" + this.to + '\'' + ", untilUnchanged=" + this.repeatUntilUnchanged + '}';
    }
}

