/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import freemarker.template.TemplateException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.common.Environment;
import org.nuxeo.common.codec.Crypto;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.launcher.commons.DatabaseDriverException;
import org.nuxeo.launcher.config.BackingServiceConfigurator;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.JVMVersion;
import org.nuxeo.launcher.config.ServerConfigurator;
import org.nuxeo.log4j.Log4JHelper;

public class ConfigurationGenerator {
    private static final Logger log = LogManager.getLogger(ConfigurationGenerator.class);
    public static final String NUXEO_ENVIRONMENT = "NUXEO_ENVIRONMENT";
    public static final String NUXEO_PROFILES = "NUXEO_PROFILES";
    public static final String TEMPLATE_SEPARATOR = ",";
    public static final String[] COMPLIANT_JAVA_VERSIONS = new String[]{"1.8.0_40", "11"};
    protected static final String CONFIGURATION_PROPERTIES = "configuration.properties";
    public static final String NUXEO_CONF = "nuxeo.conf";
    public static final String TEMPLATES = "templates";
    public static final String NUXEO_DEFAULT_CONF = "nuxeo.defaults";
    public static final String NUXEO_ENVIRONMENT_CONF_FORMAT = "nuxeo.%s";
    public static final String PARAM_TEMPLATES_NAME = "nuxeo.templates";
    public static final String PARAM_TEMPLATE_DBNAME = "nuxeo.dbtemplate";
    public static final String PARAM_TEMPLATE_DBSECONDARY_NAME = "nuxeo.dbnosqltemplate";
    public static final String PARAM_TEMPLATE_DBTYPE = "nuxeo.db.type";
    public static final String PARAM_TEMPLATE_DBSECONDARY_TYPE = "nuxeo.dbsecondary.type";
    public static final String OLD_PARAM_TEMPLATES_PARSING_EXTENSIONS = "nuxeo.templates.parsing.extensions";
    public static final String PARAM_TEMPLATES_PARSING_EXTENSIONS = "nuxeo.plaintext_parsing_extensions";
    public static final String PARAM_TEMPLATES_FREEMARKER_EXTENSIONS = "nuxeo.freemarker_parsing_extensions";
    protected static final String PARAM_INCLUDED_TEMPLATES = "nuxeo.template.includes";
    public static final String PARAM_FORCE_GENERATION = "nuxeo.force.generation";
    public static final String BOUNDARY_BEGIN = "### BEGIN - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final String BOUNDARY_END = "### END - DO NOT EDIT BETWEEN BEGIN AND END ###";
    public static final List<String> DB_LIST = Arrays.asList("default", "mongodb", "postgresql", "oracle", "mysql", "mariadb", "mssql", "db2");
    public static final List<String> DB_SECONDARY_LIST = Collections.singletonList("none");
    public static final List<String> DB_EXCLUDE_CHECK_LIST = Arrays.asList("default", "none", "mongodb");
    @Deprecated(since="11.1")
    public static final String PARAM_WIZARD_DONE = "nuxeo.wizard.done";
    @Deprecated(since="11.1")
    public static final String PARAM_WIZARD_RESTART_PARAMS = "wizard.restart.params";
    public static final String PARAM_FAKE_WINDOWS = "org.nuxeo.fake.vindoz";
    public static final String PARAM_LOOPBACK_URL = "nuxeo.loopback.url";
    public static final int MIN_PORT = 1;
    public static final int MAX_PORT = 65535;
    public static final int ADDRESS_PING_TIMEOUT = 1000;
    public static final String PARAM_BIND_ADDRESS = "nuxeo.bind.address";
    public static final String PARAM_HTTP_PORT = "nuxeo.server.http.port";
    @Deprecated
    public static final String PARAM_STATUS_KEY = "server.status.key";
    public static final String PARAM_CONTEXT_PATH = "org.nuxeo.ecm.contextPath";
    @Deprecated(since="11.1")
    public static final String PARAM_MP_DIR = "nuxeo.distribution.marketplace.dir";
    @Deprecated(since="11.1")
    public static final String DISTRIBUTION_MP_DIR = "setupWizardDownloads";
    public static final String INSTALL_AFTER_RESTART = "installAfterRestart.log";
    public static final String PARAM_DB_DRIVER = "nuxeo.db.driver";
    public static final String PARAM_DB_JDBC_URL = "nuxeo.db.jdbc.url";
    public static final String PARAM_DB_HOST = "nuxeo.db.host";
    public static final String PARAM_DB_PORT = "nuxeo.db.port";
    public static final String PARAM_DB_NAME = "nuxeo.db.name";
    public static final String PARAM_DB_USER = "nuxeo.db.user";
    public static final String PARAM_DB_PWD = "nuxeo.db.password";
    @Deprecated(since="11.1")
    public static final String PARAM_MONGODB_NAME = "nuxeo.mongodb.dbname";
    @Deprecated(since="11.1")
    public static final String PARAM_MONGODB_SERVER = "nuxeo.mongodb.server";
    private static final Pattern ENV_VALUE_PATTERN = Pattern.compile("\\$\\{env(?<boolean>\\?\\?)?:(?<envparam>\\w*)(:?(?<defaultvalue>.*?)?)?\\}");
    protected static final Pattern JAVA_OPTS_PATTERN = Pattern.compile("[ ]+(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
    public static final List<String> SECRET_KEYS = Arrays.asList("nuxeo.db.password", "mailservice.password", "mail.transport.password", "nuxeo.http.proxy.password", "nuxeo.ldap.bindpassword", "nuxeo.user.emergency.password");
    @Deprecated
    public static final String PARAM_PRODUCT_NAME = "org.nuxeo.ecm.product.name";
    @Deprecated
    public static final String PARAM_PRODUCT_VERSION = "org.nuxeo.ecm.product.version";
    public static final String PARAM_NUXEO_URL = "nuxeo.url";
    public static final String NUXEO_DEV_SYSTEM_PROP = "org.nuxeo.dev";
    public static final String SEAM_DEBUG_SYSTEM_PROP = "org.nuxeo.seam.debug";
    public static final String JVMCHECK_PROP = "jvmcheck";
    public static final String JVMCHECK_FAIL = "fail";
    public static final String JVMCHECK_NOFAIL = "nofail";
    public static final String JAVA_OPTS_PROP = "launcher.java.opts";
    public static final String VERSIONED_REGEX = "(-\\d+(\\.\\d+)*)?";
    public static final String BOOTSTRAP_JAR_REGEX = "bootstrap(-\\d+(\\.\\d+)*)?.jar";
    public static final String JULI_JAR_REGEX = "tomcat-juli(-\\d+(\\.\\d+)*)?.jar";
    private final File nuxeoHome;
    private final File nuxeoBinDir;
    private final File nuxeoConf;
    private final File nuxeoTemplates;
    private final List<File> includedTemplates = new ArrayList<File>();
    private final ServerConfigurator serverConfigurator;
    private final BackingServiceConfigurator backingServicesConfigurator;
    private boolean forceGeneration;
    private Properties defaultConfig;
    private CryptoProperties userConfig;
    private boolean configurable = false;
    private boolean onceGeneration = false;
    private String templates;
    private boolean setOnceToFalse = true;
    private boolean setFalseToOnce = false;
    private final Level logLevel;
    private static boolean hideDeprecationWarnings = false;
    private Environment env;
    private Properties storedConfig;
    private String currentConfigurationDigest;
    protected static final Map<String, String> parametersMigration = Map.ofEntries(Map.entry("nuxeo.templates.parsing.extensions", "nuxeo.plaintext_parsing_extensions"), Map.entry("nuxeo.db.user.separator.key", "nuxeo.db.user_separator_key"), Map.entry("mail.pop3.host", "mail.store.host"), Map.entry("mail.pop3.port", "mail.store.port"), Map.entry("mail.smtp.host", "mail.transport.host"), Map.entry("mail.smtp.port", "mail.transport.port"), Map.entry("mail.smtp.username", "mail.transport.username"), Map.entry("mail.transport.username", "mail.transport.user"), Map.entry("mail.smtp.password", "mail.transport.password"), Map.entry("mail.smtp.usetls", "mail.transport.usetls"), Map.entry("mail.smtp.auth", "mail.transport.auth"), Map.entry("nuxeo.server.tomcat-admin.port", "nuxeo.server.tomcat_admin.port"));

    public ConfigurationGenerator() {
        this(true, false);
    }

    public ConfigurationGenerator(boolean quiet, boolean debug) {
        File userDir;
        this.logLevel = quiet ? Level.DEBUG : Level.INFO;
        File serverHome = Environment.getDefault().getServerHome();
        this.nuxeoHome = serverHome != null ? serverHome.getAbsoluteFile() : ("bin".equalsIgnoreCase((userDir = new File(System.getProperty("user.dir"))).getName()) ? userDir.getParentFile().getAbsoluteFile() : userDir.getAbsoluteFile());
        this.nuxeoBinDir = new File(this.nuxeoHome, "bin");
        String nuxeoConfPath = System.getProperty(NUXEO_CONF);
        this.nuxeoConf = nuxeoConfPath != null ? new File(nuxeoConfPath).getAbsoluteFile() : new File(this.nuxeoHome, "bin" + File.separator + NUXEO_CONF).getAbsoluteFile();
        System.setProperty(NUXEO_CONF, this.nuxeoConf.getPath());
        this.nuxeoTemplates = new File(this.nuxeoHome, TEMPLATES);
        this.serverConfigurator = new ServerConfigurator(this);
        if (LoggerContext.getContext((boolean)false).getRootLogger().getAppenders().isEmpty()) {
            this.serverConfigurator.initLogs();
        }
        this.backingServicesConfigurator = new BackingServiceConfigurator(this);
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.nuxeoHome::getPath;
        log.log(this.logLevel, "Nuxeo home:          {}", supplierArray);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = this.nuxeoConf::getPath;
        log.log(this.logLevel, "Nuxeo configuration: {}", supplierArray2);
        String nuxeoProfiles = this.getEnvironment(NUXEO_PROFILES);
        if (StringUtils.isNotBlank((CharSequence)nuxeoProfiles)) {
            log.log(this.logLevel, "Nuxeo profiles:      {}", (Object)nuxeoProfiles);
        }
    }

    public boolean isConfigurable() {
        return this.configurable;
    }

    protected Properties getStoredConfig() {
        if (this.storedConfig == null) {
            this.updateStoredConfig();
        }
        return this.storedConfig;
    }

    public void hideDeprecationWarnings(boolean hide) {
        hideDeprecationWarnings = hide;
    }

    public void setForceGeneration(boolean forceGeneration) {
        this.forceGeneration = forceGeneration;
    }

    public boolean isForceGeneration() {
        return this.forceGeneration;
    }

    public CryptoProperties getUserConfig() {
        return this.userConfig;
    }

    public final ServerConfigurator getServerConfigurator() {
        return this.serverConfigurator;
    }

    public void run() throws ConfigurationException {
        if (this.init()) {
            if (!this.serverConfigurator.isConfigured()) {
                log.info("No current configuration, generating files...");
                this.generateFiles();
            } else if (this.forceGeneration) {
                log.info("Configuration files generation (nuxeo.force.generation={})...", new Supplier[]{() -> this.userConfig.getProperty(PARAM_FORCE_GENERATION)});
                this.generateFiles();
            } else {
                log.info("Server already configured (set nuxeo.force.generation=true to force configuration files generation).");
            }
        }
    }

    public boolean init() {
        return this.init(false);
    }

    public boolean init(boolean forceReload) {
        if (!this.nuxeoConf.exists()) {
            log.info("Missing {}", (Object)this.nuxeoConf);
            this.configurable = false;
            this.userConfig = new CryptoProperties();
            this.defaultConfig = new Properties();
        } else if (this.userConfig == null || this.userConfig.size() == 0 || forceReload) {
            try {
                if (forceReload) {
                    this.templates = null;
                }
                this.setBasicConfiguration();
                this.configurable = true;
            }
            catch (ConfigurationException e) {
                log.warn("Error reading basic configuration.", (Throwable)e);
                this.configurable = false;
            }
        } else {
            this.configurable = true;
        }
        return this.configurable;
    }

    public String changeTemplates(String newTemplates) {
        String oldTemplates = this.templates;
        this.templates = newTemplates;
        try {
            this.setBasicConfiguration(false);
            this.configurable = true;
        }
        catch (ConfigurationException e) {
            log.warn("Error reading basic configuration.", (Throwable)e);
            this.configurable = false;
        }
        return oldTemplates;
    }

    public void changeDBTemplate(String dbTemplate) {
        this.changeTemplates(this.rebuildTemplatesStr(dbTemplate));
    }

    private void setBasicConfiguration() throws ConfigurationException {
        this.setBasicConfiguration(true);
    }

    private void setBasicConfiguration(boolean save) throws ConfigurationException {
        if (this.isInvalidNuxeoDefaults(this.nuxeoTemplates)) {
            throw new ConfigurationException("Missing nuxeo.defaults configuration in: " + this.nuxeoTemplates);
        }
        try {
            this.defaultConfig = this.loadNuxeoDefaults(this.nuxeoTemplates);
            this.defaultConfig.putAll((Map<?, ?>)System.getProperties());
            this.userConfig = new CryptoProperties(this.defaultConfig);
            if (SystemUtils.IS_OS_WINDOWS) {
                this.replaceBackslashes();
            }
            this.userConfig.putAll((Map)ConfigurationGenerator.loadTrimmedProperties(this.nuxeoConf));
            this.onceGeneration = "once".equals(this.userConfig.getProperty(PARAM_FORCE_GENERATION));
            this.forceGeneration = this.onceGeneration || Boolean.parseBoolean(this.userConfig.getProperty(PARAM_FORCE_GENERATION, "false"));
            this.checkForDeprecatedParameters((Properties)this.userConfig);
            this.setDirectoryWithProperty("nuxeo.data.dir");
            this.setDirectoryWithProperty("nuxeo.log.dir");
            this.setDirectoryWithProperty("nuxeo.pid.dir");
            this.setDirectoryWithProperty("nuxeo.tmp.dir");
            this.setDirectoryWithProperty("nuxeo.mp.dir");
        }
        catch (NullPointerException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file: " + this.nuxeoConf, e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        try {
            this.includeTemplates();
            this.checkForDeprecatedParameters(this.defaultConfig);
            this.extractDatabaseTemplateName();
            this.extractSecondaryDatabaseTemplateName();
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        Map<String, String> newParametersToSave = this.evalDynamicProperties();
        if (save && newParametersToSave != null && !newParametersToSave.isEmpty()) {
            this.saveConfiguration(newParametersToSave, false, false);
        }
        this.logDebugInformation();
    }

    protected void includeTemplates() throws IOException {
        this.includedTemplates.clear();
        Object templates = this.getUserTemplates();
        String profiles = this.getEnvironment(NUXEO_PROFILES);
        if (StringUtils.isNotBlank((CharSequence)profiles)) {
            templates = (String)templates + TEMPLATE_SEPARATOR + profiles;
        }
        List<File> orderedTemplates = this.includeTemplates((String)templates);
        this.includedTemplates.clear();
        this.includedTemplates.addAll(orderedTemplates);
        log.debug(this.includedTemplates);
    }

    private void logDebugInformation() {
        String devPropValue = this.userConfig.getProperty(NUXEO_DEV_SYSTEM_PROP);
        if (Boolean.parseBoolean(devPropValue)) {
            log.debug("Nuxeo Dev mode enabled");
        } else {
            log.debug("Nuxeo Dev mode is not enabled");
        }
        String seamDebugPropValue = this.userConfig.getProperty(SEAM_DEBUG_SYSTEM_PROP);
        if (Boolean.parseBoolean(seamDebugPropValue)) {
            log.debug("Nuxeo Seam HotReload is enabled");
        } else {
            log.debug("Nuxeo Seam HotReload is not enabled");
        }
    }

    protected Map<String, String> evalDynamicProperties() throws ConfigurationException {
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        this.evalEnvironmentVariables(newParametersToSave);
        this.evalLoopbackURL();
        this.evalServerStatusKey(newParametersToSave);
        return newParametersToSave;
    }

    protected void evalEnvironmentVariables(Map<String, String> newParametersToSave) {
        for (Object keyObject : this.userConfig.keySet()) {
            String newValue;
            String key = (String)keyObject;
            String value = this.userConfig.getProperty(key);
            if (!StringUtils.isNotBlank((CharSequence)value) || value.equals(newValue = this.replaceEnvironmentVariables(value))) continue;
            newParametersToSave.put(key, newValue);
        }
    }

    private String replaceEnvironmentVariables(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        Matcher matcher = ENV_VALUE_PATTERN.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            boolean booleanValue = "??".equals(matcher.group("boolean"));
            String envVarName = matcher.group("envparam");
            String defaultValue = matcher.group("defaultvalue");
            String envValue = this.getEnvironment(envVarName);
            String result = booleanValue ? (StringUtils.isBlank((CharSequence)envValue) ? "false" : "true") : (StringUtils.isBlank((CharSequence)envValue) ? defaultValue : envValue);
            matcher.appendReplacement(sb, result);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private void evalServerStatusKey(Map<String, String> newParametersToSave) {
        if (this.userConfig.getProperty(PARAM_STATUS_KEY) == null) {
            newParametersToSave.put(PARAM_STATUS_KEY, UUID.randomUUID().toString().substring(0, 8));
        }
    }

    private void evalLoopbackURL() throws ConfigurationException {
        Object loopbackURL = this.userConfig.getProperty(PARAM_LOOPBACK_URL);
        if (loopbackURL != null) {
            log.debug("Using configured loop back url: {}", loopbackURL);
            return;
        }
        InetAddress bindAddress = this.getBindAddress();
        String httpPort = this.userConfig.getProperty(PARAM_HTTP_PORT);
        String contextPath = this.userConfig.getProperty(PARAM_CONTEXT_PATH);
        loopbackURL = bindAddress instanceof Inet6Address ? "http://[" + bindAddress.getHostAddress() + "]:" + httpPort + contextPath : "http://" + bindAddress.getHostAddress() + ":" + httpPort + contextPath;
        log.debug("Set as loop back URL: {}", loopbackURL);
        this.defaultConfig.setProperty(PARAM_LOOPBACK_URL, (String)loopbackURL);
    }

    protected void replaceBackslashes() throws ConfigurationException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.nuxeoConf));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.matches(".*:\\\\.*")) {
                    line = line.replaceAll("\\\\", "/");
                }
                sb.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        try (FileWriter writer = new FileWriter(this.nuxeoConf, false);){
            writer.append(sb.toString());
        }
        catch (IOException e) {
            throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
        }
    }

    public void setDirectoryWithProperty(String key) {
        String directory = this.userConfig.getProperty(key);
        if (directory == null) {
            this.defaultConfig.setProperty(key, this.serverConfigurator.getDirectory(key).getPath());
        } else {
            this.serverConfigurator.setDirectory(key, directory);
        }
    }

    public String getUserTemplates() {
        if (this.templates == null) {
            this.templates = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        }
        if (this.templates == null) {
            log.warn("No template found in configuration! Fallback on 'default'.");
            this.templates = "default";
        }
        this.templates = this.replaceEnvironmentVariables(this.templates);
        this.userConfig.setProperty(PARAM_TEMPLATES_NAME, this.templates);
        return this.templates;
    }

    protected void generateFiles() throws ConfigurationException {
        try {
            this.serverConfigurator.parseAndCopy((Properties)this.userConfig);
            this.serverConfigurator.dumpProperties(this.userConfig);
            log.info("Configuration files generated.");
            if (this.onceGeneration) {
                this.setOnceToFalse = true;
                this.writeConfiguration();
            }
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Missing file: " + e.getMessage(), e);
        }
        catch (freemarker.core.ParseException | TemplateException e) {
            throw new ConfigurationException("Could not process FreeMarker template: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Configuration failure: " + e.getMessage(), e);
        }
    }

    private List<File> includeTemplates(String templatesList) throws IOException {
        ArrayList<File> orderedTemplates = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(templatesList, TEMPLATE_SEPARATOR);
        while (st.hasMoreTokens()) {
            String nextToken = this.replaceEnvironmentVariables(st.nextToken());
            File chosenTemplate = new File(nextToken);
            if (!chosenTemplate.exists() || !chosenTemplate.getPath().equals(chosenTemplate.getAbsolutePath())) {
                chosenTemplate = new File(this.nuxeoTemplates, nextToken);
            }
            if (this.includedTemplates.contains(chosenTemplate)) {
                log.debug("Already included {}", (Object)nextToken);
                continue;
            }
            if (!chosenTemplate.exists()) {
                log.error("Template '{}' not found with relative or absolute path ({}). Check your {} parameter, and {} for included files.", (Object)nextToken, (Object)chosenTemplate, (Object)PARAM_TEMPLATES_NAME, (Object)PARAM_INCLUDED_TEMPLATES);
                continue;
            }
            this.includedTemplates.add(chosenTemplate);
            if (this.isInvalidNuxeoDefaults(chosenTemplate)) {
                log.warn("Ignore template (no default configuration): {}", (Object)nextToken);
                continue;
            }
            Properties templateProperties = this.loadNuxeoDefaults(chosenTemplate);
            String subTemplatesList = this.replaceEnvironmentVariables(templateProperties.getProperty(PARAM_INCLUDED_TEMPLATES));
            if (StringUtils.isNotEmpty((CharSequence)subTemplatesList)) {
                orderedTemplates.addAll(this.includeTemplates(subTemplatesList));
            }
            this.defaultConfig.putAll((Map<?, ?>)templateProperties);
            orderedTemplates.add(chosenTemplate);
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = chosenTemplate::getPath;
            log.log(this.logLevel, "Include template: {}", supplierArray);
        }
        return orderedTemplates;
    }

    protected void checkForDeprecatedParameters(Properties properties) {
        Enumeration<?> userEnum = properties.propertyNames();
        while (userEnum.hasMoreElements()) {
            String key = (String)userEnum.nextElement();
            if (!parametersMigration.containsKey(key)) continue;
            String value = properties.getProperty(key);
            properties.setProperty(parametersMigration.get(key), value);
            if (hideDeprecationWarnings) continue;
            log.warn("Parameter {} is deprecated - please use {} instead", (Object)key, (Object)parametersMigration.get(key));
        }
    }

    public File getNuxeoHome() {
        return this.nuxeoHome;
    }

    public File getNuxeoBinDir() {
        return this.nuxeoBinDir;
    }

    @Deprecated(since="11.1")
    public File getNuxeoDefaultConf() {
        return new File(this.nuxeoTemplates, NUXEO_DEFAULT_CONF);
    }

    public List<File> getIncludedTemplates() {
        return this.includedTemplates;
    }

    public void saveConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        this.saveConfiguration(changedParameters, false, true);
    }

    public void saveConfiguration(Map<String, String> changedParameters, boolean setGenerationOnceToFalse, boolean setGenerationFalseToOnce) throws ConfigurationException {
        this.setOnceToFalse = setGenerationOnceToFalse;
        this.setFalseToOnce = setGenerationFalseToOnce;
        this.updateStoredConfig();
        String newDbTemplate = changedParameters.remove(PARAM_TEMPLATE_DBNAME);
        if (newDbTemplate != null) {
            changedParameters.put(PARAM_TEMPLATES_NAME, this.rebuildTemplatesStr(newDbTemplate));
        }
        if ((newDbTemplate = changedParameters.remove(PARAM_TEMPLATE_DBSECONDARY_NAME)) != null) {
            changedParameters.put(PARAM_TEMPLATES_NAME, this.rebuildTemplatesStr(newDbTemplate));
        }
        if (changedParameters.containsValue(null) || changedParameters.containsValue("")) {
            HashSet<String> propertiesToUnset = new HashSet<String>();
            for (Map.Entry<String, String> entry : changedParameters.entrySet()) {
                if (!StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
                propertiesToUnset.add(entry.getKey());
            }
            for (String key : propertiesToUnset) {
                changedParameters.remove(key);
                this.userConfig.remove((Object)key);
            }
        }
        this.userConfig.putAll(changedParameters);
        this.writeConfiguration();
        this.updateStoredConfig();
    }

    private void updateStoredConfig() {
        if (this.storedConfig == null) {
            this.storedConfig = new Properties(this.defaultConfig);
        } else {
            this.storedConfig.clear();
        }
        this.storedConfig.putAll((Map<?, ?>)this.userConfig);
    }

    public void saveFilteredConfiguration(Map<String, String> changedParameters) throws ConfigurationException {
        Map<String, String> filteredParameters = this.getChangedParameters(changedParameters);
        this.saveConfiguration(filteredParameters);
    }

    public Map<String, String> getChangedParameters(Map<String, String> changedParameters) {
        HashMap<String, String> filteredChangedParameters = new HashMap<String, String>();
        for (String key : changedParameters.keySet()) {
            String oldParam = this.getStoredConfig().getProperty(key);
            String newParam = changedParameters.get(key);
            if (newParam != null) {
                newParam = newParam.trim();
            }
            if ((oldParam != null || !StringUtils.isNotEmpty((CharSequence)newParam)) && (oldParam == null || oldParam.trim().equals(newParam))) continue;
            filteredChangedParameters.put(key, newParam);
        }
        return filteredChangedParameters;
    }

    private void writeConfiguration() throws ConfigurationException {
        final MessageDigest newContentDigest = DigestUtils.getMd5Digest();
        StringWriter newContent = new StringWriter(){

            @Override
            public void write(String str) {
                if (str != null) {
                    newContentDigest.update(str.getBytes());
                }
                super.write(str);
            }
        };
        newContent.append(this.readConfiguration());
        newContent.write(BOUNDARY_BEGIN + System.getProperty("line.separator"));
        for (Object o : new TreeSet(this.userConfig.keySet())) {
            String key = (String)o;
            if (PARAM_FORCE_GENERATION.equals(key) || PARAM_TEMPLATES_NAME.equals(key)) continue;
            String oldValue = this.storedConfig.getProperty(key, "");
            String newValue = this.userConfig.getRawProperty(key, "");
            if (newValue.equals(oldValue)) continue;
            newContent.write("#" + key + "=" + oldValue + System.getProperty("line.separator"));
            newContent.write(key + "=" + newValue + System.getProperty("line.separator"));
        }
        newContent.write(BOUNDARY_END + System.getProperty("line.separator"));
        if (!Hex.encodeHexString((byte[])newContentDigest.digest()).equals(this.currentConfigurationDigest)) {
            try (FileWriter writer = new FileWriter(this.nuxeoConf, false);){
                ((Writer)writer).append(newContent.getBuffer());
            }
            catch (IOException e) {
                throw new ConfigurationException("Error writing in " + this.nuxeoConf, e);
            }
        }
    }

    private StringBuilder readConfiguration() throws ConfigurationException {
        String templatesParam = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        Integer generationIndex = null;
        Integer templatesIndex = null;
        ArrayList<Object> newLines = new ArrayList<Object>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.nuxeoConf));){
            Object line;
            MessageDigest messageDigest = DigestUtils.getMd5Digest();
            boolean onConfiguratorContent = false;
            while ((line = reader.readLine()) != null) {
                String key;
                int equalIdx;
                messageDigest.update(((String)line).getBytes());
                if (!onConfiguratorContent) {
                    if (!((String)line).startsWith(BOUNDARY_BEGIN)) {
                        if (((String)line).startsWith(PARAM_FORCE_GENERATION)) {
                            if (this.setOnceToFalse && this.onceGeneration) {
                                line = "nuxeo.force.generation=false";
                            }
                            if (this.setFalseToOnce && !this.forceGeneration) {
                                line = "nuxeo.force.generation=once";
                            }
                            if (generationIndex == null) {
                                newLines.add(line);
                                generationIndex = newLines.size() - 1;
                                continue;
                            }
                            newLines.set(generationIndex, line);
                            continue;
                        }
                        if (((String)line).startsWith(PARAM_TEMPLATES_NAME)) {
                            if (templatesParam != null) {
                                line = "nuxeo.templates=" + templatesParam;
                            }
                            if (templatesIndex == null) {
                                newLines.add(line);
                                templatesIndex = newLines.size() - 1;
                                continue;
                            }
                            newLines.set(templatesIndex, line);
                            continue;
                        }
                        equalIdx = ((String)line).indexOf("=");
                        if (equalIdx < 1 || ((String)line).trim().startsWith("#")) {
                            newLines.add(line);
                            continue;
                        }
                        key = ((String)line).substring(0, equalIdx).trim();
                        if (this.userConfig.getProperty(key) != null) {
                            newLines.add(line);
                            continue;
                        }
                        newLines.add("#" + (String)line);
                        continue;
                    }
                    if (templatesIndex == null && templatesParam != null) {
                        newLines.add("nuxeo.templates=" + templatesParam);
                        templatesIndex = newLines.size() - 1;
                    }
                    onConfiguratorContent = true;
                    continue;
                }
                if (!((String)line).startsWith(BOUNDARY_END)) {
                    String value;
                    equalIdx = ((String)line).indexOf("=");
                    if (((String)line).startsWith("#nuxeo.templates") || ((String)line).startsWith(PARAM_TEMPLATES_NAME) || equalIdx < 1) continue;
                    if (((String)line).trim().startsWith("#")) {
                        key = ((String)line).substring(1, equalIdx).trim();
                        value = ((String)line).substring(equalIdx + 1).trim();
                        this.getStoredConfig().setProperty(key, value);
                        continue;
                    }
                    key = ((String)line).substring(0, equalIdx).trim();
                    value = ((String)line).substring(equalIdx + 1).trim();
                    if (value.equals(this.userConfig.getRawProperty(key))) continue;
                    this.getStoredConfig().setProperty(key, value);
                    continue;
                }
                onConfiguratorContent = false;
            }
            reader.close();
            this.currentConfigurationDigest = Hex.encodeHexString((byte[])messageDigest.digest());
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading " + this.nuxeoConf, e);
        }
        StringBuilder newContent = new StringBuilder();
        for (String string : newLines) {
            newContent.append(string.trim()).append(System.lineSeparator());
        }
        return newContent;
    }

    public String extractDatabaseTemplateName() {
        return this.extractDbTemplateName(DB_LIST, PARAM_TEMPLATE_DBTYPE, PARAM_TEMPLATE_DBNAME, "unknown");
    }

    public String extractSecondaryDatabaseTemplateName() {
        return this.extractDbTemplateName(DB_SECONDARY_LIST, PARAM_TEMPLATE_DBSECONDARY_TYPE, PARAM_TEMPLATE_DBSECONDARY_NAME, null);
    }

    private String extractDbTemplateName(List<String> knownDbList, String paramTemplateDbType, String paramTemplateDbName, String defaultTemplate) {
        String dbTemplate = defaultTemplate;
        boolean found = false;
        for (File templateFile : this.includedTemplates) {
            String template = templateFile.getName();
            if (!knownDbList.contains(template)) continue;
            dbTemplate = template;
            found = true;
        }
        String dbType = this.userConfig.getProperty(paramTemplateDbType);
        if (!found && dbType != null) {
            log.warn(String.format("Didn't find a known database template in the list but some template contributed a value for %s.", paramTemplateDbType));
            dbTemplate = dbType;
        }
        if (dbTemplate != null && !dbTemplate.equals(dbType)) {
            if (dbType == null) {
                log.warn(String.format("Missing value for %s, using %s", paramTemplateDbType, dbTemplate));
                this.userConfig.setProperty(paramTemplateDbType, dbTemplate);
            } else {
                log.debug(String.format("Different values between %s (%s) and %s (%s)", paramTemplateDbName, dbTemplate, paramTemplateDbType, dbType));
            }
        }
        if (dbTemplate == null) {
            this.defaultConfig.remove(paramTemplateDbName);
        } else {
            this.defaultConfig.setProperty(paramTemplateDbName, dbTemplate);
        }
        return dbTemplate;
    }

    public File getNuxeoConf() {
        return this.nuxeoConf;
    }

    public void initLogs() {
        this.serverConfigurator.initLogs();
    }

    public File getLogDir() {
        return this.serverConfigurator.getLogDir();
    }

    public File getPidDir() {
        return this.serverConfigurator.getPidDir();
    }

    public File getDataDir() {
        return this.serverConfigurator.getDataDir();
    }

    public void verifyInstallation() throws ConfigurationException {
        this.checkJavaVersion();
        this.getLogDir().mkdirs();
        this.getPidDir().mkdirs();
        this.getDataDir().mkdirs();
        this.getTmpDir().mkdirs();
        this.getPackagesDir().mkdirs();
        this.checkAddressesAndPorts();
        this.serverConfigurator.verifyInstallation();
        this.backingServicesConfigurator.verifyInstallation();
    }

    private File getPackagesDir() {
        return this.serverConfigurator.getPackagesDir();
    }

    public void checkJavaVersion() throws ConfigurationException {
        String version = System.getProperty("java.version");
        ConfigurationGenerator.checkJavaVersion(version, COMPLIANT_JAVA_VERSIONS);
    }

    protected static void checkJavaVersion(String version, String[] compliantVersions) throws ConfigurationException {
        String lastCompliantVersion = null;
        for (String compliantVersion : compliantVersions) {
            if (ConfigurationGenerator.checkJavaVersion(version, compliantVersion, false, false)) {
                lastCompliantVersion = compliantVersion;
                continue;
            }
            if (lastCompliantVersion != null) {
                return;
            }
            if (!ConfigurationGenerator.checkJavaVersion(version, compliantVersion, true, true)) continue;
            return;
        }
        if (lastCompliantVersion != null) {
            ConfigurationGenerator.checkJavaVersion(version, lastCompliantVersion, false, true);
            return;
        }
        String message = String.format("Nuxeo requires Java %s (detected %s).", ArrayUtils.toString((Object)compliantVersions), version);
        throw new ConfigurationException(message + " See 'jvmcheck' option to bypass version check.");
    }

    protected static boolean checkJavaVersion(String version, String requiredVersion, boolean allowNoFailFlag, boolean warnIfLooseCompliance) {
        allowNoFailFlag = allowNoFailFlag && JVMCHECK_NOFAIL.equalsIgnoreCase(System.getProperty(JVMCHECK_PROP, JVMCHECK_FAIL));
        try {
            boolean compliant;
            JVMVersion required = JVMVersion.parse(requiredVersion);
            JVMVersion actual = JVMVersion.parse(version);
            boolean bl = compliant = actual.compareTo(required) >= 0;
            if (compliant && actual.compareTo(required, JVMVersion.UpTo.MAJOR) == 0) {
                return true;
            }
            if (!compliant && !allowNoFailFlag) {
                return false;
            }
            if (warnIfLooseCompliance) {
                log.warn(String.format("Nuxeo requires Java %s+ (detected %s).", requiredVersion, version));
            }
            return true;
        }
        catch (ParseException cause) {
            if (allowNoFailFlag) {
                log.warn("Cannot check java version", (Throwable)cause);
                return true;
            }
            throw new IllegalArgumentException("Cannot check java version", cause);
        }
    }

    public static boolean checkJavaVersion(String version, String requiredVersion) {
        return ConfigurationGenerator.checkJavaVersion(version, requiredVersion, false, false);
    }

    public void checkAddressesAndPorts() throws ConfigurationException {
        InetAddress bindAddress = this.getBindAddress();
        if (bindAddress.isMulticastAddress()) {
            throw new ConfigurationException("Multicast address won't work: " + bindAddress);
        }
        ConfigurationGenerator.checkAddressReachable(bindAddress);
        ConfigurationGenerator.checkPortAvailable(bindAddress, Integer.parseInt(this.userConfig.getProperty(PARAM_HTTP_PORT)));
    }

    public InetAddress getBindAddress() throws ConfigurationException {
        return ConfigurationGenerator.getBindAddress(this.userConfig.getProperty(PARAM_BIND_ADDRESS));
    }

    public static InetAddress getBindAddress(String hostName) throws ConfigurationException {
        InetAddress bindAddress;
        try {
            bindAddress = InetAddress.getByName(hostName);
            if (bindAddress.isAnyLocalAddress()) {
                boolean preferIPv6 = "false".equals(System.getProperty("java.net.preferIPv4Stack")) && "true".equals(System.getProperty("java.net.preferIPv6Addresses"));
                bindAddress = preferIPv6 ? InetAddress.getByName("::1") : InetAddress.getByName("127.0.0.1");
                log.debug("Bind address is \"ANY\", using local address instead: {}", (Object)bindAddress);
            }
            log.debug("Configured bind address: {}", (Object)bindAddress);
        }
        catch (UnknownHostException e) {
            throw new ConfigurationException(e);
        }
        return bindAddress;
    }

    public static void checkAddressReachable(InetAddress address) throws ConfigurationException {
        try {
            log.debug("Checking availability of " + address);
            address.isReachable(1000);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new ConfigurationException("Unreachable bind address " + address, e);
        }
    }

    public static void checkPortAvailable(InetAddress address, int port) throws ConfigurationException {
        if (port == 0 || port == -1) {
            log.warn("Port is set to {} - assuming it is disabled - skipping availability check", (Object)port);
            return;
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        log.debug("Checking availability of port {} on address {}", (Object)port, (Object)address);
        try (ServerSocket socketTCP = new ServerSocket(port, 0, address);){
            socketTCP.setReuseAddress(true);
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage() + ": " + address + ":" + port, e);
        }
    }

    public File getTmpDir() {
        return this.serverConfigurator.getTmpDir();
    }

    public List<String> getLogFiles() {
        File log4jConfFile = this.serverConfigurator.getLogConfFile();
        System.setProperty("nuxeo.log.dir", this.getLogDir().getPath());
        return Log4JHelper.getFileAppendersFileNames(log4jConfFile);
    }

    public String rebuildTemplatesStr(String dbTemplate) {
        int dbIdx;
        ArrayList<String> templatesList = new ArrayList<String>(Arrays.asList(this.templates.split(TEMPLATE_SEPARATOR)));
        String currentDBTemplate = null;
        if (DB_LIST.contains(dbTemplate)) {
            currentDBTemplate = this.userConfig.getProperty(PARAM_TEMPLATE_DBNAME);
            if (currentDBTemplate == null) {
                currentDBTemplate = this.extractDatabaseTemplateName();
            }
        } else if (DB_SECONDARY_LIST.contains(dbTemplate)) {
            currentDBTemplate = this.userConfig.getProperty(PARAM_TEMPLATE_DBSECONDARY_NAME);
            if (currentDBTemplate == null) {
                currentDBTemplate = this.extractSecondaryDatabaseTemplateName();
            }
            if ("none".equals(dbTemplate)) {
                dbTemplate = null;
            }
        }
        if ((dbIdx = templatesList.indexOf(currentDBTemplate)) < 0) {
            if (dbTemplate == null) {
                return this.templates;
            }
            templatesList.add(dbTemplate);
        } else if (dbTemplate == null) {
            templatesList.remove(dbIdx);
        } else {
            templatesList.set(dbIdx, dbTemplate);
        }
        return this.replaceEnvironmentVariables(String.join((CharSequence)TEMPLATE_SEPARATOR, templatesList));
    }

    public File getConfigDir() {
        return this.serverConfigurator.getConfigDir();
    }

    public File getRuntimeHome() {
        return this.serverConfigurator.getRuntimeHome();
    }

    public boolean isInstallInProgress() {
        return this.getInstallFile().exists();
    }

    @Deprecated(since="11.1")
    public File getDistributionMPDir() {
        String mpDir = this.userConfig.getProperty(PARAM_MP_DIR, DISTRIBUTION_MP_DIR);
        return new File(this.getNuxeoHome(), mpDir);
    }

    public File getInstallFile() {
        return new File(this.serverConfigurator.getDataDir(), INSTALL_AFTER_RESTART);
    }

    public void addTemplate(String templatesToAdd) throws ConfigurationException {
        List<String> templatesToAddList;
        List<String> templatesList = this.getTemplateList();
        if (templatesList.addAll(templatesToAddList = Arrays.asList(templatesToAdd.split(TEMPLATE_SEPARATOR)))) {
            String newTemplatesStr = String.join((CharSequence)TEMPLATE_SEPARATOR, templatesList);
            HashMap<String, String> parametersToSave = new HashMap<String, String>();
            parametersToSave.put(PARAM_TEMPLATES_NAME, newTemplatesStr);
            this.saveFilteredConfiguration(parametersToSave);
            this.changeTemplates(newTemplatesStr);
        }
    }

    public List<String> getTemplateList() {
        String currentTemplatesStr = this.userConfig.getProperty(PARAM_TEMPLATES_NAME);
        return Stream.of(this.replaceEnvironmentVariables(currentTemplatesStr).split(TEMPLATE_SEPARATOR)).collect(Collectors.toList());
    }

    public void rmTemplate(String templatesToRm) throws ConfigurationException {
        List<String> templatesToRmList;
        List<String> templatesList = this.getTemplateList();
        if (templatesList.removeAll(templatesToRmList = Arrays.asList(templatesToRm.split(TEMPLATE_SEPARATOR)))) {
            String newTemplatesStr = String.join((CharSequence)TEMPLATE_SEPARATOR, templatesList);
            HashMap<String, String> parametersToSave = new HashMap<String, String>();
            parametersToSave.put(PARAM_TEMPLATES_NAME, newTemplatesStr);
            this.saveFilteredConfiguration(parametersToSave);
            this.changeTemplates(newTemplatesStr);
        }
    }

    public String setProperty(String key, String value) throws ConfigurationException {
        String oldValue = this.getStoredConfig().getProperty(key);
        if (PARAM_TEMPLATES_NAME.equals(key)) {
            this.templates = StringUtils.isBlank((CharSequence)value) ? null : value;
        }
        HashMap<String, String> newParametersToSave = new HashMap<String, String>();
        newParametersToSave.put(key, value);
        this.saveFilteredConfiguration(newParametersToSave);
        this.setBasicConfiguration();
        return oldValue;
    }

    public Map<String, String> setProperties(Map<String, String> newParametersToSave) throws ConfigurationException {
        HashMap<String, String> oldValues = new HashMap<String, String>();
        for (String key : newParametersToSave.keySet()) {
            oldValues.put(key, this.getStoredConfig().getProperty(key));
            if (!PARAM_TEMPLATES_NAME.equals(key)) continue;
            String value = newParametersToSave.get(key);
            this.templates = StringUtils.isBlank((CharSequence)value) ? null : value;
        }
        this.saveFilteredConfiguration(newParametersToSave);
        this.setBasicConfiguration();
        return oldValues;
    }

    public Map<String, String> setProperties(String template, Map<String, String> newParametersToSave) throws ConfigurationException, IOException {
        File templateDir = this.getTemplateDirectory(template);
        String nuxeoEnv = this.getEnvironment(NUXEO_ENVIRONMENT, "");
        File templateConf = nuxeoEnv.isBlank() ? new File(templateDir, NUXEO_DEFAULT_CONF) : new File(templateDir, String.format(NUXEO_ENVIRONMENT_CONF_FORMAT, nuxeoEnv));
        Properties templateProperties = ConfigurationGenerator.loadTrimmedProperties(templateConf);
        HashMap<String, String> oldValues = new HashMap<String, String>();
        StringBuilder newContent = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(templateConf));){
            String line = reader.readLine();
            if (line != null && line.startsWith("## DO NOT EDIT THIS FILE")) {
                throw new ConfigurationException("The template states in its header that it must not be modified.");
            }
            while (line != null) {
                int equalIdx = line.indexOf("=");
                if (equalIdx < 1 || line.trim().startsWith("#")) {
                    newContent.append(line).append(System.getProperty("line.separator"));
                } else {
                    String key = line.substring(0, equalIdx).trim();
                    if (newParametersToSave.containsKey(key)) {
                        newContent.append(key).append("=").append(newParametersToSave.get(key)).append(System.getProperty("line.separator"));
                    } else {
                        newContent.append(line).append(System.getProperty("line.separator"));
                    }
                }
                line = reader.readLine();
            }
        }
        for (String key : newParametersToSave.keySet()) {
            if (templateProperties.containsKey(key)) {
                oldValues.put(key, templateProperties.getProperty(key));
                continue;
            }
            newContent.append(key).append("=").append(newParametersToSave.get(key)).append(System.lineSeparator());
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(templateConf));){
            writer.append(newContent.toString());
        }
        this.setBasicConfiguration();
        return oldValues;
    }

    public void checkDatabaseConnection(String databaseTemplate, String dbName, String dbUser, String dbPassword, String dbHost, String dbPort) throws IOException, DatabaseDriverException, SQLException {
        File databaseTemplateDir = new File(this.nuxeoTemplates, databaseTemplate);
        Properties templateProperties = this.loadNuxeoDefaults(databaseTemplateDir);
        String classname = this.userConfig.containsKey((Object)PARAM_DB_DRIVER) ? (String)this.userConfig.get((Object)PARAM_DB_DRIVER) : templateProperties.getProperty(PARAM_DB_DRIVER);
        String connectionUrl = this.userConfig.containsKey((Object)PARAM_DB_JDBC_URL) ? (String)this.userConfig.get((Object)PARAM_DB_JDBC_URL) : templateProperties.getProperty(PARAM_DB_JDBC_URL);
        Driver driver = this.lookupDriver(databaseTemplate, databaseTemplateDir, classname);
        DriverManager.registerDriver(driver);
        Properties ttProps = new Properties((Properties)this.userConfig);
        ttProps.put(PARAM_DB_HOST, dbHost);
        ttProps.put(PARAM_DB_PORT, dbPort);
        ttProps.put(PARAM_DB_NAME, dbName);
        ttProps.put(PARAM_DB_USER, dbUser);
        ttProps.put(PARAM_DB_PWD, dbPassword);
        TextTemplate tt = new TextTemplate(ttProps);
        String url = tt.processText(connectionUrl);
        Properties conProps = new Properties();
        conProps.put("user", dbUser);
        conProps.put("password", dbPassword);
        log.debug("Testing URL " + url + " with " + conProps);
        Connection con = driver.connect(url, conProps);
        con.close();
    }

    private Driver lookupDriver(String databaseTemplate, File databaseTemplateDir, String classname) throws DatabaseDriverException {
        File[] files = (File[])ArrayUtils.addAll((Object[])new File(databaseTemplateDir, "lib").listFiles(), (Object[])this.serverConfigurator.getServerLibDir().listFiles());
        ArrayList<URL> urlsList = new ArrayList<URL>();
        if (files != null) {
            for (File file : files) {
                if (!file.getName().endsWith("jar")) continue;
                try {
                    urlsList.add(new URL("jar:file:" + file.getPath() + "!/"));
                    log.debug("Added " + file.getPath());
                }
                catch (MalformedURLException e) {
                    log.error((Object)e);
                }
            }
        }
        URLClassLoader ucl = new URLClassLoader(urlsList.toArray(new URL[0]));
        try {
            return (Driver)Class.forName(classname, true, ucl).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new DatabaseDriverException(e);
        }
    }

    public Environment getEnv() {
        if (this.env == null) {
            this.env = new Environment(this.getRuntimeHome());
            File distribFile = new File(new File(this.nuxeoHome, TEMPLATES), "common/config/distribution.properties");
            if (distribFile.exists()) {
                try {
                    this.env.loadProperties(ConfigurationGenerator.loadTrimmedProperties(distribFile));
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
            this.env.loadProperties((Properties)this.userConfig);
            this.env.setServerHome(this.getNuxeoHome());
            this.env.init();
            this.env.setData(this.userConfig.getProperty("nuxeo.data.dir", "data"));
            this.env.setLog(this.userConfig.getProperty("nuxeo.log.dir", "logs"));
            this.env.setTemp(this.userConfig.getProperty("nuxeo.tmp.dir", "tmp"));
            this.env.setPath("nuxeo.mp.dir", this.getPackagesDir(), this.env.getServerHome());
        }
        return this.env;
    }

    public static Charset checkFileCharset(File propsFile) throws IOException {
        List<Charset> charsetsToBeTested = Arrays.asList(StandardCharsets.US_ASCII, StandardCharsets.UTF_8, StandardCharsets.ISO_8859_1);
        for (Charset charsetTest : charsetsToBeTested) {
            CharsetDecoder decoder = charsetTest.newDecoder();
            decoder.reset();
            boolean identified = true;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(propsFile));){
                byte[] buffer = new byte[512];
                while (input.read(buffer) != -1 && identified) {
                    try {
                        decoder.decode(ByteBuffer.wrap(buffer));
                        identified = true;
                    }
                    catch (CharacterCodingException e) {
                        identified = false;
                    }
                }
            }
            if (!identified) continue;
            return charsetTest;
        }
        return null;
    }

    protected Properties loadNuxeoDefaults(File directory) throws IOException {
        Properties properties = ConfigurationGenerator.loadTrimmedProperties(new File(directory, NUXEO_DEFAULT_CONF));
        File nuxeoDefaultsEnv = new File(directory, this.getNuxeoEnvironmentConfName());
        if (nuxeoDefaultsEnv.exists()) {
            ConfigurationGenerator.loadTrimmedProperties(properties, nuxeoDefaultsEnv);
        }
        return properties;
    }

    public static Properties loadTrimmedProperties(File propsFile) throws IOException {
        return ConfigurationGenerator.loadTrimmedProperties(new Properties(), propsFile);
    }

    protected static Properties loadTrimmedProperties(Properties props, File propsFile) throws IOException {
        Charset charset = ConfigurationGenerator.checkFileCharset(propsFile);
        if (charset == null) {
            throw new IOException("Can't identify input file charset for " + propsFile.getName());
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = propsFile::getName;
        supplierArray[1] = charset::name;
        log.debug("Opening {} in {}", supplierArray);
        try (InputStreamReader propsIS = new InputStreamReader((InputStream)new FileInputStream(propsFile), charset);){
            ConfigurationGenerator.loadTrimmedProperties(props, propsIS);
        }
        return props;
    }

    public static void loadTrimmedProperties(Properties props, InputStreamReader propsIS) throws IOException {
        if (props == null) {
            return;
        }
        Properties p = new Properties();
        p.load(propsIS);
        Enumeration<?> pEnum = p.propertyNames();
        while (pEnum.hasMoreElements()) {
            String key = (String)pEnum.nextElement();
            String value = p.getProperty(key);
            props.put(key.trim(), value.trim());
        }
    }

    public File getDumpedConfig() {
        return new File(this.getConfigDir(), CONFIGURATION_PROPERTIES);
    }

    public Hashtable<Object, Object> getContextEnv(String ldapUrl, String bindDn, String bindPassword, boolean checkAuthentication) {
        Hashtable<Object, Object> contextEnv = new Hashtable<Object, Object>();
        contextEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        contextEnv.put("com.sun.jndi.ldap.connect.timeout", "10000");
        contextEnv.put("java.naming.provider.url", ldapUrl);
        if (checkAuthentication) {
            contextEnv.put("java.naming.security.authentication", "simple");
            contextEnv.put("java.naming.security.principal", bindDn);
            contextEnv.put("java.naming.security.credentials", bindPassword);
        }
        return contextEnv;
    }

    public void checkLdapConnection(String ldapUrl, String ldapBindDn, String ldapBindPwd, boolean authenticate) throws NamingException {
        this.checkLdapConnection(this.getContextEnv(ldapUrl, ldapBindDn, ldapBindPwd, authenticate));
    }

    public void checkLdapConnection(Hashtable<Object, Object> contextEnv) throws NamingException {
        InitialDirContext dirContext = new InitialDirContext(contextEnv);
        dirContext.close();
    }

    public Crypto getCrypto() {
        return this.userConfig.getCrypto();
    }

    @Deprecated(since="11.1")
    public File getTemplateConf(String template) throws ConfigurationException {
        return new File(this.getTemplateDirectory(template), NUXEO_DEFAULT_CONF);
    }

    public File getTemplateDirectory(String template) throws ConfigurationException {
        File templateDir = new File(template);
        if (!templateDir.isAbsolute() && this.isInvalidNuxeoDefaults(templateDir = new File(System.getProperty("user.dir"), template))) {
            templateDir = new File(this.nuxeoTemplates, template);
        }
        if (this.isInvalidNuxeoDefaults(templateDir)) {
            throw new ConfigurationException("Template not found: " + template);
        }
        return templateDir;
    }

    protected boolean isInvalidNuxeoDefaults(File templateDir) {
        return !templateDir.exists() || !new File(templateDir, NUXEO_DEFAULT_CONF).exists();
    }

    @Deprecated
    protected String getJavaOpts(String key, String value) {
        return this.getJavaOptsString();
    }

    public List<String> getJavaOpts(Function<String, String> mapper) {
        return Arrays.stream(JAVA_OPTS_PATTERN.split(System.getProperty(JAVA_OPTS_PROP, ""))).map(option -> StringSubstitutor.replace((Object)option, (Properties)this.getUserConfig())).map(mapper).collect(Collectors.toList());
    }

    protected String getJavaOptsString() {
        return String.join((CharSequence)" ", this.getJavaOpts(Function.identity()));
    }

    protected String getEnvironment(String key) {
        return System.getenv(key);
    }

    protected String getEnvironment(String key, String defaultValue) {
        return Objects.requireNonNullElse(this.getEnvironment(key), defaultValue);
    }

    protected String getNuxeoEnvironmentConfName() {
        return String.format(NUXEO_ENVIRONMENT_CONF_FORMAT, this.getEnvironment(NUXEO_ENVIRONMENT));
    }
}

