/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.Calendar;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;

public class RetentionExpiredFinderListener
implements EventListener {
    public static final String QUERY = "SELECT * FROM Document, Relation WHERE ecm:isProxy = 0 AND ecm:retainUntil < TIMESTAMP '%s'";

    public void handleEvent(Event event) {
        BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
        RepositoryService repositoryService = (RepositoryService)((Object)Framework.getService(RepositoryService.class));
        Calendar now = Calendar.getInstance();
        String nxql = String.format(QUERY, now.toInstant());
        for (String repositoryName : repositoryService.getRepositoryNames()) {
            BulkCommand command = new BulkCommand.Builder("retentionExpired", nxql).user("system").repository(repositoryName).build();
            bulkService.submit(command);
        }
    }
}

