/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.trash;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.trash.TrashInfo;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractTrashService
implements TrashService {
    public static final String TRASHED_QUERY = "SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:isVersion = 0 AND ecm:isTrashed = 1 AND ecm:parentId = '%s'";
    protected static final String PATH_SEPARATOR = "/";
    protected static final Pattern TRASHED_PATTERN = Pattern.compile("(.*)\\._[0-9]{13,}_\\.trashed");
    protected static final Pattern COLLISION_PATTERN = Pattern.compile("(.*)\\.[0-9]{13,}");

    @Override
    public boolean folderAllowsDelete(DocumentModel folder) {
        return folder.getCoreSession().hasPermission(folder.getRef(), "RemoveChildren");
    }

    @Override
    public boolean checkDeletePermOnParents(List<DocumentModel> docs) {
        if (docs.isEmpty()) {
            return false;
        }
        CoreSession session = docs.get(0).getCoreSession();
        for (DocumentModel doc : docs) {
            if (!session.hasPermission(doc.getParentRef(), "RemoveChildren")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDelete(List<DocumentModel> docs, NuxeoPrincipal principal, boolean checkProxies) {
        if (docs.isEmpty()) {
            return false;
        }
        TrashInfo info = this.getInfo(docs, principal, checkProxies, false);
        return !info.docs.isEmpty();
    }

    public boolean canPurgeOrUntrash(List<DocumentModel> docs, NuxeoPrincipal principal) {
        if (docs.isEmpty()) {
            return false;
        }
        TrashInfo info = this.getInfo(docs, principal, false, true);
        return info.docs.size() == docs.size();
    }

    protected TrashInfo getInfo(List<DocumentModel> docs, NuxeoPrincipal principal, boolean checkProxies, boolean checkDeleted) {
        TrashInfo info = new TrashInfo();
        info.docs = new ArrayList<DocumentModel>(docs.size());
        if (docs.isEmpty()) {
            return info;
        }
        CoreSession session = docs.get(0).getCoreSession();
        for (DocumentModel doc : docs) {
            if (checkDeleted && !doc.isTrashed()) {
                ++info.forbidden;
                continue;
            }
            if (doc.getParentRef() == null) {
                if (doc.isVersion() && !session.getProxies(doc.getRef(), null).isEmpty()) {
                    ++info.forbidden;
                    continue;
                }
            } else if (!session.hasPermission(doc.getParentRef(), "RemoveChildren")) {
                ++info.forbidden;
                continue;
            }
            if (!session.hasPermission(doc.getRef(), "Remove")) {
                ++info.forbidden;
                continue;
            }
            if (checkProxies && doc.isProxy()) {
                ++info.proxies;
                continue;
            }
            if (doc.isLocked()) {
                String locker = AbstractTrashService.getDocumentLocker(doc);
                if (principal == null || principal.isAdministrator() || principal.getName().equals(locker)) {
                    info.docs.add(doc);
                    continue;
                }
                ++info.locked;
                continue;
            }
            info.docs.add(doc);
        }
        return info;
    }

    protected static String getDocumentLocker(DocumentModel doc) {
        Lock lock = doc.getLockInfo();
        return lock == null ? null : lock.getOwner();
    }

    @Override
    public TrashInfo getTrashInfo(List<DocumentModel> docs, NuxeoPrincipal principal, boolean checkProxies, boolean checkDeleted) {
        TrashInfo info = this.getInfo(docs, principal, checkProxies, checkDeleted);
        info.docs.sort(PathComparator.INSTANCE);
        info.rootPaths = new HashSet<Path>();
        info.rootRefs = new LinkedList<DocumentRef>();
        info.rootParentRefs = new HashSet<DocumentRef>();
        Path previousPath = null;
        for (DocumentModel doc : info.docs) {
            if (previousPath != null && previousPath.isPrefixOf(doc.getPath())) continue;
            Path path = doc.getPath();
            info.rootPaths.add(path);
            info.rootRefs.add(doc.getRef());
            if (doc.getParentRef() != null) {
                info.rootParentRefs.add(doc.getParentRef());
            }
            previousPath = path;
        }
        return info;
    }

    @Override
    public DocumentModel getAboveDocument(DocumentModel doc, Set<Path> rootPaths) {
        CoreSession session = doc.getCoreSession();
        while (AbstractTrashService.underOneOf(doc.getPath(), rootPaths) && (doc = session.getParentDocument(doc.getRef())) != null) {
        }
        return doc;
    }

    public DocumentModel getAboveDocument(DocumentModel doc, NuxeoPrincipal principal) {
        TrashInfo info = this.getTrashInfo(Collections.singletonList(doc), principal, false, false);
        return this.getAboveDocument(doc, info.rootPaths);
    }

    protected static boolean underOneOf(Path testedPath, Set<Path> paths) {
        for (Path path : paths) {
            if (path == null || !path.isPrefixOf(testedPath)) continue;
            return true;
        }
        return false;
    }

    public void purgeDocuments(CoreSession session, List<DocumentRef> docRefs) {
        if (docRefs.isEmpty()) {
            return;
        }
        session.removeDocuments(docRefs.toArray(new DocumentRef[docRefs.size()]));
        session.save();
    }

    public void purgeDocumentsUnder(DocumentModel parent) {
        if (parent == null || !parent.hasFacet("Folderish")) {
            throw new UnsupportedOperationException("Empty trash can only be performed on a Folderish document");
        }
        CoreSession session = parent.getCoreSession();
        if (!session.hasPermission(parent.getParentRef(), "RemoveChildren")) {
            return;
        }
        try (IterableQueryResult result = session.queryAndFetch(String.format(TRASHED_QUERY, parent.getId()), "NXQL", new Object[0]);){
            NuxeoPrincipal principal = session.getPrincipal();
            StreamSupport.stream(result.spliterator(), false).map(map -> ((Serializable)map.get("ecm:uuid")).toString()).map(IdRef::new).filter(ref -> session.hasPermission((DocumentRef)ref, "Remove")).filter(ref -> {
                if (principal == null || principal.isAdministrator()) {
                    return true;
                }
                DocumentModel doc = session.getDocument((DocumentRef)ref);
                return !doc.isLocked() || principal.getName().equals(AbstractTrashService.getDocumentLocker(doc));
            }).forEach(arg_0 -> ((CoreSession)session).removeDocument(arg_0));
        }
        session.save();
    }

    protected void notifyEvent(CoreSession session, String eventId, DocumentModel doc) {
        this.notifyEvent(session, eventId, doc, false);
    }

    protected void notifyEvent(CoreSession session, String eventId, DocumentModel doc, boolean immediate) {
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), doc);
        ctx.setProperties(new HashMap(doc.getContextData()));
        ctx.setCategory("eventDocumentCategory");
        ctx.setProperty("repositoryName", (Serializable)((Object)session.getRepositoryName()));
        Event event = ctx.newEvent(eventId);
        event.setInline(false);
        event.setImmediate(immediate);
        EventService eventService = (EventService)Framework.getService(EventService.class);
        eventService.fireEvent(event);
    }

    public DocumentModelList getDocuments(DocumentModel parent) {
        CoreSession session = parent.getCoreSession();
        return session.query(String.format(TRASHED_QUERY, parent.getId()));
    }

    public void untrashDocuments(List<DocumentModel> docs) {
        this.undeleteDocuments(docs);
    }

    public boolean isMangledName(String docName) {
        return TRASHED_PATTERN.matcher(docName).matches();
    }

    public String mangleName(DocumentModel doc) {
        return doc.getName() + "._" + System.currentTimeMillis() + "_.trashed";
    }

    public String unmangleName(DocumentModel doc) {
        return this.unmangleName(doc.getCoreSession(), doc.getParentRef(), doc.getName());
    }

    public String unmangleName(CoreSession session, DocumentRef parentRef, String docName) {
        if (session == null) {
            return docName;
        }
        String name = this.getFirstGroup(TRASHED_PATTERN, docName);
        String orig = this.getFirstGroup(COLLISION_PATTERN, name);
        if (!docName.equals(name)) {
            String newPath;
            String parentPath = session.getDocument(parentRef).getPathAsString();
            if (parentPath.equals(PATH_SEPARATOR)) {
                parentPath = "";
            }
            if (!session.exists((DocumentRef)new PathRef(newPath = parentPath + PATH_SEPARATOR + orig))) {
                name = orig;
            }
        }
        return name;
    }

    protected String getFirstGroup(Pattern pattern, String name) {
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches() && StringUtils.isNotEmpty((CharSequence)matcher.group(1))) {
            return matcher.group(1);
        }
        return name;
    }

    protected static class PathComparator
    implements Comparator<DocumentModel>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public static final PathComparator INSTANCE = new PathComparator();

        protected PathComparator() {
        }

        @Override
        public int compare(DocumentModel doc1, DocumentModel doc2) {
            return doc1.getPathAsString().replace(AbstractTrashService.PATH_SEPARATOR, "\u0000").compareTo(doc2.getPathAsString().replace(AbstractTrashService.PATH_SEPARATOR, "\u0000"));
        }
    }
}

