/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.trash;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.trash.TrashService;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.trash.AbstractTrashService;
import org.nuxeo.runtime.api.Framework;

public class PropertyTrashService
extends AbstractTrashService {
    private static final Log log = LogFactory.getLog(PropertyTrashService.class);
    public static final String SYSPROP_IS_TRASHED = "isTrashed";

    public boolean isTrashed(CoreSession session, DocumentRef docRef) {
        Boolean isTrashed = (Boolean)session.getDocumentSystemProp(docRef, SYSPROP_IS_TRASHED, Boolean.class);
        return Boolean.TRUE.equals(isTrashed);
    }

    public void trashDocuments(List<DocumentModel> docs) {
        docs.forEach(this::doTrashDocument);
        docs.stream().map(DocumentModel::getCoreSession).findFirst().ifPresent(CoreSession::save);
    }

    protected void doTrashDocument(DocumentModel doc) {
        CoreSession session = doc.getCoreSession();
        DocumentRef docRef = doc.getRef();
        if (doc.isProxy()) {
            log.warn((Object)("Document " + doc.getId() + " of type " + doc.getType() + " will be deleted immediately because it's a proxy"));
            session.removeDocument(docRef);
        } else {
            if (!session.canRemoveDocument(docRef)) {
                throw new DocumentSecurityException("User " + session.getPrincipal().getName() + " does not have the permission to remove the document " + doc.getId() + " (" + doc.getPath() + ")");
            }
            if (session.isTrashed(docRef)) {
                log.warn((Object)("Document " + doc.getId() + " of type " + doc.getType() + " is already in the trash, nothing to do"));
            } else if (doc.getParentRef() == null) {
                session.removeDocument(doc.getRef());
            } else {
                DocumentModel docForEvent = doc;
                if (!Boolean.parseBoolean(String.valueOf(doc.getContextData("skipTrashRenaming")))) {
                    String newName = this.mangleName(doc);
                    session.move(docRef, doc.getParentRef(), newName);
                    docForEvent = session.getDocument(docRef);
                    docForEvent.copyContextData(doc);
                }
                session.setDocumentSystemProp(docRef, SYSPROP_IS_TRASHED, (Serializable)Boolean.TRUE);
                this.notifyEvent(session, "documentTrashed", docForEvent);
                if (session.hasChildren(doc.getRef())) {
                    this.trashDescendants(doc, Boolean.TRUE);
                }
            }
        }
    }

    @Override
    public Set<DocumentRef> undeleteDocuments(List<DocumentModel> docs) {
        HashSet<DocumentRef> docRefs = new HashSet<DocumentRef>();
        for (DocumentModel doc : docs) {
            docRefs.addAll(this.doUntrashDocument(doc, true));
        }
        docs.stream().map(DocumentModel::getCoreSession).findFirst().ifPresent(CoreSession::save);
        return docRefs;
    }

    protected Set<DocumentRef> doUntrashDocument(DocumentModel doc, boolean processChildren) {
        String newName;
        CoreSession session = doc.getCoreSession();
        DocumentRef docRef = doc.getRef();
        DocumentModel docForEvent = doc;
        DocumentRef parentRef = doc.getParentRef();
        if (!Boolean.TRUE.equals(doc.getContextData("skipTrashRenaming")) && parentRef != null && !(newName = this.unmangleName(doc)).equals(doc.getName())) {
            session.move(docRef, parentRef, newName);
            docForEvent = session.getDocument(docRef);
            docForEvent.copyContextData(doc);
        }
        session.setDocumentSystemProp(docRef, SYSPROP_IS_TRASHED, (Serializable)Boolean.FALSE);
        this.notifyEvent(session, "documentUntrashed", docForEvent);
        if (processChildren && session.hasChildren(doc.getRef())) {
            this.trashDescendants(doc, Boolean.FALSE);
        }
        HashSet<DocumentRef> docRefs = new HashSet<DocumentRef>();
        docRefs.add(docRef);
        if (parentRef != null && session.isTrashed(parentRef)) {
            DocumentModel parent = session.getDocument(parentRef);
            Set<DocumentRef> ancestorDocRefs = this.doUntrashDocument(parent, false);
            docRefs.addAll(ancestorDocRefs);
        }
        return docRefs;
    }

    protected void trashDescendants(DocumentModel model, Boolean value) {
        CoreSession session = model.getCoreSession();
        BulkService service = (BulkService)Framework.getService(BulkService.class);
        String nxql = String.format("SELECT * from Document where ecm:ancestorId='%s'", model.getId());
        String user = session.getPrincipal().getName();
        service.submit(new BulkCommand.Builder("trash", nxql, user).repository(session.getRepositoryName()).param("value", (Serializable)value).build());
    }

    public boolean hasFeature(TrashService.Feature feature) {
        switch (feature) {
            case TRASHED_STATE_IS_DEDUCED_FROM_LIFECYCLE: 
            case TRASHED_STATE_IN_MIGRATION: {
                return false;
            }
            case TRASHED_STATE_IS_DEDICATED_PROPERTY: {
                return true;
            }
        }
        throw new UnsupportedOperationException(feature.name());
    }
}

