/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.uidgen;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.uidgen.UIDGenerator;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorDescriptor;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorService;
import org.nuxeo.ecm.core.uidgen.UIDSequencer;
import org.nuxeo.ecm.core.uidgen.UIDSequencerProviderDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class UIDGeneratorComponent
extends DefaultComponent
implements UIDGeneratorService {
    public static final String ID = "org.nuxeo.ecm.core.uidgen.UIDGeneratorService";
    public static final String UID_GENERATORS_EXTENSION_POINT = "generators";
    public static final String SEQUENCERS_EXTENSION_POINT = "sequencers";
    public static final String EXTENSION_POINT_SEQUENCER_FACTORY = "sequencerFactory";
    private static final Log log = LogFactory.getLog(UIDGeneratorComponent.class);
    protected final Map<String, UIDGenerator> generators = new HashMap<String, UIDGenerator>();
    protected final Map<String, UIDSequencer> sequencers = new HashMap<String, UIDSequencer>();
    protected final LinkedHashMap<String, UIDSequencerProviderDescriptor> sequencerContribs = new LinkedHashMap();
    protected String defaultSequencer;

    public void start(ComponentContext context) {
        for (String name : this.sequencers.keySet()) {
            this.sequencers.get(name).init();
        }
    }

    public void stop(ComponentContext context) {
        for (String name : this.sequencers.keySet()) {
            this.sequencers.get(name).dispose();
        }
    }

    public void registerExtension(Extension extension) {
        super.registerExtension(extension);
        String extPoint = extension.getExtensionPoint();
        if (UID_GENERATORS_EXTENSION_POINT.equals(extPoint)) {
            log.info((Object)"register contributions for extension point: generators");
            Object[] contribs = extension.getContributions();
            this.registerGenerators(extension, contribs);
        } else if (SEQUENCERS_EXTENSION_POINT.equals(extPoint)) {
            log.info((Object)"register contributions for extension point: sequencers");
            Object[] contribs = extension.getContributions();
            this.registerSequencers(extension, contribs);
            this.computeDefault();
        } else if (EXTENSION_POINT_SEQUENCER_FACTORY.equals(extPoint)) {
            String msg = "UIDSequencer factory no more supported from version 5.4. Faulty component: " + extension.getComponent();
            Framework.getRuntime().getMessageHandler().addWarning(msg);
            log.error((Object)msg);
        } else {
            log.warn((Object)("extension not handled: " + extPoint));
        }
    }

    public void unregisterExtension(Extension extension) {
        String extPoint = extension.getExtensionPoint();
        if (UID_GENERATORS_EXTENSION_POINT.equals(extPoint)) {
            log.info((Object)"unregister contributions for extension point: generators");
        } else if (SEQUENCERS_EXTENSION_POINT.equals(extPoint)) {
            log.info((Object)"unregister contributions for extension point: sequencers");
            Object[] contribs = extension.getContributions();
            this.unregisterSequencers(extension, contribs);
            this.computeDefault();
        } else {
            log.warn((Object)("extension not handled: " + extPoint));
        }
        super.unregisterExtension(extension);
    }

    protected void computeDefault() {
        String def = null;
        String last = null;
        for (UIDSequencerProviderDescriptor contrib : this.sequencerContribs.values()) {
            if (contrib.isIsdefault()) {
                def = contrib.getName();
            }
            last = contrib.getName();
        }
        if (def == null) {
            def = last;
        }
        this.defaultSequencer = def;
    }

    protected void registerSequencers(Extension extension, Object[] contribs) {
        for (Object contrib : contribs) {
            UIDSequencerProviderDescriptor seqDescriptor = (UIDSequencerProviderDescriptor)contrib;
            String name = seqDescriptor.getName();
            try {
                if (seqDescriptor.isEnabled()) {
                    UIDSequencer seq = seqDescriptor.getSequencer();
                    if (seq != null) {
                        seq.setName(name);
                    }
                    this.sequencers.put(name, seq);
                    this.sequencerContribs.put(name, seqDescriptor);
                    continue;
                }
                log.info((Object)String.format("Sequencer %s is disabled.", name));
            }
            catch (Exception e) {
                log.error((Object)("Unable to create UIDSequencer with name " + name), (Throwable)e);
            }
        }
    }

    protected void unregisterSequencers(Extension extension, Object[] contribs) {
        for (Object contrib : contribs) {
            UIDSequencerProviderDescriptor seqDescriptor = (UIDSequencerProviderDescriptor)contrib;
            String name = seqDescriptor.getName();
            this.sequencers.remove(name);
            this.sequencerContribs.remove(name);
        }
    }

    protected void registerGenerators(Extension extension, Object[] contribs) {
        for (Object contrib : contribs) {
            UIDGenerator generator;
            UIDGeneratorDescriptor generatorDescriptor = (UIDGeneratorDescriptor)contrib;
            String generatorName = generatorDescriptor.getName();
            try {
                generator = (UIDGenerator)extension.getContext().loadClass(generatorDescriptor.getClassName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            String[] propNames = generatorDescriptor.getPropertyNames();
            if (propNames.length == 0) {
                log.error((Object)("no property name defined on generator " + generatorName));
            }
            generator.setPropertyNames(propNames);
            String[] docTypes = generatorDescriptor.getDocTypes();
            this.registerGeneratorForDocTypes(generator, docTypes);
            log.info((Object)("registered UID generator: " + generatorName));
        }
    }

    private void registerGeneratorForDocTypes(UIDGenerator generator, String[] docTypes) {
        for (String docType : docTypes) {
            UIDGenerator previous = this.generators.put(docType, generator);
            if (previous != null) {
                log.info((Object)("Overwriting generator: " + previous.getClass() + " for docType: " + docType));
            }
            log.info((Object)("Registered generator: " + generator.getClass() + " for docType: " + docType));
        }
    }

    @Override
    public UIDGenerator getUIDGeneratorFor(DocumentModel doc) {
        String docTypeName = doc.getType();
        UIDGenerator generator = this.generators.get(docTypeName);
        if (generator == null) {
            log.debug((Object)("No UID Generator defined for doc type: " + docTypeName));
            return null;
        }
        generator.setSequencer((UIDSequencer)Framework.getService(UIDSequencer.class));
        return generator;
    }

    @Override
    public void setUID(DocumentModel doc) throws PropertyNotFoundException {
        UIDGenerator generator = this.getUIDGeneratorFor(doc);
        if (generator != null) {
            generator.setUID(doc);
        }
    }

    @Override
    public String createUID(DocumentModel doc) {
        UIDGenerator generator = this.getUIDGeneratorFor(doc);
        if (generator == null) {
            return null;
        }
        return generator.createUID(doc);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (UIDSequencer.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.getSequencer());
        }
        if (UIDGeneratorService.class.isAssignableFrom(adapter)) {
            return adapter.cast(this);
        }
        return null;
    }

    @Override
    public UIDSequencer getSequencer() {
        return this.getSequencer(null);
    }

    @Override
    public UIDSequencer getSequencer(String name) {
        if (name == null) {
            name = this.defaultSequencer;
        }
        return this.sequencers.get(name);
    }
}

