/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.pdf.PDFPageExtractor;

@Operation(id="PDF.ConvertToPictures", category="Conversion", label="PDF: Convert to Pictures", description="Convert each page of a PDF into a picture. Returns Blob list of pictures.")
public class PDFConvertToPicturesOperation {
    public static final String ID = "PDF.ConvertToPictures";
    @Param(name="fileName", required=false)
    protected String fileName = "";
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath = "";
    @Param(name="password", required=false)
    protected String password = null;

    @OperationMethod
    public BlobList run(DocumentModel inDoc) {
        PDFPageExtractor pe = new PDFPageExtractor(inDoc, this.xpath);
        pe.setPassword(this.password);
        return pe.getPagesAsImages(this.fileName);
    }
}

