/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pdf.operations;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.pdf.service.PDFTransformationService;

@Operation(id="PDF.WatermarkWithPDF", category="Conversion", label="PDF: Watermark with PDF", description="Returns a new blob combining the input PDF and an overlaid PDF on every page.")
public class PDFWatermarkPDFOperation {
    public static final String ID = "PDF.WatermarkWithPDF";
    public static final String DESCRIPTION = "Returns a new blob combining the input PDF and an overlaid PDF on every page.";
    @Context
    protected PDFTransformationService pdfTransformationService;
    @Param(name="overlayPdf", description="The PDF Blob to overlay on top of the input")
    protected Blob overlayPdf;

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(Blob inBlob) throws NuxeoException {
        return this.pdfTransformationService.overlayPDF(inBlob, this.overlayPdf);
    }
}

