/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.directory.server.kerberos.shared.io.encoder.Encoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncoderFactory;
import org.apache.directory.server.kerberos.shared.io.encoder.HostAddressesEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.components.EncKrbPrivPart;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncKrbPrivPartEncoder
implements Encoder,
EncoderFactory {
    private static final int APPLICATION_CODE = 28;

    public Encoder getEncoder() {
        return new EncKrbPrivPartEncoder();
    }

    public byte[] encode(Encodable privPart) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream((OutputStream)baos);
        DERSequence privPartSequence = this.encodePrivatePartSequence((EncKrbPrivPart)privPart);
        aos.writeObject((Object)DERApplicationSpecific.valueOf((int)28, (DEREncodable)privPartSequence));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodePrivatePartSequence(EncKrbPrivPart message) {
        DERSequence sequence = new DERSequence();
        sequence.add((DEREncodable)new DERTaggedObject(0, (DEREncodable)new DEROctetString(message.getUserData())));
        if (message.getTimestamp() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(1, (DEREncodable)KerberosTimeEncoder.encode(message.getTimestamp())));
        }
        if (message.getMicroSecond() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(2, (DEREncodable)DERInteger.valueOf((int)message.getMicroSecond())));
        }
        if (message.getSequenceNumber() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(3, (DEREncodable)DERInteger.valueOf((int)message.getSequenceNumber())));
        }
        sequence.add((DEREncodable)new DERTaggedObject(4, (DEREncodable)HostAddressesEncoder.encode(message.getSenderAddress())));
        if (message.getRecipientAddress() != null) {
            sequence.add((DEREncodable)new DERTaggedObject(5, (DEREncodable)HostAddressesEncoder.encode(message.getRecipientAddress())));
        }
        return sequence;
    }
}

