/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.gui;

import java.util.ArrayList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.swing.table.AbstractTableModel;

public class AttributesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3256443603340310841L;
    public static final String KEY_COL = "Keys";
    public static final String VAL_COL = "Values";
    private final transient ArrayList keyList;
    private final transient ArrayList valList;
    private final Attributes entry;
    private final Long id;
    private final String dn;
    private boolean isMutable = true;

    public AttributesTableModel(Attributes entry, Long id, String dn, boolean isMutable) {
        this.dn = dn;
        this.id = id;
        this.entry = entry;
        this.isMutable = isMutable;
        NamingEnumeration<String> list = entry.getIDs();
        int rowCount = 0;
        while (list.hasMoreElements()) {
            String attrId = (String)list.nextElement();
            rowCount += entry.get(attrId).size();
        }
        this.keyList = new ArrayList(rowCount);
        this.valList = new ArrayList(rowCount);
        list = this.entry.getIDs();
        while (list.hasMoreElements()) {
            String l_key = (String)list.nextElement();
            Attribute l_attr = this.entry.get(l_key);
            for (int ii = 0; ii < l_attr.size(); ++ii) {
                try {
                    this.keyList.add(l_attr.getID());
                    this.valList.add(l_attr.get(ii));
                    continue;
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return KEY_COL;
        }
        if (col == 1) {
            return VAL_COL;
        }
        throw new RuntimeException("There can only be 2 columns at index 0 and at 1");
    }

    public int getRowCount() {
        return this.keyList.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int c) {
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        return this.isMutable;
    }

    public Object getValueAt(int row, int col) {
        if (row >= this.keyList.size()) {
            return "NULL";
        }
        if (this.getColumnName(col).equals(KEY_COL)) {
            return this.keyList.get(row);
        }
        if (this.getColumnName(col).equals(VAL_COL)) {
            return this.valList.get(row);
        }
        throw new RuntimeException("You didn't correctly set col names");
    }

    public void setValue(Object val, int row, int col) {
        ArrayList list = null;
        if (col > 1 || col < 0) {
            return;
        }
        list = col == 0 ? this.keyList : this.valList;
        if (row >= this.keyList.size()) {
            return;
        }
        list.set(row, val);
        this.fireTableCellUpdated(row, col);
    }

    public String getEntryDn() {
        return this.dn;
    }

    public Long getEntryId() {
        return this.id;
    }

    public void delete(int row) {
        if (row >= this.keyList.size() || row < 0) {
            return;
        }
        this.keyList.remove(row);
        this.valList.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void insert(int row, Object key, Object val) {
        if (row >= this.keyList.size() || row < 0) {
            return;
        }
        this.keyList.add(row, key);
        this.valList.add(row, val);
        this.fireTableRowsInserted(row, row);
    }
}

