/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.DirectoryServiceConfiguration;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.trigger.TriggerSpecification;
import org.apache.directory.shared.ldap.trigger.TriggerSpecificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerSpecCache {
    private static final String PRESCRIPTIVE_TRIGGER_ATTR = "prescriptiveTriggerSpecification";
    private static final String TRIGGER_SUBENTRY_OC = "triggerExecutionSubentry";
    private static final Logger log = LoggerFactory.getLogger(TriggerSpecCache.class);
    private final Hashtable env;
    private final Map<String, List<TriggerSpecification>> triggerSpecs = new HashMap<String, List<TriggerSpecification>>();
    private final PartitionNexus nexus;
    private final TriggerSpecificationParser triggerSpecParser;
    private AttributeTypeRegistry attrRegistry;

    public TriggerSpecCache(DirectoryServiceConfiguration dirServCfg) throws NamingException {
        this.nexus = dirServCfg.getPartitionNexus();
        this.attrRegistry = dirServCfg.getRegistries().getAttributeTypeRegistry();
        final AttributeTypeRegistry registry = dirServCfg.getRegistries().getAttributeTypeRegistry();
        this.triggerSpecParser = new TriggerSpecificationParser(new NormalizerMappingResolver(){

            public Map getNormalizerMapping() throws NamingException {
                return registry.getNormalizerMapping();
            }
        });
        this.env = (Hashtable)dirServCfg.getEnvironment().clone();
        this.initialize();
    }

    private void initialize() throws NamingException {
        Iterator<String> suffixes = this.nexus.listSuffixes(null);
        while (suffixes.hasNext()) {
            String suffix = suffixes.next();
            LdapDN baseDn = new LdapDN(suffix);
            SimpleNode filter = new SimpleNode("objectClass", TRIGGER_SUBENTRY_OC, AssertionEnum.EQUALITY);
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> results = this.nexus.search(new SearchOperationContext(baseDn, this.env, (ExprNode)filter, ctls));
            while (results.hasMore()) {
                SearchResult result = results.next();
                String subentryDn = result.getName();
                Attribute triggerSpec = result.getAttributes().get(PRESCRIPTIVE_TRIGGER_ATTR);
                if (triggerSpec == null) {
                    log.warn("Found triggerExecutionSubentry '" + subentryDn + "' without any " + PRESCRIPTIVE_TRIGGER_ATTR);
                    continue;
                }
                LdapDN normSubentryName = new LdapDN(subentryDn);
                normSubentryName.normalize(this.attrRegistry.getNormalizerMapping());
                this.subentryAdded(normSubentryName, result.getAttributes());
            }
            results.close();
        }
    }

    private boolean hasPrescriptiveTrigger(Attributes entry) throws NamingException {
        Attribute triggerSpec = entry.get(PRESCRIPTIVE_TRIGGER_ATTR);
        return triggerSpec != null;
    }

    public void subentryAdded(LdapDN normName, Attributes entry) throws NamingException {
        Attribute triggerSpec = entry.get(PRESCRIPTIVE_TRIGGER_ATTR);
        if (triggerSpec == null) {
            return;
        }
        ArrayList<TriggerSpecification> subentryTriggerSpecs = new ArrayList<TriggerSpecification>();
        for (int ii = 0; ii < triggerSpec.size(); ++ii) {
            TriggerSpecification item = null;
            try {
                item = this.triggerSpecParser.parse((String)triggerSpec.get(ii));
                subentryTriggerSpecs.add(item);
                continue;
            }
            catch (ParseException e) {
                String msg = "TriggerSpecification parser failure on '" + item + "'. Cannnot add Trigger Specificaitons to TriggerSpecCache.";
                log.error(msg, (Throwable)e);
            }
        }
        this.triggerSpecs.put(normName.toString(), subentryTriggerSpecs);
    }

    public void subentryDeleted(LdapDN normName, Attributes entry) throws NamingException {
        if (!this.hasPrescriptiveTrigger(entry)) {
            return;
        }
        this.triggerSpecs.remove(normName.toString());
    }

    public void subentryModified(ModifyOperationContext opContext, Attributes entry) throws NamingException {
        if (!this.hasPrescriptiveTrigger(entry)) {
            return;
        }
        LdapDN normName = opContext.getDn();
        ModificationItemImpl[] mods = opContext.getModItems();
        boolean isTriggerSpecModified = false;
        for (int ii = 0; ii < mods.length; ++ii) {
            isTriggerSpecModified |= mods[ii].getAttribute().contains(PRESCRIPTIVE_TRIGGER_ATTR);
        }
        if (isTriggerSpecModified) {
            this.subentryDeleted(normName, entry);
            this.subentryAdded(normName, entry);
        }
    }

    public List<TriggerSpecification> getSubentryTriggerSpecs(String subentryDn) {
        List<TriggerSpecification> subentryTriggerSpecs = this.triggerSpecs.get(subentryDn);
        if (subentryTriggerSpecs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(subentryTriggerSpecs);
    }

    public void subentryRenamed(LdapDN oldName, LdapDN newName) {
        this.triggerSpecs.put(newName.toString(), this.triggerSpecs.remove(oldName.toString()));
    }
}

