/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetReference;
import org.nuxeo.ecm.platform.forms.layout.api.converters.LayoutConversionContext;
import org.nuxeo.ecm.platform.forms.layout.api.converters.WidgetDefinitionConverter;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.ecm.platform.forms.layout.export.AbstractLayoutJsonWriter;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class LayoutDefinitionJsonWriter
extends AbstractLayoutJsonWriter<LayoutDefinition> {
    private static final Log log = LogFactory.getLog(LayoutDefinitionJsonWriter.class);
    @Inject
    private LayoutStore webLayoutManager;

    public void write(LayoutDefinition entity, JsonGenerator jg) throws IOException {
        List list;
        Map renderingInfos;
        Map properties;
        Map templates;
        String typeCat;
        String type;
        jg.writeStartObject();
        String name = entity.getName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            jg.writeStringField("name", name);
        }
        if ((type = entity.getType()) != null) {
            jg.writeStringField("type", type);
        }
        if ((typeCat = entity.getTypeCategory()) != null) {
            jg.writeStringField("typeCategory", typeCat);
        }
        if (MapUtils.isNotEmpty((Map)(templates = entity.getTemplates()))) {
            this.writeSerializableMapField("templates", new TreeMap(templates), jg);
        }
        if (MapUtils.isNotEmpty((Map)(properties = entity.getProperties())) && properties.values().stream().anyMatch(MapUtils::isNotEmpty)) {
            this.writeSerializableMapMapField("properties", this.cleanAndSort(properties), jg);
        }
        String category = (String)this.ctx.getParameter("layoutExportCategory");
        List widgetConverters = this.ctx.getParameters("layoutExportWidgetConverters");
        LayoutConversionContext layoutCtx = (LayoutConversionContext)this.ctx.getParameter("layoutExportConversionContext");
        Object[] rowDefinitions = entity.getRows();
        ArrayList<WidgetReference> widgetsToExport = new ArrayList<WidgetReference>();
        if (ArrayUtils.isNotEmpty((Object[])rowDefinitions)) {
            jg.writeArrayFieldStart("rows");
            int rowIndex = -1;
            for (Object layoutRowDef : rowDefinitions) {
                this.writeRawDefinition((LayoutRowDefinition)layoutRowDef, layoutRowDef.getDefaultName(++rowIndex), jg);
                WidgetReference[] widgets = layoutRowDef.getWidgetReferences();
                if (widgets == null) continue;
                widgetsToExport.addAll(Arrays.asList(widgets));
            }
            jg.writeEndArray();
        }
        if (!widgetsToExport.isEmpty()) {
            jg.writeArrayFieldStart("widgets");
            for (WidgetReference widgetReference : widgetsToExport) {
                WidgetDefinition widgetDefinition = this.getWidgetDefinition(widgetReference, category, entity, layoutCtx, widgetConverters);
                if (widgetDefinition == null) continue;
                this.writeEntity(widgetDefinition, jg);
                WidgetReference[] subWidgets = widgetDefinition.getSubWidgetReferences();
                if (subWidgets == null) continue;
                for (WidgetReference subWidgetRef : subWidgets) {
                    WidgetDefinition subWidgetDefinition = this.getWidgetDefinition(subWidgetRef, category, entity, layoutCtx, widgetConverters);
                    if (subWidgetDefinition == null) continue;
                    this.writeEntity(subWidgetDefinition, jg);
                }
            }
            jg.writeEndArray();
        }
        if (MapUtils.isNotEmpty((Map)(renderingInfos = entity.getRenderingInfos())) && renderingInfos.values().stream().anyMatch(CollectionUtils::isNotEmpty)) {
            jg.writeObjectFieldStart("renderingInfos");
            for (Map.Entry entry : new TreeMap(renderingInfos).entrySet()) {
                this.writeSerializableListField((String)entry.getKey(), (Collection)entry.getValue(), jg);
            }
            jg.writeEndObject();
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = entity.getAliases()))) {
            this.writeSerializableListField("aliases", list, jg);
        }
        jg.writeEndObject();
    }

    protected void writeRawDefinition(LayoutRowDefinition layoutRowDef, String defaultName, JsonGenerator jg) throws IOException {
        Object[] defWidgets;
        Map properties;
        jg.writeStartObject();
        String name = layoutRowDef.getName();
        if (name != null) {
            jg.writeStringField("name", name);
        } else if (defaultName != null) {
            jg.writeStringField("name", defaultName);
        }
        if (layoutRowDef.isAlwaysSelected()) {
            jg.writeBooleanField("alwaysSelected", true);
        }
        if (!layoutRowDef.isSelectedByDefault()) {
            jg.writeBooleanField("selectedByDefault", false);
        }
        if (MapUtils.isNotEmpty((Map)(properties = layoutRowDef.getProperties())) && properties.values().stream().anyMatch(MapUtils::isNotEmpty)) {
            this.writeSerializableMapMapField("properties", this.cleanAndSort(properties), jg);
        }
        if (ArrayUtils.isNotEmpty((Object[])(defWidgets = layoutRowDef.getWidgetReferences()))) {
            this.writeSerializableListField("widgets", Arrays.asList(defWidgets), jg);
        }
        jg.writeEndObject();
    }

    protected WidgetDefinition getWidgetDefinition(WidgetReference widgetReference, String category, LayoutDefinition layoutDefinition, LayoutConversionContext ctx, List<WidgetDefinitionConverter> widgetConverters) {
        String widgetName = widgetReference.getName();
        WidgetDefinition widgetDefinition = layoutDefinition.getWidgetDefinition(widgetName);
        if (widgetDefinition == null) {
            String cat = widgetReference.getCategory();
            if (cat == null) {
                cat = category;
            }
            widgetDefinition = this.webLayoutManager.getWidgetDefinition(cat, widgetName);
        }
        if (widgetDefinition == null) {
            log.error((Object)String.format("No definition found for widget '%s' in layout '%s' => cannot export", widgetName, layoutDefinition.getName()));
        } else if (widgetConverters != null) {
            for (WidgetDefinitionConverter conv : widgetConverters) {
                widgetDefinition = conv.getWidgetDefinition(widgetDefinition, ctx);
            }
        }
        return widgetDefinition;
    }
}

