/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetSelectOption;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetSelectOptions;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class WidgetSelectOptionJsonWriter
extends AbstractJsonWriter<WidgetSelectOption> {
    public void write(WidgetSelectOption entity, JsonGenerator jg) throws IOException {
        Serializable itemRendered;
        Serializable itemDisabled;
        String itemValue;
        Map labels;
        String itemLabel;
        String var;
        jg.writeStartObject();
        boolean isMulti = entity instanceof WidgetSelectOptions;
        jg.writeBooleanField("multiple", isMulti);
        Serializable value = entity.getValue();
        if (value != null) {
            this.writeSerializableField("value", value, jg);
        }
        if ((var = entity.getVar()) != null) {
            jg.writeStringField("var", var);
        }
        if ((itemLabel = entity.getItemLabel()) != null) {
            jg.writeStringField("itemLabel", itemLabel);
        }
        if (MapUtils.isNotEmpty((Map)(labels = entity.getItemLabels()))) {
            this.writeSerializableMapField("itemLabels", labels, jg);
        }
        if ((itemValue = entity.getItemValue()) != null) {
            jg.writeStringField("itemValue", itemValue);
        }
        if ((itemDisabled = entity.getItemDisabled()) != null) {
            this.writeSerializableField("itemDisabled", itemDisabled, jg);
        }
        if ((itemRendered = entity.getItemRendered()) != null) {
            this.writeSerializableField("itemRendered", itemRendered, jg);
        }
        if (isMulti) {
            Boolean caseSensitive;
            WidgetSelectOptions entities = (WidgetSelectOptions)entity;
            String ordering = entities.getOrdering();
            if (ordering != null) {
                jg.writeStringField("ordering", ordering);
            }
            if ((caseSensitive = entities.getCaseSensitive()) != null) {
                jg.writeBooleanField("caseSensitive", caseSensitive.booleanValue());
            }
        }
        jg.writeEndObject();
    }
}

