/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.connect.update.Version;

public class DependencySet {
    protected Map<String, Version> deps = new HashMap<String, Version>();
    protected Set<String> pkgNames;

    public DependencySet(Set<String> pkgNames) {
        this.pkgNames = pkgNames;
    }

    protected DependencySet(Set<String> pkgNames, Map<String, Version> deps) {
        this.pkgNames = pkgNames;
        this.deps = deps;
    }

    public void set(String pkgName, Version v) {
        assert (this.pkgNames.contains(pkgName));
        this.deps.put(pkgName, v);
    }

    public Version getTargetVersion(String pkgName) {
        return this.deps.get(pkgName);
    }

    public boolean isComplete() {
        return this.deps.keySet().containsAll(this.pkgNames);
    }

    public String getNextPackageName() {
        for (String pkgName : this.pkgNames) {
            if (this.deps.containsKey(pkgName)) continue;
            return pkgName;
        }
        return null;
    }

    public DependencySet clone() {
        HashMap<String, Version> cpDeps = new HashMap<String, Version>();
        cpDeps.putAll(this.deps);
        return new DependencySet(this.pkgNames, cpDeps);
    }
}

