/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.actions;

import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.dropwizard.metrics5.Timer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ActionContributionHandler;
import org.nuxeo.ecm.platform.actions.ActionFilter;
import org.nuxeo.ecm.platform.actions.ActionFilterRegistry;
import org.nuxeo.ecm.platform.actions.ActionRegistry;
import org.nuxeo.ecm.platform.actions.DefaultActionFilter;
import org.nuxeo.ecm.platform.actions.FilterContributionHandler;
import org.nuxeo.ecm.platform.actions.FilterFactory;
import org.nuxeo.ecm.platform.actions.TypeCompatibility;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class ActionService
extends DefaultComponent
implements ActionManager {
    public static final ComponentName ID = new ComponentName("org.nuxeo.ecm.platform.actions.ActionService");
    private static final long serialVersionUID = -5256555810901945824L;
    private static final Log log = LogFactory.getLog(ActionService.class);
    private ActionContributionHandler actions;
    private FilterContributionHandler filters;
    protected final MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    private static final String LOG_MIN_DURATION_KEY = "nuxeo.actions.debug.log_min_duration_ms";
    private long logMinDurationNanos = Duration.ofMillis(-1L).toNanos();
    private Timer actionsTimer;
    private Timer actionTimer;
    private Timer filtersTimer;
    private Timer filterTimer;

    public void activate(ComponentContext context) {
        this.filters = new FilterContributionHandler();
        this.actions = new ActionContributionHandler(this.filters);
        this.actionsTimer = this.metrics.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"ActionService", "actions"}));
        this.actionTimer = this.metrics.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"ActionService", "action"}));
        this.filtersTimer = this.metrics.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"ActionService", "filters"}));
        this.filterTimer = this.metrics.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"ActionService", "filter"}));
    }

    public void deactivate(ComponentContext context) {
        this.actions = null;
        this.filters = null;
        this.actionsTimer = null;
        this.actionTimer = null;
        this.filtersTimer = null;
        this.filterTimer = null;
    }

    public void start(ComponentContext context) {
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        long logMinDurationMillis = configurationService.getLong(LOG_MIN_DURATION_KEY, -1L);
        this.logMinDurationNanos = Duration.ofMillis(logMinDurationMillis).toNanos();
    }

    protected final ActionRegistry getActionRegistry() {
        return this.actions.getRegistry();
    }

    protected final ActionFilterRegistry getFilterRegistry() {
        return this.filters.getRegistry();
    }

    private void applyFilters(ActionContext context, List<Action> actions) {
        Iterator<Action> it = actions.iterator();
        while (it.hasNext()) {
            Action action = it.next();
            action.setFiltered(true);
            if (this.checkFilters(context, action)) continue;
            it.remove();
        }
    }

    @Override
    public boolean checkFilters(Action action, ActionContext context) {
        return this.checkFilters(context, action);
    }

    private boolean checkFilters(ActionContext context, Action action) {
        boolean granted;
        if (action == null) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Checking access for action '%s'...", action.getId()));
        }
        if (granted = this.checkFilters(action, action.getFilterIds(), context)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Granting access for action '%s'", action.getId()));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Denying access for action '%s'", action.getId()));
        }
        return granted;
    }

    @Override
    public List<Action> getActions(String category, ActionContext context) {
        return this.getActions(category, context, true);
    }

    @Override
    public List<Action> getAllActions(String category) {
        return this.getActionRegistry().getActions(category);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Action> getActions(String category, ActionContext context, boolean hideUnavailableActions) {
        ArrayList<Action> arrayList;
        List<Action> actions;
        Timer.Context timerContext;
        block7: {
            timerContext = this.actionsTimer.time();
            actions = this.getActionRegistry().getActions(category);
            if (!hideUnavailableActions) break block7;
            this.applyFilters(context, actions);
            List<Action> list = actions;
            long duration = timerContext.stop();
            if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                log.debug((Object)String.format("Resolving actions for category '%s' took: %.2f ms", category, (double)duration / 1000000.0));
            }
            return list;
        }
        try {
            ArrayList<Action> allActions = new ArrayList<Action>();
            allActions.addAll(actions);
            this.applyFilters(context, actions);
            for (Action a : allActions) {
                a.setAvailable(actions.contains(a));
            }
            arrayList = allActions;
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                log.debug((Object)String.format("Resolving actions for category '%s' took: %.2f ms", category, (double)duration / 1000000.0));
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
            log.debug((Object)String.format("Resolving actions for category '%s' took: %.2f ms", category, (double)duration / 1000000.0));
        }
        return arrayList;
    }

    protected boolean isTimeTracerLogEnabled() {
        return log.isDebugEnabled() && this.logMinDurationNanos >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Action getAction(String actionId, ActionContext context, boolean hideUnavailableAction) {
        block7: {
            timerContext = this.actionTimer.time();
            try {
                action = this.getActionRegistry().getAction(actionId);
                if (action == null) ** GOTO lbl22
                if (!hideUnavailableAction) break block7;
                if (this.checkFilters(context, action)) ** GOTO lbl21
                var6_6 = null;
            }
            catch (Throwable var9_10) {
                duration = timerContext.stop();
                if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                    ActionService.log.debug((Object)String.format("Resolving action with id '%s' took: %.2f ms", new Object[]{actionId, (double)duration / 1000000.0}));
                }
                throw var9_10;
            }
            duration = timerContext.stop();
            if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                ActionService.log.debug((Object)String.format("Resolving action with id '%s' took: %.2f ms", new Object[]{actionId, (double)duration / 1000000.0}));
            }
            return var6_6;
        }
        if (!this.checkFilters(context, action)) {
            action.setAvailable(false);
        }
lbl21:
        // 4 sources

        action.setFiltered(true);
lbl22:
        // 2 sources

        var6_7 = action;
        duration = timerContext.stop();
        if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
            ActionService.log.debug((Object)String.format("Resolving action with id '%s' took: %.2f ms", new Object[]{actionId, (double)duration / 1000000.0}));
        }
        return var6_7;
    }

    @Override
    public Action getAction(String actionId) {
        return this.getActionRegistry().getAction(actionId);
    }

    @Override
    public boolean isRegistered(String actionId) {
        return this.getActionRegistry().getAction(actionId) != null;
    }

    @Override
    public boolean isEnabled(String actionId, ActionContext context) {
        Action action = this.getActionRegistry().getAction(actionId);
        if (action != null) {
            return this.isEnabled(action, context);
        }
        return false;
    }

    public boolean isEnabled(Action action, ActionContext context) {
        ActionFilterRegistry filterReg = this.getFilterRegistry();
        for (String filterId : action.getFilterIds()) {
            ActionFilter filter = filterReg.getFilter(filterId);
            if (filter == null || filter.accept(action, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ActionFilter[] getFilters(String actionId) {
        Action action = this.getActionRegistry().getAction(actionId);
        if (action == null) {
            return null;
        }
        ActionFilterRegistry filterReg = this.getFilterRegistry();
        List<String> filterIds = action.getFilterIds();
        if (filterIds != null && !filterIds.isEmpty()) {
            ActionFilter[] filters = new ActionFilter[filterIds.size()];
            for (int i = 0; i < filters.length; ++i) {
                String filterId = filterIds.get(i);
                filters[i] = filterReg.getFilter(filterId);
            }
            return filters;
        }
        return null;
    }

    @Override
    public ActionFilter getFilter(String filterId) {
        return this.getFilterRegistry().getFilter(filterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkFilter(String filterId, ActionContext context) {
        boolean bl;
        Timer.Context timerContext = this.filterTimer.time();
        try {
            ActionFilter filter = this.getFilter(filterId);
            bl = filter != null && filter.accept(null, context);
        }
        catch (Throwable throwable) {
            long duration = timerContext.stop();
            if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                log.debug((Object)String.format("Resolving filter with id '%s' took: %.2f ms", filterId, (double)duration / 1000000.0));
            }
            throw throwable;
        }
        long duration = timerContext.stop();
        if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
            log.debug((Object)String.format("Resolving filter with id '%s' took: %.2f ms", filterId, (double)duration / 1000000.0));
        }
        return bl;
    }

    @Override
    public boolean checkFilters(List<String> filterIds, ActionContext context) {
        return this.checkFilters(null, filterIds, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkFilters(Action action, List<String> filterIds, ActionContext context) {
        block10: {
            if (filterIds == null || filterIds.isEmpty()) {
                return true;
            }
            timerContext = this.filtersTimer.time();
            try {
                filterReg = this.getFilterRegistry();
lbl6:
                // 4 sources

                for (String filterId : filterIds) {
                    filter = filterReg.getFilter(filterId);
                    if (filter == null) continue;
                    if (!filter.accept(action, context)) {
                        if (ActionService.log.isTraceEnabled()) {
                            ActionService.log.trace((Object)String.format("Filter '%s' denied access", new Object[]{filterId}));
                        }
                        var9_11 = false;
                        break block10;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl29
            }
            catch (Throwable var12_13) {
                duration = timerContext.stop();
                if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
                    ActionService.log.debug((Object)String.format("Resolving filters %s took: %.2f ms", new Object[]{filterIds, (double)duration / 1000000.0}));
                }
                throw var12_13;
            }
        }
        duration = timerContext.stop();
        if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
            ActionService.log.debug((Object)String.format("Resolving filters %s took: %.2f ms", new Object[]{filterIds, (double)duration / 1000000.0}));
        }
        return var9_11;
lbl-1000:
        // 1 sources

        {
            if (!ActionService.log.isTraceEnabled()) ** GOTO lbl6
            ActionService.log.trace((Object)String.format("Filter '%s' granted access", new Object[]{filterId}));
            ** GOTO lbl6
lbl29:
            // 1 sources

            var6_7 = true;
        }
        duration = timerContext.stop();
        if (this.isTimeTracerLogEnabled() && duration > this.logMinDurationNanos) {
            ActionService.log.debug((Object)String.format("Resolving filters %s took: %.2f ms", new Object[]{filterIds, (double)duration / 1000000.0}));
        }
        return var6_7;
    }

    @Override
    public void addAction(Action action) {
        this.getActionRegistry().addAction(action);
    }

    @Override
    public Action removeAction(String actionId) {
        return this.getActionRegistry().removeAction(actionId);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("actions".equals(extensionPoint)) {
            this.actions.addContribution((Action)contribution);
        } else if ("filters".equals(extensionPoint)) {
            if (contribution.getClass() == FilterFactory.class) {
                this.registerFilterFactory((FilterFactory)contribution);
            } else {
                this.filters.addContribution((DefaultActionFilter)contribution);
            }
        } else if ("typeCompatibility".equals(extensionPoint)) {
            this.actions.getRegistry().getTypeCategoryRelations().add((TypeCompatibility)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("actions".equals(extensionPoint)) {
            this.actions.removeContribution((Action)contribution);
        } else if ("filters".equals(extensionPoint)) {
            if (contribution.getClass() == FilterFactory.class) {
                this.unregisterFilterFactory((FilterFactory)contribution);
            } else {
                this.filters.removeContribution((DefaultActionFilter)contribution);
            }
        }
    }

    @Deprecated
    protected void registerFilterFactory(FilterFactory ff) {
        this.getFilterRegistry().removeFilter(ff.id);
        try {
            ActionFilter filter = (ActionFilter)Thread.currentThread().getContextClassLoader().loadClass(ff.className).newInstance();
            filter.setId(ff.id);
            this.getFilterRegistry().addFilter(filter);
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)"Failed to create action filter", (Throwable)e);
        }
    }

    @Deprecated
    public void unregisterFilterFactory(FilterFactory ff) {
        this.getFilterRegistry().removeFilter(ff.id);
    }

    @Override
    public void remove() {
    }
}

