/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ImplicitLinkedHashCollection<E extends Element>
extends AbstractCollection<E> {
    private static final int HEAD_INDEX = -1;
    public static final int INVALID_INDEX = -2;
    private static final int MIN_NONEMPTY_CAPACITY = 5;
    private static final Element[] EMPTY_ELEMENTS = new Element[0];
    private Element head;
    Element[] elements;
    private int size;

    private static Element indexToElement(Element head, Element[] elements, int index) {
        if (index == -1) {
            return head;
        }
        return elements[index];
    }

    private static void addToListTail(Element head, Element[] elements, int elementIdx) {
        int oldTailIdx = head.prev();
        Element element = ImplicitLinkedHashCollection.indexToElement(head, elements, elementIdx);
        Element oldTail = ImplicitLinkedHashCollection.indexToElement(head, elements, oldTailIdx);
        head.setPrev(elementIdx);
        oldTail.setNext(elementIdx);
        element.setPrev(oldTailIdx);
        element.setNext(-1);
    }

    private static void removeFromList(Element head, Element[] elements, int elementIdx) {
        Element element = ImplicitLinkedHashCollection.indexToElement(head, elements, elementIdx);
        elements[elementIdx] = null;
        int prevIdx = element.prev();
        int nextIdx = element.next();
        Element prev = ImplicitLinkedHashCollection.indexToElement(head, elements, prevIdx);
        Element next = ImplicitLinkedHashCollection.indexToElement(head, elements, nextIdx);
        prev.setNext(nextIdx);
        next.setPrev(prevIdx);
        element.setNext(-2);
        element.setPrev(-2);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.listIterator(0);
    }

    private ListIterator<E> listIterator(int index) {
        return new ImplicitLinkedHashCollectionIterator(index);
    }

    final int slot(Element[] curElements, Object e) {
        return (e.hashCode() & Integer.MAX_VALUE) % curElements.length;
    }

    private final int findIndexOfEqualElement(Object key) {
        if (key == null || this.size == 0) {
            return -2;
        }
        int slot = this.slot(this.elements, key);
        for (int seen = 0; seen < this.elements.length; ++seen) {
            Element element = this.elements[slot];
            if (element == null) {
                return -2;
            }
            if (key.equals(element)) {
                return slot;
            }
            slot = (slot + 1) % this.elements.length;
        }
        return -2;
    }

    public final E find(E key) {
        int index = this.findIndexOfEqualElement(key);
        if (index == -2) {
            return null;
        }
        Element result = this.elements[index];
        return (E)result;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean contains(Object key) {
        return this.findIndexOfEqualElement(key) != -2;
    }

    private static int calculateCapacity(int expectedNumElements) {
        int newCapacity = 2 * expectedNumElements + 1;
        if (newCapacity < 5) {
            return 5;
        }
        return newCapacity;
    }

    @Override
    public final boolean add(E newElement) {
        int slot;
        if (newElement == null) {
            return false;
        }
        if (newElement.prev() != -2 || newElement.next() != -2) {
            return false;
        }
        if (this.size + 1 >= this.elements.length / 2) {
            this.changeCapacity(ImplicitLinkedHashCollection.calculateCapacity(this.elements.length));
        }
        if ((slot = this.addInternal((Element)newElement, this.elements)) >= 0) {
            ImplicitLinkedHashCollection.addToListTail(this.head, this.elements, slot);
            ++this.size;
            return true;
        }
        return false;
    }

    public final void mustAdd(E newElement) {
        if (!this.add(newElement)) {
            throw new RuntimeException("Unable to add " + newElement);
        }
    }

    int addInternal(Element newElement, Element[] addElements) {
        int slot = this.slot(addElements, newElement);
        for (int seen = 0; seen < addElements.length; ++seen) {
            Element element = addElements[slot];
            if (element == null) {
                addElements[slot] = newElement;
                return slot;
            }
            if (element.equals(newElement)) {
                return -2;
            }
            slot = (slot + 1) % addElements.length;
        }
        throw new RuntimeException("Not enough hash table slots to add a new element.");
    }

    private void changeCapacity(int newCapacity) {
        Element[] newElements = new Element[newCapacity];
        HeadElement newHead = new HeadElement();
        int oldSize = this.size;
        Iterator<E> iter = this.iterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            iter.remove();
            int newSlot = this.addInternal(element, newElements);
            ImplicitLinkedHashCollection.addToListTail(newHead, newElements, newSlot);
        }
        this.elements = newElements;
        this.head = newHead;
        this.size = oldSize;
    }

    @Override
    public final boolean remove(Object key) {
        int slot = this.findElementToRemove(key);
        if (slot == -2) {
            return false;
        }
        this.removeElementAtSlot(slot);
        return true;
    }

    int findElementToRemove(Object key) {
        return this.findIndexOfEqualElement(key);
    }

    private boolean removeElementAtSlot(int slot) {
        Element element;
        --this.size;
        ImplicitLinkedHashCollection.removeFromList(this.head, this.elements, slot);
        int endSlot = slot = (slot + 1) % this.elements.length;
        for (int seen = 0; seen < this.elements.length && (element = this.elements[endSlot]) != null; ++seen) {
            endSlot = (endSlot + 1) % this.elements.length;
        }
        while (slot != endSlot) {
            this.reseat(slot);
            slot = (slot + 1) % this.elements.length;
        }
        return true;
    }

    private void reseat(int prevSlot) {
        Element e;
        Element element = this.elements[prevSlot];
        int newSlot = this.slot(this.elements, element);
        for (int seen = 0; seen < this.elements.length && (e = this.elements[newSlot]) != null && e != element; ++seen) {
            newSlot = (newSlot + 1) % this.elements.length;
        }
        if (newSlot == prevSlot) {
            return;
        }
        Element prev = ImplicitLinkedHashCollection.indexToElement(this.head, this.elements, element.prev());
        prev.setNext(newSlot);
        Element next = ImplicitLinkedHashCollection.indexToElement(this.head, this.elements, element.next());
        next.setPrev(newSlot);
        this.elements[prevSlot] = null;
        this.elements[newSlot] = element;
    }

    public ImplicitLinkedHashCollection() {
        this(0);
    }

    public ImplicitLinkedHashCollection(int expectedNumElements) {
        this.clear(expectedNumElements);
    }

    public ImplicitLinkedHashCollection(Iterator<E> iter) {
        this.clear(0);
        while (iter.hasNext()) {
            this.mustAdd((Element)iter.next());
        }
    }

    @Override
    public final void clear() {
        this.clear(this.elements.length);
    }

    public final void clear(int expectedNumElements) {
        if (expectedNumElements == 0) {
            this.head = HeadElement.EMPTY;
            this.elements = EMPTY_ELEMENTS;
            this.size = 0;
        } else {
            this.head = new HeadElement();
            this.elements = new Element[ImplicitLinkedHashCollection.calculateCapacity(expectedNumElements)];
            this.size = 0;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImplicitLinkedHashCollection)) {
            return false;
        }
        ImplicitLinkedHashCollection ilhs = (ImplicitLinkedHashCollection)o;
        return this.valuesList().equals(ilhs.valuesList());
    }

    @Override
    public int hashCode() {
        return this.valuesList().hashCode();
    }

    final int numSlots() {
        return this.elements.length;
    }

    public List<E> valuesList() {
        return new ImplicitLinkedHashCollectionListView();
    }

    public Set<E> valuesSet() {
        return new ImplicitLinkedHashCollectionSetView();
    }

    private class ImplicitLinkedHashCollectionSetView
    extends AbstractSet<E> {
        private ImplicitLinkedHashCollectionSetView() {
        }

        @Override
        public Iterator<E> iterator() {
            return ImplicitLinkedHashCollection.this.iterator();
        }

        @Override
        public int size() {
            return ImplicitLinkedHashCollection.this.size;
        }

        @Override
        public boolean add(E newElement) {
            return ImplicitLinkedHashCollection.this.add(newElement);
        }

        @Override
        public boolean remove(Object key) {
            return ImplicitLinkedHashCollection.this.remove(key);
        }

        @Override
        public boolean contains(Object key) {
            return ImplicitLinkedHashCollection.this.contains(key);
        }

        @Override
        public void clear() {
            ImplicitLinkedHashCollection.this.clear();
        }
    }

    private class ImplicitLinkedHashCollectionListView
    extends AbstractSequentialList<E> {
        private ImplicitLinkedHashCollectionListView() {
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            if (index < 0 || index > ImplicitLinkedHashCollection.this.size) {
                throw new IndexOutOfBoundsException();
            }
            return ImplicitLinkedHashCollection.this.listIterator(index);
        }

        @Override
        public int size() {
            return ImplicitLinkedHashCollection.this.size;
        }
    }

    private class ImplicitLinkedHashCollectionIterator
    implements ListIterator<E> {
        private int cursor = 0;
        private Element cur = ImplicitLinkedHashCollection.access$000(ImplicitLinkedHashCollection.this);
        private int lastReturnedSlot = -2;

        ImplicitLinkedHashCollectionIterator(int index) {
            for (int i = 0; i < index; ++i) {
                this.cur = ImplicitLinkedHashCollection.indexToElement(ImplicitLinkedHashCollection.this.head, ImplicitLinkedHashCollection.this.elements, this.cur.next());
                ++this.cursor;
            }
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ImplicitLinkedHashCollection.this.size;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E next() {
            if (this.cursor == ImplicitLinkedHashCollection.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturnedSlot = this.cur.next();
            this.cur = ImplicitLinkedHashCollection.indexToElement(ImplicitLinkedHashCollection.this.head, ImplicitLinkedHashCollection.this.elements, this.cur.next());
            ++this.cursor;
            Element returnValue = this.cur;
            return returnValue;
        }

        @Override
        public E previous() {
            if (this.cursor == 0) {
                throw new NoSuchElementException();
            }
            Element returnValue = this.cur;
            this.cur = ImplicitLinkedHashCollection.indexToElement(ImplicitLinkedHashCollection.this.head, ImplicitLinkedHashCollection.this.elements, this.cur.prev());
            this.lastReturnedSlot = this.cur.next();
            --this.cursor;
            return returnValue;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            if (this.lastReturnedSlot == -2) {
                throw new IllegalStateException();
            }
            if (this.cur == ImplicitLinkedHashCollection.indexToElement(ImplicitLinkedHashCollection.this.head, ImplicitLinkedHashCollection.this.elements, this.lastReturnedSlot)) {
                --this.cursor;
                this.cur = ImplicitLinkedHashCollection.indexToElement(ImplicitLinkedHashCollection.this.head, ImplicitLinkedHashCollection.this.elements, this.cur.prev());
            }
            ImplicitLinkedHashCollection.this.removeElementAtSlot(this.lastReturnedSlot);
            this.lastReturnedSlot = -2;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    private static class HeadElement
    implements Element {
        static final HeadElement EMPTY = new HeadElement();
        private int prev = -1;
        private int next = -1;

        private HeadElement() {
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public void setPrev(int prev) {
            this.prev = prev;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public void setNext(int next) {
            this.next = next;
        }
    }

    public static interface Element {
        public int prev();

        public void setPrev(int var1);

        public int next();

        public void setNext(int var1);
    }
}

