/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.query.sql.model.DefaultQueryVisitor;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Predicates;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryDeleteConstraintException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectorySecurityException;
import org.nuxeo.ecm.directory.EntrySource;
import org.nuxeo.ecm.directory.OperationNotAllowedException;
import org.nuxeo.ecm.directory.PermissionDescriptor;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryDeleteConstraint;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public abstract class BaseSession
implements Session,
EntrySource {
    protected static final String POWER_USERS_GROUP = "powerusers";
    protected static final String READONLY_ENTRY_FLAG = "READONLY_ENTRY";
    protected static final String MULTI_TENANT_ID_FORMAT = "tenant_%s_%s";
    protected static final String TENANT_ID_FIELD = "tenantId";
    private static final Log log = LogFactory.getLog(BaseSession.class);
    protected final Directory directory;
    protected PermissionDescriptor[] permissions = null;
    protected boolean readAllColumns;
    protected String schemaName;
    protected String directoryName;
    protected BaseDirectoryDescriptor.SubstringMatchType substringMatchType;
    protected Class<? extends Reference> referenceClass;
    protected String passwordHashAlgorithm;
    protected boolean autoincrementId;
    protected boolean computeMultiTenantId;

    protected BaseSession(Directory directory, Class<? extends Reference> referenceClass) {
        this.directory = directory;
        this.schemaName = directory.getSchema();
        this.directoryName = directory.getName();
        BaseDirectoryDescriptor desc = directory.getDescriptor();
        this.substringMatchType = desc.getSubstringMatchType();
        this.autoincrementId = desc.isAutoincrementIdField();
        this.permissions = desc.permissions;
        this.passwordHashAlgorithm = desc.passwordHashAlgorithm;
        this.referenceClass = referenceClass;
        this.computeMultiTenantId = desc.isComputeMultiTenantId();
    }

    public abstract Directory getDirectory();

    @Override
    public void setReadAllColumns(boolean readAllColumns) {
        this.readAllColumns = readAllColumns;
    }

    @Override
    public String getIdField() {
        return this.directory.getIdField();
    }

    @Override
    public String getPasswordField() {
        return this.directory.getPasswordField();
    }

    @Override
    public boolean isAuthenticating() {
        return this.directory.getPasswordField() != null;
    }

    @Override
    public boolean isReadOnly() {
        return this.directory.isReadOnly();
    }

    public void checkPermission(String permission) {
        if (this.hasPermission(permission)) {
            return;
        }
        if (permission.equals("Write") && this.isReadOnly()) {
            throw new DirectorySecurityException("Directory is read-only");
        }
        NuxeoPrincipal user = NuxeoPrincipal.getCurrent();
        throw new DirectorySecurityException("User " + user + " does not have " + permission + " permission");
    }

    public void checkDeleteConstraints(String entryId) {
        List<DirectoryDeleteConstraint> deleteConstraints = this.directory.getDirectoryDeleteConstraints();
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        if (deleteConstraints != null && !deleteConstraints.isEmpty()) {
            for (DirectoryDeleteConstraint deleteConstraint : deleteConstraints) {
                if (deleteConstraint.canDelete(directoryService, entryId)) continue;
                throw new DirectoryDeleteConstraintException("This entry is referenced in another vocabulary.");
            }
        }
    }

    public boolean hasPermission(String permission) {
        if (permission.equals("Write") && this.isReadOnly()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Directory is read-only");
            }
            return false;
        }
        NuxeoPrincipal user = NuxeoPrincipal.getCurrent();
        if (user == null) {
            return false;
        }
        if (user.isAdministrator()) {
            return true;
        }
        if (this.permissions == null || this.permissions.length == 0) {
            if (user.isAdministrator()) {
                return true;
            }
            if (user.isMemberOf(POWER_USERS_GROUP)) {
                return true;
            }
            if (permission.equals("Read")) {
                return true;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("User " + user + " does not have " + permission + " permission"));
            }
            return false;
        }
        ArrayList<String> groups = new ArrayList<String>(user.getAllGroups());
        groups.add("Everyone");
        String username = user.getName();
        boolean allowed = this.hasPermission(permission, username, groups);
        if (!allowed && permission.equals("Read")) {
            allowed = this.hasPermission("Write", username, groups);
        }
        if (!allowed && log.isTraceEnabled()) {
            log.trace((Object)("User " + user + " does not have " + permission + " permission"));
        }
        return allowed;
    }

    protected boolean hasPermission(String permission, String username, List<String> groups) {
        for (PermissionDescriptor desc : this.permissions) {
            if (!desc.name.equals(permission)) continue;
            if (desc.groups != null) {
                for (String group : desc.groups) {
                    if (!groups.contains(group)) continue;
                    return true;
                }
            }
            if (desc.users == null) continue;
            for (String user : desc.users) {
                if (!user.equals(username)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static DocumentModel createEntryModel(String sessionId, String schema, String id, Map<String, Object> values) throws PropertyException {
        return BaseSession.createEntryModel(schema, id, values, false);
    }

    public static DocumentModel createEntryModel(String schema) {
        return BaseSession.createEntryModel(schema, null, null, false);
    }

    public static DocumentModel createEntryModel(String schema, String id, Map<String, Object> values) {
        return BaseSession.createEntryModel(schema, id, values, false);
    }

    @Deprecated
    public static DocumentModel createEntryModel(String sessionId, String schema, String id, Map<String, Object> values, boolean readOnly) throws PropertyException {
        return BaseSession.createEntryModel(schema, id, values, readOnly);
    }

    public static DocumentModel createEntryModel(String schema, String id, Map<String, Object> values, boolean readOnly) {
        DocumentModelImpl entry = new DocumentModelImpl(schema, id, null, null, null, new String[]{schema}, new HashSet(), null, false, null, null, null);
        if (values == null) {
            values = Collections.emptyMap();
        }
        DataModelImpl dataModel = new DataModelImpl(schema, values);
        entry.addDataModel((DataModel)dataModel);
        if (readOnly) {
            BaseSession.setReadOnlyEntry((DocumentModel)entry);
        }
        return entry;
    }

    public static boolean isReadOnlyEntry(DocumentModel entry) {
        return Boolean.TRUE.equals(entry.getContextData(READONLY_ENTRY_FLAG));
    }

    public static void setReadOnlyEntry(DocumentModel entry) {
        entry.putContextData(READONLY_ENTRY_FLAG, (Serializable)Boolean.TRUE);
    }

    public static void setReadWriteEntry(DocumentModel entry) {
        entry.putContextData(READONLY_ENTRY_FLAG, (Serializable)Boolean.FALSE);
    }

    public static String computeMultiTenantDirectoryId(String tenantId, String id) {
        return String.format(MULTI_TENANT_ID_FORMAT, tenantId, id);
    }

    @Override
    public DocumentModel getEntry(String id) {
        return this.getEntry(id, true);
    }

    @Override
    public DocumentModel getEntry(String id, boolean fetchReferences) {
        if (!this.hasPermission("Read")) {
            return null;
        }
        if (this.readAllColumns) {
            return this.getEntryFromSource(id, fetchReferences);
        }
        return this.directory.getCache().getEntry(id, this, fetchReferences);
    }

    @Override
    public DocumentModelList getEntries() {
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        return this.query(Collections.emptyMap());
    }

    @Override
    public DocumentModel getEntryFromSource(String id, boolean fetchReferences) {
        String idFieldName = this.directory.getSchemaFieldMap().get(this.getIdField()).getName().getPrefixedName();
        DocumentModelList result = this.query(Collections.singletonMap(idFieldName, id), Collections.emptySet(), Collections.emptyMap(), true);
        return result.isEmpty() ? null : (DocumentModel)result.get(0);
    }

    @Override
    public DocumentModel createEntry(DocumentModel documentModel) {
        return this.createEntry(documentModel.getProperties(this.schemaName));
    }

    @Override
    public DocumentModel createEntry(Map<String, Object> fieldMap) {
        this.checkPermission("Write");
        DocumentModel docModel = this.createEntryWithoutReferences(fieldMap);
        Map<String, Field> schemaFieldMap = this.directory.getSchemaFieldMap();
        String idFieldName = schemaFieldMap.get(this.getIdField()).getName().getPrefixedName();
        Object entry = fieldMap.get(idFieldName);
        String sourceId = docModel.getId();
        for (Reference reference : this.getDirectory().getReferences()) {
            String referenceFieldName = schemaFieldMap.get(reference.getFieldName()).getName().getPrefixedName();
            if (this.getDirectory().getReferences(reference.getFieldName()).size() > 1) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Directory " + this.directoryName + " cannot create field " + reference.getFieldName() + " for entry " + entry + ": this field is associated with more than one reference"));
                continue;
            }
            List<String> targetIds = BaseSession.toStringList(fieldMap.get(referenceFieldName));
            if (reference.getClass() == this.referenceClass) {
                reference.addLinks(sourceId, targetIds, (Session)this);
                continue;
            }
            reference.addLinks(sourceId, targetIds);
        }
        this.getDirectory().invalidateCaches();
        return docModel;
    }

    @Override
    public void updateEntry(DocumentModel docModel) {
        this.checkPermission("Write");
        String id = docModel.getId();
        if (id == null) {
            throw new DirectoryException("The document cannot be updated because its id is missing");
        }
        List<String> referenceFieldList = this.updateEntryWithoutReferences(docModel);
        for (String referenceFieldName : referenceFieldList) {
            List<Reference> references = this.directory.getReferences(referenceFieldName);
            if (references.size() > 1) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Directory " + this.getDirectory().getName() + " cannot update field " + referenceFieldName + " for entry " + docModel.getId() + ": this field is associated with more than one reference"));
                continue;
            }
            Reference reference = references.get(0);
            List<String> targetIds = BaseSession.toStringList(docModel.getProperty(this.schemaName, referenceFieldName));
            if (reference.getClass() == this.referenceClass) {
                reference.setTargetIdsForSource(docModel.getId(), targetIds, this);
                continue;
            }
            reference.setTargetIdsForSource(docModel.getId(), targetIds);
        }
        this.getDirectory().invalidateCaches();
    }

    public static List<String> toStringList(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        throw new NuxeoException("Cannot convert to List<String>: " + value);
    }

    @Override
    public void deleteEntry(DocumentModel docModel) {
        this.deleteEntry(docModel.getId());
    }

    @Override
    @Deprecated
    public void deleteEntry(String id, Map<String, String> map) {
        this.deleteEntry(id);
    }

    @Override
    public void deleteEntry(String id) {
        if (!this.canDeleteMultiTenantEntry(id)) {
            throw new OperationNotAllowedException("Operation not allowed in the current tenant context", "label.directory.error.multi.tenant.operationNotAllowed", null);
        }
        this.checkPermission("Write");
        this.checkDeleteConstraints(id);
        for (Reference reference : this.getDirectory().getReferences()) {
            if (reference.getClass() == this.referenceClass) {
                reference.removeLinksForSource(id, this);
                continue;
            }
            reference.removeLinksForSource(id);
        }
        this.deleteEntryWithoutReferences(id);
        this.getDirectory().invalidateCaches();
    }

    protected boolean canDeleteMultiTenantEntry(String entryId) {
        DocumentModel entry;
        String entryTenantId;
        String tenantId;
        if (this.isMultiTenant() && StringUtils.isNotBlank((CharSequence)(tenantId = this.getCurrentTenantId())) && (StringUtils.isBlank((CharSequence)(entryTenantId = (String)(entry = this.getEntry(entryId)).getProperty(this.schemaName, TENANT_ID_FIELD))) || !entryTenantId.equals(tenantId))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Trying to delete entry '%s' not part of current tenant '%s'", entryId, tenantId));
            }
            return false;
        }
        return true;
    }

    public DocumentModelList applyQueryLimits(DocumentModelList results, int limit, int offset) {
        int toIndex;
        int size = results.size();
        offset = Math.max(0, offset);
        int n = toIndex = limit < 1 ? size : Math.min(size, offset + limit);
        if (offset == 0 && toIndex == size) {
            return results;
        }
        DocumentModelListImpl sublist = new DocumentModelListImpl(results.subList(offset, toIndex));
        sublist.setTotalSize((long)size);
        return sublist;
    }

    public <T> List<T> applyQueryLimits(List<T> list, int limit, int offset) {
        int toIndex;
        int size = list.size();
        offset = Math.max(0, offset);
        int n = toIndex = limit < 1 ? size : Math.min(size, offset + limit);
        if (offset == 0 && toIndex == size) {
            return list;
        }
        return new ArrayList<T>(list.subList(offset, toIndex));
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter) {
        return this.query(filter, Collections.emptySet());
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext) {
        return this.query(filter, fulltext, new HashMap<String, String>());
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) {
        return this.query(filter, fulltext, orderBy, false);
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) {
        return this.query(filter, fulltext, orderBy, fetchReferences, -1, 0);
    }

    @Override
    public List<String> getProjection(Map<String, Serializable> filter, String columnName) {
        return this.getProjection(filter, Collections.emptySet(), columnName);
    }

    @Override
    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) {
        DocumentModelList docList = this.query(filter, fulltext);
        ArrayList<String> result = new ArrayList<String>();
        for (DocumentModel docModel : docList) {
            Object obj = docModel.getProperty(this.schemaName, columnName);
            String propValue = String.valueOf(obj);
            result.add(propValue);
        }
        return result;
    }

    protected boolean isMultiTenant() {
        return this.directory.isMultiTenant();
    }

    protected QueryBuilder addTenantId(QueryBuilder queryBuilder) {
        if (!this.isMultiTenant()) {
            return queryBuilder;
        }
        String tenantId = this.getCurrentTenantId();
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            return queryBuilder;
        }
        Predicate predicate = Predicates.eq((String)TENANT_ID_FIELD, (Object)tenantId);
        queryBuilder = new QueryBuilder(queryBuilder);
        MultiExpression multiExpression = queryBuilder.predicate();
        if (multiExpression.predicates.isEmpty()) {
            queryBuilder.predicate(predicate);
        } else if (multiExpression.operator == Operator.AND || multiExpression.predicates.size() == 1) {
            queryBuilder.and(predicate);
        } else {
            queryBuilder.filter(new MultiExpression(Operator.AND, new ArrayList<Predicate>(Arrays.asList(predicate, multiExpression))));
        }
        return queryBuilder;
    }

    protected String getCurrentTenantId() {
        NuxeoPrincipal principal = NuxeoPrincipal.getCurrent();
        return principal != null ? principal.getTenantId() : null;
    }

    protected abstract DocumentModel createEntryWithoutReferences(Map<String, Object> var1);

    protected abstract List<String> updateEntryWithoutReferences(DocumentModel var1);

    protected abstract void deleteEntryWithoutReferences(String var1);

    public static class FieldDetector
    extends DefaultQueryVisitor {
        protected final String field;
        protected boolean hasField;

        public static boolean hasField(MultiExpression predicate, String field) {
            FieldDetector visitor = new FieldDetector(field);
            visitor.visitMultiExpression(predicate);
            return visitor.hasField;
        }

        public FieldDetector(String passwordField) {
            this.field = passwordField;
        }

        public void visitReference(org.nuxeo.ecm.core.query.sql.model.Reference node) {
            if (node.name.equals(this.field)) {
                this.hasField = true;
            }
        }
    }
}

