/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.impl;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.EntryAdaptor;

public class WritePolicyEntryAdaptor
implements EntryAdaptor {
    public static final Log log = LogFactory.getLog(WritePolicyEntryAdaptor.class);
    protected String fieldName;
    protected Pattern pattern;

    @Override
    public DocumentModel adapt(Directory directory, DocumentModel entry) {
        if (this.fieldName == null || this.pattern == null) {
            log.warn((Object)(this.getClass().getName() + " is missing configuration parameters"));
            return entry;
        }
        if (BaseSession.isReadOnlyEntry(entry)) {
            return entry;
        }
        try {
            String value;
            Object fieldValue = entry.getProperty(directory.getSchema(), this.fieldName);
            String string = value = fieldValue != null ? fieldValue.toString() : "";
            if (this.pattern.matcher(value).matches()) {
                BaseSession.setReadWriteEntry(entry);
            } else {
                BaseSession.setReadOnlyEntry(entry);
            }
        }
        catch (PropertyException e) {
            throw new DirectoryException(String.format("The field '%s' of entry '%s' could not be adapt and map on directory '%s', check that the field exist in the schema", this.fieldName, entry.getId(), directory.getName()), e);
        }
        return entry;
    }

    @Override
    public void setParameter(String name, String value) {
        if ("fieldName".equals(name)) {
            this.fieldName = value;
        } else if ("regexp".equals(name)) {
            this.pattern = Pattern.compile(value);
        } else {
            log.warn((Object)("unexpected parameter " + name + " for class " + this.getClass().getName()));
        }
    }
}

