/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.we;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.client.vindoz.InstallAfterRestart;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.ecm.admin.NuxeoCtlManager;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="uninstallHandler")
public class UninstallHandler
extends DefaultObject {
    protected static final Log log = LogFactory.getLog(UninstallHandler.class);

    @GET
    @Produces(value={"text/html"})
    @Path(value="start/{pkgId}")
    public Object startUninstall(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        try {
            PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
            LocalPackage pkg = pus.getPackage(pkgId);
            Task uninstallTask = pkg.getUninstallTask();
            ValidationStatus status = uninstallTask.validate();
            if (status.hasErrors()) {
                return this.getView("canNotUninstall").arg("status", (Object)status).arg("pkg", (Object)pkg).arg("source", (Object)source);
            }
            PackageManager pm = (PackageManager)Framework.getService(PackageManager.class);
            List pkgToRemove = pm.getUninstallDependencies((Package)pkg, this.getTargetPlatform(filterOnPlatform));
            if (pkgToRemove.size() > 0) {
                return this.getView("displayDependencies").arg("pkg", (Object)pkg).arg("pkgToRemove", (Object)pkgToRemove).arg("source", (Object)source);
            }
            return this.getView("startUninstall").arg("status", (Object)status).arg("uninstallTask", (Object)uninstallTask).arg("pkg", (Object)pkg).arg("source", (Object)source);
        }
        catch (PackageException e) {
            log.error((Object)"Error during first step of installation", (Throwable)e);
            return this.getView("uninstallError").arg("e", (Object)e);
        }
    }

    private String getTargetPlatform(Boolean filterOnPlatform) {
        if (filterOnPlatform != Boolean.TRUE) {
            return null;
        }
        return PlatformVersionHelper.getPlatformFilter();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="run/{pkgId}")
    public Object doUninstall(@PathParam(value="pkgId") String pkgId, @QueryParam(value="source") String source, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        PackageUpdateService pus = (PackageUpdateService)Framework.getService(PackageUpdateService.class);
        try {
            LocalPackage pkg = pus.getPackage(pkgId);
            PackageManager pm = (PackageManager)Framework.getService(PackageManager.class);
            List pkgToRemove = pm.getUninstallDependencies((Package)pkg, this.getTargetPlatform(filterOnPlatform));
            boolean restartRequired = InstallAfterRestart.isNeededForPackage((Package)pkg);
            if (!restartRequired) {
                for (DownloadablePackage rpkg : pkgToRemove) {
                    if (!InstallAfterRestart.isNeededForPackage((Package)rpkg)) continue;
                    restartRequired = true;
                    break;
                }
            }
            if (restartRequired) {
                InstallAfterRestart.addPackageForUnInstallation(pkg.getName());
                return this.getView("uninstallOnRestart").arg("pkg", (Object)pkg).arg("source", (Object)source);
            }
            log.debug((Object)("Uninstalling: " + pkgToRemove));
            for (DownloadablePackage rpkg : pkgToRemove) {
                LocalPackage localPackage = pus.getPackage(rpkg.getId());
                this.performUninstall(localPackage);
            }
            Task uninstallTask = this.performUninstall(pkg);
            return this.getView("uninstallDone").arg("uninstallTask", (Object)uninstallTask).arg("pkg", (Object)pkg).arg("source", (Object)source);
        }
        catch (PackageException e) {
            log.error((Object)("Error during uninstall of " + pkgId), (Throwable)e);
            return this.getView("uninstallError").arg("e", (Object)e).arg("source", (Object)source);
        }
    }

    protected Task performUninstall(LocalPackage localPackage) throws PackageException {
        log.info((Object)("Uninstalling " + localPackage.getId()));
        Task uninstallTask = localPackage.getUninstallTask();
        try {
            uninstallTask.run(null);
        }
        catch (PackageException e) {
            log.error((Object)("Error during uninstall of " + localPackage.getId()), (Throwable)e);
            uninstallTask.rollback();
            throw e;
        }
        return uninstallTask;
    }

    @POST
    @Path(value="restart")
    public Object restartServer() {
        NuxeoCtlManager.restart();
        return Response.ok().build();
    }
}

