/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.operation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.ecm.admin.permissions.PermissionsPurgeWork;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="PermissionsPurge", category="Services", label="Archiving ACEs", description="Schedule a work to archive ACEs based on permissions_purge page provider from the input document.")
public class PermissionsPurge {
    static final String ID = "PermissionsPurge";
    @Param(name="usernames", description="Coma separate list of username")
    protected String usernames = "";
    @Context
    protected CoreSession session;

    @OperationMethod
    public void purgeDocs(List<DocumentModel> docs) {
        List ancestorIds = docs.stream().map(DocumentModel::getId).collect(Collectors.toList());
        List<String> usernames = Arrays.asList(this.usernames.split(",\\s*"));
        DocumentModel searchDocument = this.session.createDocumentModel("PermissionsSearch");
        searchDocument.setPropertyValue("rs:ace_username", (Serializable)((Object)usernames));
        searchDocument.setPropertyValue("rs:ecm_ancestorIds", (Serializable)((Object)ancestorIds));
        new PermissionsPurgeWork(searchDocument).launch();
    }

    @OperationMethod
    public void purgeDoc(DocumentModel doc) {
        this.purgeDocs(Collections.singletonList(doc));
    }

    @OperationMethod
    public void purge() {
        this.purgeDocs(Collections.emptyList());
    }
}

