/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.Link;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.propagation.BinaryFormat;
import io.opencensus.trace.propagation.SpanContextParseException;
import java.io.Externalizable;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.work.WorkComputation;
import org.nuxeo.ecm.core.work.WorkManagerImpl;
import org.nuxeo.ecm.core.work.WorkStateHelper;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.NuxeoLoginContext;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.stream.StreamService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class AbstractWork
implements Work {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractWork.class);
    protected static final Random RANDOM = new SecureRandom();
    public static final String WORK_FAILED_EVENT = "workFailed";
    public static final String WORK_INSTANCE = "workInstance";
    public static final String FAILURE_MSG = "failureMsg";
    public static final String FAILURE_EXCEPTION = "failureException";
    protected String id;
    protected volatile transient boolean suspending;
    protected volatile transient boolean suspended;
    protected Work.State state;
    protected Work.Progress progress;
    protected String repositoryName;
    protected String docId;
    protected List<String> docIds;
    protected boolean isTree;
    protected String originatingUsername;
    protected String status;
    protected long schedulingTime;
    protected long startTime;
    protected long completionTime;
    protected transient CoreSession session;
    protected transient NuxeoLoginContext loginContext;
    protected WorkSchedulePath schedulePath;
    protected String callerThread;
    public static final String GLOBAL_DLQ_COUNT_REGISTRY_NAME = MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", "dlq"}).getKey();
    protected byte[] traceContext;

    public AbstractWork() {
        this(System.nanoTime() + "." + (RANDOM.nextInt() & Integer.MAX_VALUE));
    }

    public AbstractWork(String id) {
        this.id = id;
        this.progress = Work.Progress.PROGRESS_INDETERMINATE;
        this.schedulingTime = System.currentTimeMillis();
        this.callerThread = Thread.currentThread().getName();
        this.traceContext = Tracing.getPropagationComponent().getBinaryFormat().toByteArray(Tracing.getTracer().getCurrentSpan().getContext());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public WorkSchedulePath getSchedulePath() {
        return this.schedulePath == null ? WorkSchedulePath.EMPTY : this.schedulePath;
    }

    @Override
    public void setSchedulePath(WorkSchedulePath path) {
        this.schedulePath = path;
    }

    public void setDocument(String repositoryName, String docId, boolean isTree) {
        this.repositoryName = repositoryName;
        this.docId = docId;
        this.docIds = null;
        this.isTree = isTree;
    }

    public void setDocument(String repositoryName, String docId) {
        this.setDocument(repositoryName, docId, false);
    }

    public void setDocuments(String repositoryName, List<String> docIds) {
        this.repositoryName = repositoryName;
        this.docId = null;
        this.docIds = new ArrayList<String>(docIds);
    }

    public void setOriginatingUsername(String originatingUsername) {
        this.originatingUsername = originatingUsername;
    }

    @Override
    public void setWorkInstanceSuspending() {
        this.suspending = true;
    }

    @Override
    public boolean isSuspending() {
        return this.suspending;
    }

    @Override
    public void suspended() {
        this.suspended = true;
    }

    @Override
    public boolean isWorkInstanceSuspended() {
        return this.suspended;
    }

    @Override
    public void setWorkInstanceState(Work.State state) {
        this.state = state;
        if (log.isTraceEnabled()) {
            log.trace((Object)(this + " state=" + state));
        }
    }

    @Override
    public Work.State getWorkInstanceState() {
        return this.state;
    }

    @Override
    public void setProgress(Work.Progress progress) {
        this.progress = progress;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.valueOf(this));
        }
    }

    @Override
    public Work.Progress getProgress() {
        return this.progress;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Deprecated
    public CoreSession initSession() {
        return this.initSession(this.repositoryName);
    }

    public void openSystemSession() {
        this.loginContext = Framework.loginSystem((String)this.originatingUsername);
        this.session = CoreInstance.getCoreSessionSystem((String)this.repositoryName, (String)this.originatingUsername);
    }

    public void openUserSession() {
        if (this.originatingUsername == null) {
            throw new IllegalStateException("Cannot open an user session without an originatingUsername");
        }
        try {
            this.loginContext = Framework.loginUser((String)this.originatingUsername);
        }
        catch (LoginException e) {
            throw new NuxeoException((Throwable)e);
        }
        this.session = CoreInstance.getCoreSession((String)this.repositoryName);
    }

    @Deprecated
    public CoreSession initSession(String repositoryName) {
        this.session = CoreInstance.getCoreSessionSystem((String)repositoryName, (String)this.originatingUsername);
        return this.session;
    }

    public void closeSession() {
        if (this.loginContext != null) {
            this.loginContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            if (this.isSuspending()) {
                this.suspended();
                return;
            }
            Span span = this.getSpanFromContext(this.traceContext);
            try {
                Scope scope = Tracing.getTracer().withSpan(span);
                RuntimeException suppressed = null;
                int retryCount = this.getRetryCount();
                for (int i = 0; i <= retryCount; ++i) {
                    if (i > 0) {
                        span.addAnnotation("AbstractWork#run Retrying " + i);
                        log.debug((Object)("Retrying work due to concurrent update (" + i + "): " + this));
                        log.trace((Object)"Concurrent update", suppressed);
                    }
                    if (ExceptionUtils.hasInterruptedCause(suppressed)) {
                        log.debug((Object)("No need to retry the work with id=" + this.getId() + ", work manager is shutting down"));
                        break;
                    }
                    try {
                        this.runWorkWithTransaction();
                        span.setStatus(Status.OK);
                        return;
                    }
                    catch (RuntimeException e) {
                        span.addAnnotation("AbstractSession#run Failure: " + e.getMessage());
                        span.setStatus(Status.UNKNOWN);
                        if (suppressed == null) {
                            suppressed = e;
                            continue;
                        }
                        suppressed.addSuppressed(e);
                        continue;
                    }
                }
                this.workFailed(suppressed);
                break block18;
                finally {
                    if (scope != null) {
                        scope.close();
                    }
                }
            }
            finally {
                span.end();
            }
        }
    }

    protected Span getSpanFromContext(byte[] traceContext) {
        if (traceContext == null || traceContext.length == 0) {
            return BlankSpan.INSTANCE;
        }
        Tracer tracer = Tracing.getTracer();
        BinaryFormat binaryFormat = Tracing.getPropagationComponent().getBinaryFormat();
        try {
            SpanContext spanContext = binaryFormat.fromByteArray(traceContext);
            Span span = tracer.spanBuilderWithRemoteParent("work/" + this.getClass().getSimpleName(), spanContext).startSpan();
            span.addLink(Link.fromSpanContext((SpanContext)spanContext, (Link.Type)Link.Type.PARENT_LINKED_SPAN));
            HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
            map.put("tx.thread", AttributeValue.stringAttributeValue((String)Thread.currentThread().getName()));
            map.put("work.id", AttributeValue.stringAttributeValue((String)this.getId()));
            map.put("work.category", AttributeValue.stringAttributeValue((String)this.getCategory()));
            map.put("work.title", AttributeValue.stringAttributeValue((String)this.getTitle()));
            map.put("work.parent_path", AttributeValue.stringAttributeValue((String)this.getSchedulePath().getParentPath()));
            map.put("work.caller_thread", AttributeValue.stringAttributeValue((String)this.callerThread));
            map.put("work.to_string", AttributeValue.stringAttributeValue((String)this.toString()));
            if (this.docId != null) {
                map.put("work.doc_id", AttributeValue.stringAttributeValue((String)this.docId));
            }
            if (this.docIds != null && !this.docIds.isEmpty()) {
                map.put("work.doc_count", AttributeValue.longAttributeValue((long)this.docIds.size()));
            }
            span.putAttributes(map);
            return span;
        }
        catch (SpanContextParseException e) {
            log.warn((Object)("No span context " + traceContext.length));
            return BlankSpan.INSTANCE;
        }
    }

    public Map<String, Serializable> buildWorkFailureEventProps(RuntimeException exception) {
        HashMap<String, Serializable> eventProps = new HashMap<String, Serializable>();
        eventProps.put(WORK_INSTANCE, this);
        if (this.session != null) {
            eventProps.put("repositoryName", (Serializable)((Object)this.session.getRepositoryName()));
        }
        if (exception != null) {
            eventProps.put(FAILURE_MSG, (Serializable)((Object)exception.getMessage()));
            eventProps.put(FAILURE_EXCEPTION, (Serializable)((Object)exception.getClass().getName()));
        }
        return eventProps;
    }

    public void workFailed(RuntimeException exception) {
        EventService service = (EventService)Framework.getService(EventService.class);
        EventContextImpl eventContext = new EventContextImpl(null, this.session != null ? this.session.getPrincipal() : null);
        eventContext.setProperties(this.buildWorkFailureEventProps(exception));
        EventImpl event = new EventImpl(WORK_FAILED_EVENT, eventContext);
        event.setIsCommitEvent(true);
        service.fireEvent(event);
        if (exception != null) {
            this.appendWorkToDeadLetterQueue();
            String msg = "Work failed after " + this.getRetryCount() + " " + (this.getRetryCount() == 1 ? "retry" : "retries") + ", class=" + this.getClass() + " id=" + this.getId() + " category=" + this.getCategory() + " title=" + this.getTitle();
            throw new NuxeoException(msg, (Throwable)exception);
        }
    }

    protected void appendWorkToDeadLetterQueue() {
        if (!Work.State.RUNNING.equals((Object)this.getWorkInstanceState())) {
            return;
        }
        try {
            String key = this.getCategory() + ":" + this.getId();
            StreamService service = (StreamService)Framework.getService(StreamService.class);
            if (service != null) {
                service.getLogManager().getAppender(WorkManagerImpl.DEAD_LETTER_QUEUE).append(key, (Externalizable)Record.of((String)key, (byte[])WorkComputation.serialize(this)));
                MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
                registry.counter(GLOBAL_DLQ_COUNT_REGISTRY_NAME).inc();
            }
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)"No default log manager, don't save work in failure to a dead letter queue");
        }
        catch (Exception e) {
            String message = "Failed to save work: " + this.getId() + " in dead letter queue";
            if (ExceptionUtils.hasInterruptedCause((Throwable)e)) {
                log.warn((Object)message, (Throwable)e);
            }
            log.error((Object)message, (Throwable)e);
        }
    }

    private String getTitleOr(String defaultTitle) {
        try {
            return this.getTitle();
        }
        catch (Exception e) {
            return defaultTitle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWorkWithTransaction() {
        TransactionHelper.startTransaction();
        boolean ok = false;
        Exception exc = null;
        try {
            WorkSchedulePath.handleEnter(this);
            this.setStartTime();
            this.work();
            if (this.isGroupJoin() && WorkStateHelper.removeGroupJoinWork(this.getPartitionKey())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Detecting GroupJoin %s completion Work: %s", this.getPartitionKey(), this.getId()));
                }
                this.onGroupJoinCompletion();
            }
            ok = true;
        }
        catch (Exception e) {
            exc = e;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(e);
        }
        finally {
            WorkSchedulePath.handleReturn();
            try {
                this.setCompletionTime();
                this.cleanUp(ok, exc);
            }
            finally {
                if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                    if (!ok || this.isSuspending()) {
                        log.trace((Object)(this + " is suspending, rollbacking"));
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                    TransactionHelper.commitOrRollbackTransaction();
                }
            }
        }
    }

    @Override
    public abstract void work();

    public int getRetryCount() {
        return 0;
    }

    @Override
    public void cleanUp(boolean ok, Exception e) {
        if (!ok) {
            if (ExceptionUtils.hasInterruptedCause((Throwable)e)) {
                log.debug((Object)("Interrupted work: " + this));
            } else if (!(e instanceof ConcurrentUpdateException) && !this.isSuspending()) {
                log.error((Object)("Exception during work: " + this), (Throwable)e);
                if (WorkSchedulePath.isCaptureStackEnabled()) {
                    WorkSchedulePath.log.error((Object)"Work schedule path", (Throwable)this.getSchedulePath().getStack());
                }
            }
        }
        this.closeSession();
    }

    @Override
    public String getOriginatingUsername() {
        return this.originatingUsername;
    }

    @Override
    public long getSchedulingTime() {
        return this.schedulingTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    protected void setCompletionTime() {
        this.completionTime = System.currentTimeMillis();
    }

    @Override
    public String getCategory() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('(');
        if (this.docId != null) {
            sb.append(this.docId);
            sb.append(", ");
        } else if (this.docIds != null && this.docIds.size() > 0) {
            sb.append(this.docIds.get(0));
            sb.append("..., ");
        }
        sb.append(this.getSchedulePath().getParentPath());
        sb.append(", ");
        sb.append(this.getProgress());
        sb.append(", ");
        sb.append(this.getStatus());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public DocumentLocation getDocument() {
        if (this.docId != null) {
            return this.newDocumentLocation(this.docId);
        }
        return null;
    }

    @Override
    public List<DocumentLocation> getDocuments() {
        if (this.docIds != null) {
            ArrayList<DocumentLocation> res = new ArrayList<DocumentLocation>(this.docIds.size());
            for (String docId : this.docIds) {
                res.add(this.newDocumentLocation(docId));
            }
            return res;
        }
        if (this.docId != null) {
            return Collections.singletonList(this.newDocumentLocation(this.docId));
        }
        return Collections.emptyList();
    }

    protected DocumentLocation newDocumentLocation(String docId) {
        return new DocumentLocationImpl(this.repositoryName, (DocumentRef)new IdRef(docId));
    }

    @Override
    public boolean isDocumentTree() {
        return this.isTree;
    }

    public void commitOrRollbackTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
        }
    }

    public boolean startTransaction() {
        return TransactionHelper.startTransaction();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Work)) {
            return false;
        }
        return ((Work)other).getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public String getPartitionKey() {
        if (this.docId != null) {
            return this.docId;
        }
        if (this.docIds != null && !this.docIds.isEmpty()) {
            return this.docIds.get(0);
        }
        return this.getId();
    }

    static {
        SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName()).counter(GLOBAL_DLQ_COUNT_REGISTRY_NAME);
    }
}

