/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.db;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.novemberain.quartz.mongodb.db.MongoConnector;
import java.util.List;
import org.bson.Document;
import org.quartz.SchedulerConfigException;

public class InternalMongoConnector
implements MongoConnector {
    private final WriteConcern writeConcern;
    private final MongoClient mongoClient;
    private final MongoDatabase database;

    private InternalMongoConnector(WriteConcern writeConcern, MongoClient mongoClient, String dbName) {
        this.writeConcern = writeConcern;
        this.mongoClient = mongoClient;
        this.database = mongoClient.getDatabase(dbName);
    }

    public InternalMongoConnector(WriteConcern writeConcern, String uri, String dbName) throws SchedulerConfigException {
        this(writeConcern, uri, dbName, null);
    }

    public InternalMongoConnector(WriteConcern writeConcern, String uri, String dbName, MongoClientOptions.Builder optionBuilder) throws SchedulerConfigException {
        this(writeConcern, InternalMongoConnector.createClient(uri, optionBuilder), dbName);
    }

    public InternalMongoConnector(WriteConcern writeConcern, List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options, String dbName) throws SchedulerConfigException {
        this(writeConcern, InternalMongoConnector.createClient(seeds, credentialsList, options), dbName);
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.database.getCollection(collectionName).withWriteConcern(this.writeConcern);
    }

    @Override
    public void close() {
        this.mongoClient.close();
    }

    private static MongoClient createClient(MongoClientURI uri) throws SchedulerConfigException {
        try {
            return new MongoClient(uri);
        }
        catch (MongoException e) {
            throw new SchedulerConfigException("MongoDB driver thrown an exception.", (Throwable)e);
        }
    }

    private static MongoClient createClient(String uri, MongoClientOptions.Builder optionBuilder) throws SchedulerConfigException {
        MongoClientURI mongoUri;
        try {
            mongoUri = optionBuilder == null ? new MongoClientURI(uri) : new MongoClientURI(uri, optionBuilder);
        }
        catch (MongoException e) {
            throw new SchedulerConfigException("Invalid mongo client uri.", (Throwable)e);
        }
        return InternalMongoConnector.createClient(mongoUri);
    }

    private static MongoClient createClient(List<ServerAddress> seeds, List<MongoCredential> credentialsList, MongoClientOptions options) throws SchedulerConfigException {
        try {
            return new MongoClient(seeds, credentialsList, options);
        }
        catch (MongoException e) {
            throw new SchedulerConfigException("MongoDB driver thrown an exception.", (Throwable)e);
        }
    }
}

