/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.db;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import com.novemberain.quartz.mongodb.db.ExternalMongoConnector;
import com.novemberain.quartz.mongodb.db.InternalMongoConnector;
import com.novemberain.quartz.mongodb.db.MongoConnector;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.quartz.SchedulerConfigException;

public class MongoConnectorBuilder {
    private static final String PARAM_NOT_ALLOWED = "'%s' parameter is not allowed. %s";
    private MongoConnector connector;
    private Integer writeTimeout;
    private MongoDatabase database;
    private MongoClient client;
    private String dbName;
    private String uri;
    private String[] addresses;
    private String username;
    private String password;
    private String authDbName;
    private Integer maxConnectionsPerHost;
    private Integer connectTimeoutMillis;
    private Integer socketTimeoutMillis;
    private Boolean socketKeepAlive;
    private Integer threadsAllowedToBlockForConnectionMultiplier;
    private Boolean enableSSL;
    private Boolean sslInvalidHostNameAllowed;
    private String trustStorePath;
    private String trustStorePassword;
    private String trustStoreType;
    private String keyStorePath;
    private String keyStorePassword;
    private String keyStoreType;

    private MongoConnectorBuilder() {
    }

    public static MongoConnectorBuilder builder() {
        return new MongoConnectorBuilder();
    }

    public MongoConnector build() throws SchedulerConfigException {
        if (this.connector != null) {
            this.validateForConnector();
            return this.connector;
        }
        WriteConcern writeConcern = this.createWriteConcern();
        if (this.database != null) {
            this.validateForDatabase();
            return new ExternalMongoConnector(writeConcern, this.database);
        }
        MongoConnectorBuilder.checkNotNull(this.dbName, "'Database name' parameter is required.");
        if (this.client != null) {
            this.validateForClient();
            return new ExternalMongoConnector(writeConcern, this.client, this.dbName);
        }
        MongoClientOptions.Builder optionsBuilder = this.createOptionBuilder();
        if (this.uri != null) {
            this.validateForUri();
            return new InternalMongoConnector(writeConcern, this.uri, this.dbName, optionsBuilder);
        }
        MongoConnectorBuilder.checkNotNull(this.addresses, "At least one MongoDB address or a MongoDB URI must be specified.");
        List<ServerAddress> serverAddresses = this.collectServerAddresses();
        List<MongoCredential> credentials = this.createCredentials();
        return new InternalMongoConnector(writeConcern, serverAddresses, credentials, optionsBuilder.build(), this.dbName);
    }

    private List<ServerAddress> collectServerAddresses() {
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>(this.addresses.length);
        for (String address : this.addresses) {
            serverAddresses.add(new ServerAddress(address));
        }
        return serverAddresses;
    }

    private List<MongoCredential> createCredentials() {
        if (this.username != null) {
            MongoCredential cred = this.authDbName != null ? MongoCredential.createCredential((String)this.username, (String)this.authDbName, (char[])this.password.toCharArray()) : MongoCredential.createCredential((String)this.username, (String)this.dbName, (char[])this.password.toCharArray());
            return Collections.singletonList(cred);
        }
        return Collections.emptyList();
    }

    private MongoClientOptions.Builder createOptionBuilder() throws SchedulerConfigException {
        SSLContext sslContext;
        MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder();
        if (this.maxConnectionsPerHost != null) {
            optionsBuilder.connectionsPerHost(this.maxConnectionsPerHost.intValue());
        }
        if (this.connectTimeoutMillis != null) {
            optionsBuilder.connectTimeout(this.connectTimeoutMillis.intValue());
        }
        if (this.socketTimeoutMillis != null) {
            optionsBuilder.socketTimeout(this.socketTimeoutMillis.intValue());
        }
        if (this.socketKeepAlive != null) {
            optionsBuilder.socketKeepAlive(this.socketKeepAlive.booleanValue());
        }
        if (this.threadsAllowedToBlockForConnectionMultiplier != null) {
            optionsBuilder.threadsAllowedToBlockForConnectionMultiplier(this.threadsAllowedToBlockForConnectionMultiplier.intValue());
        }
        if ((sslContext = this.getSSLContext()) == null) {
            if (this.enableSSL != null) {
                optionsBuilder.sslEnabled(this.enableSSL.booleanValue());
                if (this.sslInvalidHostNameAllowed != null) {
                    optionsBuilder.sslInvalidHostNameAllowed(this.sslInvalidHostNameAllowed.booleanValue());
                }
            }
        } else {
            optionsBuilder.sslEnabled(true);
            if (this.sslInvalidHostNameAllowed != null) {
                optionsBuilder.sslInvalidHostNameAllowed(this.sslInvalidHostNameAllowed.booleanValue());
            }
            optionsBuilder.sslContext(sslContext);
        }
        return optionsBuilder;
    }

    private SSLContext getSSLContext() throws SchedulerConfigException {
        try {
            KeyStore trustStore = this.loadKeyStore(this.trustStorePath, this.trustStorePassword, this.trustStoreType);
            KeyStore keyStore = this.loadKeyStore(this.keyStorePath, this.keyStorePassword, this.keyStoreType);
            if (trustStore == null && keyStore == null) {
                return null;
            }
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (trustStore != null) {
                sslContextBuilder.loadTrustMaterial(trustStore, null);
            }
            if (keyStore != null) {
                sslContextBuilder.loadKeyMaterial(keyStore, StringUtils.isBlank((CharSequence)this.keyStorePassword) ? null : this.keyStorePassword.toCharArray());
            }
            return sslContextBuilder.build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new SchedulerConfigException("Cannot setup SSL context", (Throwable)e);
        }
    }

    private KeyStore loadKeyStore(String path, String password, String type) throws GeneralSecurityException, IOException {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        KeyStore keyStore = KeyStore.getInstance((String)StringUtils.defaultIfBlank((CharSequence)type, (CharSequence)KeyStore.getDefaultType()));
        char[] passwordChars = StringUtils.isBlank((CharSequence)password) ? null : password.toCharArray();
        try (InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            keyStore.load(is, passwordChars);
        }
        return keyStore;
    }

    private WriteConcern createWriteConcern() throws SchedulerConfigException {
        MongoConnectorBuilder.checkNotNull(this.writeTimeout, "Write timeout is expected.");
        return WriteConcern.MAJORITY.withWTimeout((long)this.writeTimeout.intValue(), TimeUnit.MILLISECONDS).withJournal(Boolean.valueOf(true));
    }

    private void validateForConnector() throws SchedulerConfigException {
        String suffix = "'Connector' parameter is used.";
        MongoConnectorBuilder.checkIsNull(this.database, MongoConnectorBuilder.paramNotAllowed("Database", "'Connector' parameter is used."));
        MongoConnectorBuilder.checkIsNull(this.client, MongoConnectorBuilder.paramNotAllowed("Client", "'Connector' parameter is used."));
        MongoConnectorBuilder.checkIsNull(this.dbName, MongoConnectorBuilder.paramNotAllowed("Database name", "'Connector' parameter is used."));
        MongoConnectorBuilder.checkIsNull(this.uri, MongoConnectorBuilder.paramNotAllowed("URI", "'Connector' parameter is used."));
        this.checkServerPropertiesAreNull("'Connector' parameter is used.");
        this.checkConnectionOptionsAreNull("'Connector' parameter is used.");
    }

    private void validateForDatabase() throws SchedulerConfigException {
        String suffix = "'Database' parameter is used.";
        MongoConnectorBuilder.checkIsNull(this.client, MongoConnectorBuilder.paramNotAllowed("Client", "'Database' parameter is used."));
        MongoConnectorBuilder.checkIsNull(this.dbName, MongoConnectorBuilder.paramNotAllowed("Database name", "'Database' parameter is used."));
        MongoConnectorBuilder.checkIsNull(this.uri, MongoConnectorBuilder.paramNotAllowed("URI", "'Database' parameter is used."));
        this.checkServerPropertiesAreNull("'Database' parameter is used.");
        this.checkConnectionOptionsAreNull("'Database' parameter is used.");
    }

    private void validateForClient() throws SchedulerConfigException {
        String suffix = "'Client' parameter is used.";
        MongoConnectorBuilder.checkIsNull(this.uri, MongoConnectorBuilder.paramNotAllowed("URI", "'Client' parameter is used."));
        this.checkServerPropertiesAreNull("'Client' parameter is used.");
        this.checkConnectionOptionsAreNull("'Client' parameter is used.");
    }

    private void validateForUri() throws SchedulerConfigException {
        this.checkServerPropertiesAreNull("'URI' parameter is used.");
    }

    private static <T> T checkNotNull(T reference, String message) throws SchedulerConfigException {
        if (reference == null) {
            throw new SchedulerConfigException(message);
        }
        return reference;
    }

    private static void checkIsNull(Object reference, String message) throws SchedulerConfigException {
        if (reference != null) {
            throw new SchedulerConfigException(message);
        }
    }

    private void checkServerPropertiesAreNull(String suffix) throws SchedulerConfigException {
        MongoConnectorBuilder.checkIsNull(this.addresses, MongoConnectorBuilder.paramNotAllowed("Addresses array", suffix));
        MongoConnectorBuilder.checkIsNull(this.username, MongoConnectorBuilder.paramNotAllowed("Username", suffix));
        MongoConnectorBuilder.checkIsNull(this.password, MongoConnectorBuilder.paramNotAllowed("Password", suffix));
        MongoConnectorBuilder.checkIsNull(this.authDbName, MongoConnectorBuilder.paramNotAllowed("Auth database name", suffix));
    }

    private void checkConnectionOptionsAreNull(String suffix) throws SchedulerConfigException {
        MongoConnectorBuilder.checkIsNull(this.maxConnectionsPerHost, MongoConnectorBuilder.paramNotAllowed("Max connections per host", suffix));
        MongoConnectorBuilder.checkIsNull(this.connectTimeoutMillis, MongoConnectorBuilder.paramNotAllowed("Connect timeout millis", suffix));
        MongoConnectorBuilder.checkIsNull(this.socketTimeoutMillis, MongoConnectorBuilder.paramNotAllowed("Socket timeout millis", suffix));
        MongoConnectorBuilder.checkIsNull(this.socketKeepAlive, MongoConnectorBuilder.paramNotAllowed("Socket keepAlive", suffix));
        MongoConnectorBuilder.checkIsNull(this.threadsAllowedToBlockForConnectionMultiplier, MongoConnectorBuilder.paramNotAllowed("Threads allowed to block for connection multiplier", suffix));
        MongoConnectorBuilder.checkIsNull(this.enableSSL, MongoConnectorBuilder.paramNotAllowed("Enable ssl", suffix));
        MongoConnectorBuilder.checkIsNull(this.sslInvalidHostNameAllowed, MongoConnectorBuilder.paramNotAllowed("SSL invalid hostname allowed", suffix));
        MongoConnectorBuilder.checkIsNull(this.trustStorePath, MongoConnectorBuilder.paramNotAllowed("TrustStore path", suffix));
        MongoConnectorBuilder.checkIsNull(this.trustStorePassword, MongoConnectorBuilder.paramNotAllowed("TrustStore password", suffix));
        MongoConnectorBuilder.checkIsNull(this.trustStoreType, MongoConnectorBuilder.paramNotAllowed("TrustStore type", suffix));
        MongoConnectorBuilder.checkIsNull(this.keyStorePath, MongoConnectorBuilder.paramNotAllowed("KeyStore path", suffix));
        MongoConnectorBuilder.checkIsNull(this.keyStorePassword, MongoConnectorBuilder.paramNotAllowed("KeyStore password", suffix));
        MongoConnectorBuilder.checkIsNull(this.keyStoreType, MongoConnectorBuilder.paramNotAllowed("KeyStore type", suffix));
    }

    private static String paramNotAllowed(String paramName, String suffix) {
        return String.format(PARAM_NOT_ALLOWED, paramName, suffix);
    }

    public MongoConnectorBuilder withConnector(MongoConnector connector) {
        this.connector = connector;
        return this;
    }

    public MongoConnectorBuilder withWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public MongoConnectorBuilder withDatabase(MongoDatabase database) {
        this.database = database;
        return this;
    }

    public MongoConnectorBuilder withClient(MongoClient client) {
        this.client = client;
        return this;
    }

    public MongoConnectorBuilder withDatabaseName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public MongoConnectorBuilder withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public MongoConnectorBuilder withAddresses(String[] addresses) {
        this.addresses = addresses;
        return this;
    }

    public MongoConnectorBuilder withCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public MongoConnectorBuilder withAuthDatabaseName(String authDbName) {
        this.authDbName = authDbName;
        return this;
    }

    public MongoConnectorBuilder withMaxConnectionsPerHost(Integer maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        return this;
    }

    public MongoConnectorBuilder withConnectTimeoutMillis(Integer connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return this;
    }

    public MongoConnectorBuilder withSocketTimeoutMillis(Integer socketTimeoutMillis) {
        this.socketTimeoutMillis = socketTimeoutMillis;
        return this;
    }

    public MongoConnectorBuilder withSocketKeepAlive(Boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
        return this;
    }

    public MongoConnectorBuilder withThreadsAllowedToBlockForConnectionMultiplier(Integer threadsAllowedToBlockForConnectionMultiplier) {
        this.threadsAllowedToBlockForConnectionMultiplier = threadsAllowedToBlockForConnectionMultiplier;
        return this;
    }

    public MongoConnectorBuilder withSSL(Boolean enableSSL, Boolean sslInvalidHostNameAllowed) {
        this.enableSSL = enableSSL;
        this.sslInvalidHostNameAllowed = sslInvalidHostNameAllowed;
        return this;
    }

    public MongoConnectorBuilder withTrustStore(String trustStorePath, String trustStorePassword, String trustStoreType) {
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        return this;
    }

    public MongoConnectorBuilder withKeyStore(String keyStorePath, String keyStorePassword, String keyStoreType) {
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        return this;
    }
}

