/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.document;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.OutputStreamWithJsonWriter;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentPropertyJsonWriter;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.MaxDepthReachedException;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DocumentModelJsonWriter
extends ExtensibleEntityJsonWriter<DocumentModel> {
    public static final String ENTITY_TYPE = "document";
    public static final String DOCUMENT_JSON_FETCH_HEAVY_KEY = "nuxeo.document.json.fetch.heavy";
    protected static Boolean FETCH_HEAVY_VALUES = null;
    @Inject
    protected SchemaManager schemaManager;

    protected static boolean fetchHeavy() {
        if (FETCH_HEAVY_VALUES == null) {
            try {
                FETCH_HEAVY_VALUES = Framework.isBooleanPropertyTrue((String)DOCUMENT_JSON_FETCH_HEAVY_KEY);
            }
            catch (Exception e) {
                FETCH_HEAVY_VALUES = false;
            }
        }
        return FETCH_HEAVY_VALUES;
    }

    protected boolean mustFetch(String name) {
        return this.ctx.getFetched(ENTITY_TYPE).contains(name) || DocumentModelJsonWriter.fetchHeavy();
    }

    public DocumentModelJsonWriter() {
        super(ENTITY_TYPE, DocumentModel.class);
    }

    @Override
    protected void writeEntityBody(DocumentModel doc, JsonGenerator jg) throws IOException {
        Object schema;
        String[] docSchemas;
        block20: {
            Calendar cal;
            Lock lock;
            jg.writeStringField("repository", doc.getRepositoryName());
            jg.writeStringField("uid", doc.getId());
            jg.writeStringField("path", doc.getPathAsString());
            jg.writeStringField("type", doc.getType());
            jg.writeStringField("state", doc.getRef() != null ? doc.getCurrentLifeCycleState() : null);
            jg.writeStringField("parentRef", doc.getParentRef() != null ? doc.getParentRef().toString() : null);
            jg.writeBooleanField("isCheckedOut", doc.isCheckedOut());
            jg.writeBooleanField("isRecord", doc.isRecord());
            Calendar retainUntil = doc.getRetainUntil();
            jg.writeStringField("retainUntil", retainUntil == null ? null : DateUtils.formatISODateTime((Calendar)retainUntil));
            jg.writeBooleanField("hasLegalHold", doc.hasLegalHold());
            jg.writeBooleanField("isUnderRetentionOrLegalHold", doc.isUnderRetentionOrLegalHold());
            boolean isVersion = doc.isVersion();
            jg.writeBooleanField("isVersion", isVersion);
            boolean isProxy = doc.isProxy();
            jg.writeBooleanField("isProxy", isProxy);
            if (isProxy) {
                jg.writeStringField("proxyTargetId", doc.getSourceId());
            }
            if (isVersion || isProxy) {
                jg.writeStringField("versionableId", doc.getVersionSeriesId());
            }
            jg.writeStringField("changeToken", doc.getChangeToken());
            jg.writeBooleanField("isTrashed", doc.getRef() != null && doc.isTrashed());
            jg.writeStringField("title", doc.getTitle());
            if (this.mustFetch("versionLabel")) {
                String versionLabel = doc.getVersionLabel();
                jg.writeStringField("versionLabel", versionLabel != null ? versionLabel : "");
            }
            if (this.mustFetch("lock") && (lock = doc.getLockInfo()) != null) {
                jg.writeStringField("lockOwner", lock.getOwner());
                jg.writeStringField("lockCreated", DateUtils.formatISODateTime((Calendar)DateUtils.nowIfNull((Calendar)lock.getCreated())));
            }
            if (doc.hasSchema("dublincore") && (cal = (Calendar)doc.getPropertyValue("dc:modified")) != null) {
                jg.writeStringField("lastModified", DateParser.formatW3CDateTime((Date)cal.getTime()));
            }
            docSchemas = doc.getSchemas();
            try (Closeable resource2 = this.ctx.wrap().controlDepth().open();){
                Set<String> schemas = this.ctx.getProperties();
                if (schemas.size() <= 0) break block20;
                jg.writeObjectFieldStart("properties");
                if (schemas.contains("*")) {
                    String[] stringArray = docSchemas;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        schema = stringArray[i];
                        this.writeSchemaProperties(jg, doc, (String)schema);
                    }
                } else {
                    for (String schema2 : schemas) {
                        if (!doc.hasSchema(schema2)) continue;
                        this.writeSchemaProperties(jg, doc, schema2);
                    }
                }
                jg.writeEndObject();
            }
            catch (MaxDepthReachedException resource2) {
                // empty catch block
            }
        }
        jg.writeArrayFieldStart("facets");
        for (String facet : doc.getFacets()) {
            jg.writeString(facet);
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("schemas");
        if (docSchemas.length > 0) {
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            for (String schemaName : docSchemas) {
                schema = schemaManager.getSchema(schemaName);
                if (schema == null) continue;
                jg.writeStartObject();
                String name = schema.getName();
                String prefix = schema.getNamespace().prefix;
                jg.writeStringField("name", name);
                jg.writeStringField("prefix", StringUtils.isEmpty((CharSequence)prefix) ? name : prefix);
                jg.writeEndObject();
            }
        }
        jg.writeEndArray();
    }

    protected void writeSchemaProperties(JsonGenerator jg, DocumentModel doc, String schemaName) throws IOException {
        Writer<Property> propertyWriter = this.registry.getWriter(this.ctx, Property.class, MediaType.APPLICATION_JSON_TYPE);
        try (Closeable resource = this.ctx.wrap().with(ENTITY_TYPE, doc).open();){
            Schema schema = this.schemaManager.getSchema(schemaName);
            Object prefix = schema.getNamespace().prefix;
            if (prefix == null || ((String)prefix).length() == 0) {
                prefix = schemaName;
            }
            prefix = (String)prefix + ":";
            for (Field field : schema.getFields()) {
                String prefixedName = (String)prefix + field.getName().getLocalName();
                Property property = doc.getProperty(prefixedName);
                if (DocumentPropertyJsonWriter.skipProperty(this.ctx, property)) continue;
                jg.writeFieldName(prefixedName);
                OutputStreamWithJsonWriter out = new OutputStreamWithJsonWriter(jg);
                propertyWriter.write(property, Property.class, (Type)((Object)Property.class), MediaType.APPLICATION_JSON_TYPE, out);
            }
        }
    }
}

