/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.internal.ClassLogger;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

abstract class HtmlPage {
    protected StringBuffer htmlPage = new StringBuffer();
    protected MBeanServer mbs = null;
    protected boolean readPerm = false;
    protected boolean writePerm = false;
    private String bgColor = null;
    final ClassLogger logger;

    public HtmlPage(MBeanServer f, boolean r, boolean w) {
        this.mbs = f;
        this.readPerm = r;
        this.writePerm = w;
        this.logger = new ClassLogger("com.sun.jdmk.html.adaptor", this.getClass());
    }

    public String getPage() {
        return this.htmlPage.toString();
    }

    public void setBgColor(String value) {
        this.bgColor = value != null && !value.equals("") ? (value.startsWith("#") ? "BGCOLOR=\"" + value + "\"" : (value.endsWith("gif") ? "BACKGROUND=\"" + value + "\"" : value)) : null;
    }

    public abstract void buildPage(String var1);

    protected void add2Page(String s) {
        this.htmlPage.append(String.valueOf(s) + "\r\n");
    }

    protected void buildError(String errorStr, String errorDef) {
        this.htmlPage = new StringBuffer();
        this.htmlPage.append(this.buildHead(errorDef));
        this.htmlPage.append(this.startBody(null));
        this.htmlPage.append("<HR><P>\r\n<FONT SIZE=+3 COLOR=red><B>" + errorDef + "</B></FONT><P><HR><P>" + errorStr + "\r\n");
        this.htmlPage.append("<P><TABLE WIDTH=100%><TR>");
        this.htmlPage.append("<TD ALIGN=RIGHT><A HREF=\"/\">Back to Agent View</A></TD>");
        this.htmlPage.append("</TR></TABLE>");
        this.htmlPage.append(this.stopBody());
    }

    protected String buildHead(String title) {
        StringBuffer header = new StringBuffer(80);
        header.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\r\n");
        header.append("<HTML>\r\n");
        header.append("<HEAD>\r\n");
        header.append("<TITLE>" + title + "</TITLE>" + "\r\n");
        header.append("</HEAD>\r\n");
        return header.toString();
    }

    protected String buildHeadMeta(String title, String meta) {
        StringBuffer header = new StringBuffer(80);
        header.append("<HTML>\r\n");
        header.append("<HEAD>\r\n");
        header.append("<TITLE>" + title + "</TITLE>" + "\r\n");
        header.append(meta);
        header.append("</HEAD>\r\n");
        return header.toString();
    }

    protected String startBody(String otherOption) {
        StringBuffer body = new StringBuffer();
        body.append("<BODY");
        if (this.bgColor != null) {
            body.append(" " + this.bgColor + " ");
        }
        if (otherOption != null) {
            body.append(" " + otherOption + " ");
        }
        body.append(">\r\n");
        return body.toString();
    }

    protected String stopBody() {
        return "</BODY>\r\n</HTML>\r\n";
    }

    protected String encodeUrl(String string) {
        byte[] bytes = null;
        try {
            bytes = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            bytes = string.getBytes();
        }
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        int i = 0;
        while (i < len) {
            byte b = bytes[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
            } else if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                encoded[n++] = b;
            } else {
                noEncode = false;
                encoded[n++] = 37;
                byte nibble = (byte)((b & 0xF0) >> 4);
                encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
                nibble = (byte)(b & 0xF);
                encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            }
            ++i;
        }
        if (noEncode) {
            return string;
        }
        try {
            return new String(encoded, 0, n, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return new String(encoded, 0, n);
        }
    }

    protected String decodeUrl(String encoded) {
        int len = encoded.length();
        char[] characters = encoded.toCharArray();
        byte[] bytes = new byte[len];
        int n = 0;
        boolean noDecode = true;
        int i = 0;
        while (i < len) {
            char c = characters[i];
            if (c < '\u0000' || c > '\u007f') {
                throw new IllegalArgumentException("Not encoded");
            }
            int b = 0x7F & c;
            if (c == '+') {
                noDecode = false;
                b = 32;
            } else if (c == '%' && i + 2 < len) {
                noDecode = false;
                b = (byte)(0xFF & Integer.parseInt(encoded.substring(i + 1, i + 3), 16));
                i += 2;
            }
            bytes[n++] = b;
            ++i;
        }
        if (noDecode) {
            return encoded;
        }
        try {
            return new String(bytes, 0, n, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes, 0, n);
        }
    }

    protected String toUrlName(String name) {
        return "//" + this.encodeUrl(name);
    }

    protected String fromUrlName(String name) {
        int pos = name.indexOf("/");
        if (pos < 0) {
            return name;
        }
        int next = name.indexOf("/", pos + 1);
        if (next < 0) {
            return name;
        }
        name = name.substring(next + 1);
        return this.decodeUrl(name);
    }

    protected boolean isArrayType(String str) {
        if (str == null) {
            return false;
        }
        return str.endsWith("[]");
    }

    protected String usualType(String str) {
        int lastStep;
        String postFix = "";
        if (str == null) {
            return null;
        }
        if (str.startsWith("[Z")) {
            str = "boolean[]";
        }
        if (str.startsWith("[C")) {
            str = "char[]";
        }
        if (str.startsWith("[D")) {
            str = "double[]";
        }
        if (str.startsWith("[F")) {
            str = "float[]";
        }
        if (str.startsWith("[I")) {
            str = "int[]";
        }
        if (str.startsWith("[S")) {
            str = "short[]";
        }
        if (str.startsWith("[J")) {
            str = "long[]";
        }
        if (str.startsWith("[B")) {
            str = "byte[]";
        }
        if (str.startsWith("[L")) {
            postFix = "[]";
            str = str.substring(2, str.length() - 1);
        }
        if ((lastStep = str.lastIndexOf(46)) == -1) {
            return String.valueOf(str) + postFix;
        }
        return String.valueOf(str) + postFix;
    }

    protected String translateNameToHtmlFormat(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] htmlChars = name.toCharArray();
        StringBuffer encodedHtml = new StringBuffer();
        int i = 0;
        while (i < htmlChars.length) {
            switch (htmlChars[i]) {
                case '<': {
                    encodedHtml.append("&lt;");
                    break;
                }
                case '>': {
                    encodedHtml.append("&gt;");
                    break;
                }
                case '&': {
                    encodedHtml.append("&amp;");
                    break;
                }
                case '\'': {
                    encodedHtml.append("&#39;");
                    break;
                }
                case '\"': {
                    encodedHtml.append("&quot;");
                    break;
                }
                case '\\': {
                    encodedHtml.append("&#92;");
                    break;
                }
                case '\u0085': {
                    encodedHtml.append("&#133;");
                    break;
                }
                default: {
                    encodedHtml.append(htmlChars[i]);
                }
            }
            ++i;
        }
        return encodedHtml.toString();
    }

    protected String boolToHtml(String propertyName, String propertyType, String propertyView, boolean rw) {
        StringBuffer html = new StringBuffer("<INPUT TYPE=RADIO NAME=\"");
        html.append(String.valueOf(propertyName) + "+" + propertyType + "\" ");
        if (propertyView != null && propertyView.equals("true") && rw) {
            html.append("CHECKED ");
        }
        html.append("VALUE=\"true\">True ");
        html.append("<INPUT TYPE=RADIO NAME=\"");
        html.append(String.valueOf(propertyName) + "+" + propertyType + "\" ");
        if (propertyView != null && propertyView.equals("false") && rw) {
            html.append("CHECKED ");
        }
        html.append("VALUE=\"false\">False ");
        return html.toString();
    }

    protected ObjectName getObjectNameByObjNameStr(String objNameStr) throws MalformedObjectNameException {
        ObjectName manipulatedObjName = new ObjectName(objNameStr);
        Set<ObjectName> list = this.mbs.queryNames(manipulatedObjName, null);
        if (list.size() <= 0) {
            this.buildError("Unable to get MBean [" + objNameStr + "]", "459 Instance Not Found");
            return null;
        }
        return (ObjectName)list.toArray()[0];
    }

    protected boolean checkType(String typeStr) {
        if (typeStr == null) {
            return false;
        }
        String listStr = new String("String String[] Integer Integer[] int int[] Double Double[] double double[] Float Float[] float float[] Short Short[] short Character Character[] char char[] Boolean Boolean[] boolean boolean[] javax.management.ObjectName javax.management.ObjectName[] Date Date[] Byte byte Long long Byte[] Long[] Number");
        int index = 0;
        boolean done = false;
        while (!done) {
            String eltStr;
            index = listStr.indexOf(32);
            if (index < 0) {
                eltStr = listStr;
                done = true;
            } else {
                eltStr = listStr.substring(0, index);
                listStr = listStr.substring(index + 1);
            }
            if (!typeStr.equals(eltStr) && !typeStr.endsWith(eltStr)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void quicksort(String[] v, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = hi0;
            if (hi0 <= lo0) break block5;
            mid = v[(lo0 + hi0) / 2];
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < hi0 && this.lt(v[lo], mid)) continue block0;
                    while (hi > lo0 && this.lt(mid, v[hi])) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    this.inverseS(v, lo, hi);
                    ++lo;
                    --hi;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
            if (lo0 < hi) {
                this.quicksort(v, lo0, hi);
            }
            if (lo < hi0) {
                this.quicksort(v, lo, hi0);
            }
        }
    }

    protected boolean lt(String a, String b) {
        if (a == null) {
            return false;
        }
        if (b == null) {
            return true;
        }
        return a.compareTo(b) < 0;
    }

    protected void inverseS(String[] a, int lo, int hi) {
        String T = a[lo];
        a[lo] = a[hi];
        a[hi] = T;
    }
}

