/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.AuthInfo;
import com.sun.jdmk.comm.GenericHttpConnectorAddress;
import com.sun.jdmk.internal.ClassLogger;
import java.net.InetAddress;

public class HttpConnectorAddress
implements GenericHttpConnectorAddress {
    private static final long serialVersionUID = -7616189103058186512L;
    private String connType = "SUN HTTP";
    private String host = "localhost";
    private int port = 8081;
    private AuthInfo authInfo = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.comm.legacy.connector.http", "HttpConnectorAddress");

    public HttpConnectorAddress() {
        if (System.getProperty("jdmk.hostname") != null) {
            this.host = System.getProperty("jdmk.hostname");
        } else {
            try {
                this.host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.host = "localhost";
            }
        }
        if (logger.finerOn()) {
            logger.finer("HttpConnectorAddress", "host=" + this.host);
        }
    }

    public HttpConnectorAddress(String host, int port) {
        this.port = port;
        if (host != null) {
            this.host = host;
        } else {
            try {
                this.host = System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.host = "localhost";
            }
        }
        if (logger.finerOn()) {
            logger.finer("HttpConnectorAddress", "host=" + this.host);
        }
    }

    public HttpConnectorAddress(String host, int port, AuthInfo authInfo) {
        this.port = port;
        this.authInfo = authInfo;
        if (host != null) {
            this.host = host;
        } else {
            try {
                this.host = System.getProperty("jdmk.hostname") != null ? System.getProperty("jdmk.hostname") : InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.host = "localhost";
            }
        }
        if (logger.finerOn()) {
            logger.finer("HttpConnectorAddress", "host=" + this.host);
        }
    }

    @Override
    public String getConnectorType() {
        return this.connType;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public AuthInfo getAuthInfo() {
        return this.authInfo;
    }

    @Override
    public void setAuthInfo(AuthInfo authInfo) {
        this.authInfo = authInfo;
    }

    @Override
    public Object clone() {
        Object newHttpConnectorAddress = null;
        try {
            newHttpConnectorAddress = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newHttpConnectorAddress;
    }
}

