/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.discovery;

import com.sun.jdmk.discovery.DiscoveryCommon;
import com.sun.jdmk.discovery.DiscoveryMsg;
import com.sun.jdmk.discovery.DiscoveryPDU;
import com.sun.jdmk.discovery.DiscoveryResponse;
import com.sun.jdmk.discovery.ResponsePDU;
import com.sun.jdmk.internal.ClassLogger;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.InvalidClassException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Date;
import java.util.Vector;
import javax.management.remote.JMXServiceURL;

class ActualDiscovery
extends DiscoveryCommon {
    private boolean PointToPointResponse = true;
    private int RETURN_PORT_MIN_VAL = 1024;
    private int RETURN_PORT_MAX_VAL = this.RETURN_PORT_MIN_VAL * 10;
    private int ttl = 1;
    private int defaultTtl = 1;
    private int timeOut = 1000;
    private String timeStamp = null;
    public Vector returnValue = new Vector();
    private final ClassLogger logger = new ClassLogger("com.sun.jdmk.discovery", "ActualDiscovery");

    public ActualDiscovery(String multicastGroup, int multicastPort) throws IOException {
        super(multicastGroup, multicastPort);
        this.localClassName = "com.sun.jdmk.discovery.ActualDiscovery";
        if (this.logger.finerOn()) {
            this.logger.finer("constructor", "group = " + multicastGroup + ", " + "port  = " + multicastPort);
        }
    }

    public void setTimeOut(int timeOut) throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("setTimeOut", "set to " + timeOut);
        }
        this.setSoTimeout(timeOut);
        this.timeOut = timeOut;
    }

    public int getTimeOut() {
        if (this.logger.finerOn()) {
            this.logger.finer("getTimeOut", "Value = " + this.timeOut);
        }
        return this.timeOut;
    }

    @Override
    public void setTimeToLive(int ttl) throws IOException {
        try {
            super.setTimeToLive(ttl);
        }
        catch (IOException e) {
            if (this.logger.finestOn()) {
                this.logger.finest("setTimeToLive", "Unable to set Time-to-live to " + ttl);
            }
            throw e;
        }
        if (this.logger.finerOn()) {
            this.logger.finer("Time-to-live", "Set Time-to-live to " + ttl);
        }
        this.ttl = ttl;
    }

    @Override
    public int getTimeToLive() {
        return this.ttl;
    }

    public boolean getPointToPointResponse() {
        return this.PointToPointResponse;
    }

    public void setPointToPointResponse(boolean PointToPointResponse) {
        if (this.logger.finerOn()) {
            this.logger.finer("setPointToPointResponse", "setPointToPointResponse to " + PointToPointResponse);
        }
        this.PointToPointResponse = PointToPointResponse;
    }

    public Vector findCommunicators(boolean adp, String selectedHost) throws IOException {
        return this.getObject(adp, selectedHost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getObject(boolean objectRequired, String selectedHost) throws IOException {
        Thread rcvThread;
        ReceivedMsgObj rcvMsg;
        block23: {
            InetAddress returnAddr;
            this.returnValue = new Vector();
            DatagramSocket socket = null;
            int returnPort = this.RETURN_PORT_MIN_VAL;
            String localHostName = null;
            if (!this.getInterface().getHostAddress().equals("0.0.0.0")) {
                returnAddr = this.getInterface();
                localHostName = returnAddr.getHostAddress();
            } else {
                returnAddr = this.getLocalHostAddr();
                localHostName = this.getLocalHostName();
            }
            if (this.logger.finerOn()) {
                this.logger.finer("getObject", " returnAddr is set to " + returnAddr);
            }
            if (this.getPointToPointResponse()) {
                if (this.logger.finerOn()) {
                    this.logger.finer("getObject", "Create datagram socket for response");
                }
                while (returnPort < this.RETURN_PORT_MAX_VAL) {
                    try {
                        socket = new DatagramSocket(returnPort, returnAddr);
                        socket.setSoTimeout(this.getTimeOut());
                        break;
                    }
                    catch (BindException e) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("getObject", " try port " + returnPort);
                        }
                        ++returnPort;
                    }
                }
                if (returnPort == this.RETURN_PORT_MAX_VAL) {
                    throw new IOException("Address already in use");
                }
            } else {
                if (this.logger.finerOn()) {
                    this.logger.finer("getObject", "Use multicast socket for response");
                }
                socket = this;
            }
            if (this.logger.finerOn()) {
                this.logger.finer("getObject", "Format msg");
            }
            DiscoveryPDU pdu = new DiscoveryPDU();
            this.formatPdu(pdu, objectRequired, selectedHost, returnPort, returnAddr, localHostName);
            if (this.logger.finerOn()) {
                this.logger.finer("getObject", "Create a thread to get responses");
            }
            rcvMsg = new ReceivedMsgObj(socket, this);
            rcvThread = new Thread(rcvMsg);
            if (this.logger.finerOn()) {
                this.logger.finer("getObject", "Send the multicast query");
            }
            this.sendMsg(pdu, this.multicastGroup, this.multicastPort);
            rcvThread.start();
            if (this.logger.finerOn()) {
                this.logger.finer("getObject", "Sleep before receiving");
            }
            try {
                Thread.sleep(this.getTimeOut());
            }
            catch (InterruptedException e) {
                if (!this.logger.finestOn()) break block23;
                this.logger.finest("getObject", e);
            }
        }
        if (this.logger.finerOn()) {
            this.logger.finer("getObject", "Stop receiving");
        }
        rcvMsg.stopRequested = true;
        Boolean bl = rcvMsg.interrupted;
        synchronized (bl) {
            if (!rcvMsg.interrupted.booleanValue()) {
                rcvThread.interrupt();
            }
        }
        return this.returnValue;
    }

    private void formatPdu(DiscoveryPDU pdu, boolean objectRequired, String selectedHost, int responsePort, InetAddress returnAddr, String localHostName) {
        String stamp = new Long(new Date().getTime()).toString();
        this.timeStamp = String.valueOf(localHostName) + ":" + stamp;
        pdu.setTimeStamp(String.valueOf(localHostName) + ":" + stamp);
        pdu.setEmittedGroup(this.multicastGroup);
        if (this.getPointToPointResponse()) {
            if (this.logger.finerOn()) {
                this.logger.finer("formatPdu", "set return addr to " + returnAddr + ":" + responsePort);
            }
            pdu.setReturnaddr(returnAddr, responsePort);
        }
        pdu.setHost(selectedHost);
        pdu.setTimeOut(this.getTimeOut());
        pdu.setTimeToLive(this.getTimeToLive());
        pdu.setObjectRequired(objectRequired);
    }

    class ReceivedMsgObj
    implements Runnable {
        public Vector result = new Vector();
        public volatile boolean stopRequested = false;
        public Boolean interrupted = new Boolean(false);
        private ActualDiscovery discovery;
        private DatagramSocket socket;

        ReceivedMsgObj(DatagramSocket socket, ActualDiscovery discovery) {
            this.socket = socket;
            this.discovery = discovery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int nbRsp = 0;
            try {
                while (!this.stopRequested) {
                    try {
                        DiscoveryMsg revMsg = ActualDiscovery.this.receiveMsg(this.socket);
                        if (revMsg == null) {
                            if (!ActualDiscovery.this.logger.finerOn()) continue;
                            ActualDiscovery.this.logger.finer("receivedMsg", "Null msg - continue - ");
                            continue;
                        }
                        ResponsePDU pdu = (ResponsePDU)revMsg;
                        if (this.discovery.timeStamp.compareTo(pdu.getTimeStamp()) != 0) {
                            if (!ActualDiscovery.this.logger.finerOn()) continue;
                            ActualDiscovery.this.logger.finer("receivedMsg", "Msg is not for us : local timeStamp = " + this.discovery.timeStamp + " ; received timeStamp =  " + pdu.getTimeStamp());
                            continue;
                        }
                        DiscoveryResponse translatedPDU = this.TranslatePDU(pdu);
                        this.discovery.returnValue.addElement(translatedPDU);
                        ++nbRsp;
                    }
                    catch (InterruptedIOException e) {
                        this.stopRequested = true;
                        if (!ActualDiscovery.this.logger.finerOn()) continue;
                        ActualDiscovery.this.logger.finer("receivedMsg", "timeOut expiration");
                        ActualDiscovery.this.logger.finer("receivedMsg", "Got " + nbRsp + " responses");
                    }
                    catch (InvalidClassException e) {
                        if (!ActualDiscovery.this.logger.finestOn()) continue;
                        ActualDiscovery.this.logger.finest("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.logger.finest("receivedMsg", e);
                    }
                    catch (ClassCastException e) {
                        if (!ActualDiscovery.this.logger.finestOn()) continue;
                        ActualDiscovery.this.logger.finest("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.logger.finest("receivedMsg", e);
                    }
                    catch (ClassNotFoundException e) {
                        if (!ActualDiscovery.this.logger.finestOn()) continue;
                        ActualDiscovery.this.logger.finest("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.logger.finest("receivedMsg", e);
                    }
                    catch (IOException e) {
                        if (!ActualDiscovery.this.logger.finestOn()) continue;
                        ActualDiscovery.this.logger.finest("receivedMsg", "Not a response msg - continue ");
                        ActualDiscovery.this.logger.finest("receivedMsg", e);
                    }
                }
            }
            catch (Throwable throwable) {
                Boolean bl = this.interrupted;
                synchronized (bl) {
                    this.interrupted = new Boolean(true);
                    Thread.currentThread();
                    Thread.interrupted();
                }
                if (ActualDiscovery.this.logger.finerOn()) {
                    ActualDiscovery.this.logger.finer("receivedMsg", "timeOut expiration");
                    ActualDiscovery.this.logger.finer("receivedMsg", "Got " + nbRsp + " responses");
                }
                if (this.discovery.getPointToPointResponse()) {
                    if (ActualDiscovery.this.logger.finerOn()) {
                        ActualDiscovery.this.logger.finer("receivedMsg", "Close datagram socket");
                    }
                    this.socket.close();
                }
                throw throwable;
            }
            Boolean bl = this.interrupted;
            synchronized (bl) {
                this.interrupted = new Boolean(true);
                Thread.currentThread();
                Thread.interrupted();
            }
            if (ActualDiscovery.this.logger.finerOn()) {
                ActualDiscovery.this.logger.finer("receivedMsg", "timeOut expiration");
                ActualDiscovery.this.logger.finer("receivedMsg", "Got " + nbRsp + " responses");
            }
            if (this.discovery.getPointToPointResponse()) {
                if (ActualDiscovery.this.logger.finerOn()) {
                    ActualDiscovery.this.logger.finer("receivedMsg", "Close datagram socket");
                }
                this.socket.close();
            }
        }

        private DiscoveryResponse TranslatePDU(ResponsePDU pdu) {
            DiscoveryResponse result = new DiscoveryResponse();
            result.host = pdu.getHost();
            result.mbeanServerId = pdu.getMbeanServerId();
            result.specificationName = pdu.getSpecificationName();
            result.specificationVendor = pdu.getSpecificationVendor();
            result.specificationVersion = pdu.getSpecificationVersion();
            result.implementationName = pdu.getImplementationName();
            result.implementationVendor = pdu.getImplementationVendor();
            result.implementationVersion = pdu.getImplementationVersion();
            result.userData = pdu.getUserData();
            result.objectList = pdu.getObjectList();
            result.serverAddresses = pdu.serverAddresses != null ? pdu.serverAddresses : new JMXServiceURL[0];
            return result;
        }
    }
}

