/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import java.util.Collection;
import java.util.function.Consumer;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.core.AggregateDescriptor;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;

public class NativeEsAggregate
extends AggregateEsBase<Aggregation, Bucket> {
    protected final AggregationBuilder nativeAggregation;
    protected final Consumer<Aggregation> parser;

    public NativeEsAggregate(AggregateDefinition definition, AggregationBuilder nativeAggregation, Consumer<Aggregation> parser) {
        super(definition, null);
        this.nativeAggregation = nativeAggregation;
        this.parser = parser;
    }

    public NativeEsAggregate(AggregationBuilder nativeAggregation, Consumer<Aggregation> parser) {
        this(NativeEsAggregate.makeDefinition(nativeAggregation), nativeAggregation, parser);
    }

    protected static AggregateDefinition makeDefinition(AggregationBuilder nativeAggregation) {
        AggregateDescriptor descriptor = new AggregateDescriptor();
        descriptor.setId(nativeAggregation.getName());
        return descriptor;
    }

    @Override
    public AggregationBuilder getEsAggregate() {
        return this.nativeAggregation;
    }

    @Override
    public QueryBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        return QueryBuilders.termsQuery((String)this.getField(), (Collection)this.getSelection());
    }

    @Override
    public void parseAggregation(Aggregation aggregation) {
        this.parser.accept(aggregation);
    }

    public String toString() {
        return this.nativeAggregation.toString();
    }
}

