/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.bulk;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.bulk.message.DataBucket;
import org.nuxeo.elasticsearch.Timestamp;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;

public class IndexRequestComputation
extends AbstractBulkComputation {
    private static final Log log = LogFactory.getLog(IndexRequestComputation.class);
    protected static final long MAX_RECORD_SIZE = 900000L;
    protected static final String INDEX_OPTION = "indexName";
    protected BulkRequest bulkRequest;
    protected List<BulkRequest> bulkRequests = new ArrayList<BulkRequest>();
    protected String bucketKey;

    public IndexRequestComputation() {
        super("bulk/index", 1);
    }

    public void startBucket(String bucketKey) {
        this.bucketKey = bucketKey;
        this.bulkRequests.clear();
        this.bulkRequest = new BulkRequest();
    }

    protected void compute(CoreSession session, List<String> documentIds, Map<String, Serializable> properties) {
        long now = Timestamp.currentTimeMicros();
        String indexName = this.getIndexName(session, properties);
        DocumentModelList docs = this.loadDocuments(session, documentIds);
        ElasticSearchIndexing esi = (ElasticSearchIndexing)Framework.getService(ElasticSearchIndexing.class);
        for (DocumentModel doc : docs) {
            try {
                this.append(new IndexRequest(indexName, "doc", doc.getId()).source(esi.source(doc), XContentType.JSON).versionType(VersionType.EXTERNAL).version(now));
            }
            catch (IOException e) {
                throw new NuxeoException("Cannot build source for document: " + doc.getId(), (Throwable)e);
            }
        }
    }

    protected void append(IndexRequest indexRequest) {
        if (this.bulkRequest.estimatedSizeInBytes() + (long)indexRequest.source().length() > 900000L) {
            if (this.bulkRequest.numberOfActions() > 0) {
                this.bulkRequests.add(this.bulkRequest);
                this.bulkRequest = new BulkRequest();
            }
            if ((long)indexRequest.source().length() > 900000L) {
                log.warn((Object)String.format("Indexing request for doc: %s, is too large: %d, max record size: %d", indexRequest.id(), indexRequest.source().length(), 900000L));
            }
        }
        this.bulkRequest.add(indexRequest);
    }

    public void endBucket(ComputationContext context, BulkStatus delta) {
        long bucketSize = delta.getProcessed();
        this.bulkRequests.add(this.bulkRequest);
        String commandId = this.getCurrentCommand().getId();
        int i = 0;
        int count = 0;
        for (BulkRequest request : this.bulkRequests) {
            DataBucket dataBucket = new DataBucket(commandId, (long)request.numberOfActions(), this.toBytes(request));
            String key = this.bucketKey + "-" + i++;
            context.produceRecord("o1", Record.of((String)key, (byte[])BulkCodecs.getDataBucketCodec().encode((Object)dataBucket)));
            count += request.numberOfActions();
        }
        if ((long)count < bucketSize) {
            log.warn((Object)String.format("Command: %s offset: %s created %d documents out of %d, %d not accessible", commandId, context.getLastOffset(), count, bucketSize, bucketSize - (long)count));
            DataBucket dataBucket = new DataBucket(commandId, bucketSize - (long)count, this.toBytes(new BulkRequest()));
            context.produceRecord("o1", Record.of((String)(this.bucketKey + "-missing"), (byte[])BulkCodecs.getDataBucketCodec().encode((Object)dataBucket)));
        }
        this.bulkRequest = null;
        this.bulkRequests.clear();
    }

    protected String getIndexName(CoreSession session, Map<String, Serializable> properties) {
        if (properties.containsKey(INDEX_OPTION)) {
            return (String)((Object)properties.get(INDEX_OPTION));
        }
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        return esa.getWriteIndexName(esa.getIndexNameForRepository(session.getRepositoryName()));
    }

    protected byte[] toBytes(BulkRequest request) {
        byte[] byArray;
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            request.writeTo((StreamOutput)out);
            byArray = BytesReference.toBytes((BytesReference)out.bytes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new NuxeoException("Cannot write elasticsearch bulk request " + request, (Throwable)e);
            }
        }
        out.close();
        return byArray;
    }
}

