/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.http.HttpServerTransport;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ESClientFactory;
import org.nuxeo.elasticsearch.client.ESRestClient;
import org.nuxeo.elasticsearch.config.ElasticSearchClientConfig;
import org.nuxeo.elasticsearch.core.ElasticSearchEmbeddedNode;
import org.nuxeo.runtime.api.Framework;

public class ESRestClientFactory
implements ESClientFactory {
    private static final Log log = LogFactory.getLog(ESRestClientFactory.class);
    public static final String DEFAULT_CONNECT_TIMEOUT_MS = "5000";
    public static final String DEFAULT_SOCKET_TIMEOUT_MS = "20000";
    public static final String CONNECTION_TIMEOUT_MS_OPT = "connection.timeout.ms";
    public static final String SOCKET_TIMEOUT_MS_OPT = "socket.timeout.ms";
    public static final String AUTH_USER_OPT = "username";
    public static final String AUTH_PASSWORD_OPT = "password";
    public static final String TRUST_STORE_PATH_OPT = "trustStorePath";
    public static final String TRUST_STORE_PASSWORD_OPT = "trustStorePassword";
    public static final String TRUST_STORE_TYPE_OPT = "trustStoreType";
    public static final String KEY_STORE_PATH_OPT = "keyStorePath";
    public static final String KEY_STORE_PASSWORD_OPT = "keyStorePassword";
    public static final String KEY_STORE_TYPE_OPT = "keyStoreType";
    @Deprecated
    public static final String DEPRECATED_TRUST_STORE_PATH_OPT = "keystore.path";
    @Deprecated
    public static final String DEPRECATED_TRUST_STORE_PASSWORD_OPT = "keystore.password";
    @Deprecated
    public static final String DEPRECATED_TRUST_STORE_TYPE_OPT = "keystore.type";
    protected static final String DEPRECATED_ES_TRUST_STORE_PATH_PROP = "elasticsearch.restClient.keystorePath";
    protected static final String DEPRECATED_ES_TRUST_STORE_PASSWORD_PROP = "elasticsearch.restClient.keystorePassword";
    protected static final String DEPRECATED_ES_TRUST_STORE_TYPE_PROP = "elasticsearch.restClient.keystoreType";
    protected static final String ES_TRUST_STORE_PATH_PROP = "elasticsearch.restClient.truststore.path";
    protected static final String ES_TRUST_STORE_PASSWORD_PROP = "elasticsearch.restClient.truststore.password";
    protected static final String ES_TRUST_STORE_TYPE_PROP = "elasticsearch.restClient.truststore.type";

    @Override
    public ESClient create(ElasticSearchEmbeddedNode node, ElasticSearchClientConfig config) {
        if (node != null) {
            return this.createLocalRestClient(node);
        }
        return this.createRestClient(config);
    }

    protected ESClient createLocalRestClient(ElasticSearchEmbeddedNode node) {
        if (!node.getConfig().httpEnabled()) {
            throw new IllegalArgumentException("Embedded configuration has no HTTP port enable, use TransportClient instead of Rest");
        }
        HttpServerTransport http = (HttpServerTransport)node.getNode().injector().getInstance(HttpServerTransport.class);
        Object[] addresses = http.boundAddress().boundAddresses();
        if (ArrayUtils.isEmpty((Object[])addresses)) {
            throw new IllegalStateException("Embedded node did not bind any address");
        }
        int port = addresses[0].getPort();
        RestClientBuilder lowLevelRestClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost("localhost", port)});
        RestHighLevelClient client = new RestHighLevelClient(lowLevelRestClientBuilder);
        return new ESRestClient(client.getLowLevelClient(), client);
    }

    protected ESClient createRestClient(ElasticSearchClientConfig config) {
        String addressList = config.getOption("addressList", "");
        if (addressList.isEmpty()) {
            throw new IllegalArgumentException("No addressList option provided cannot connect RestClient");
        }
        String[] hosts = addressList.split(",");
        HttpHost[] httpHosts = new HttpHost[hosts.length];
        int i = 0;
        for (String host : hosts) {
            httpHosts[i++] = HttpHost.create((String)host);
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts).setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.getConnectTimeoutMs(config)).setSocketTimeout(this.getSocketTimeoutMs(config))).setMaxRetryTimeoutMillis(this.getConnectTimeoutMs(config));
        this.addClientCallback(config, builder);
        RestHighLevelClient client = new RestHighLevelClient(builder);
        return new ESRestClient(client.getLowLevelClient(), client);
    }

    private void addClientCallback(ElasticSearchClientConfig config, RestClientBuilder builder) {
        BasicCredentialsProvider credentialProvider = this.getCredentialProvider(config);
        SSLContext sslContext = this.getSslContext(config);
        if (sslContext == null && credentialProvider == null) {
            return;
        }
        builder.setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.setSSLContext(sslContext);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialProvider);
            return httpClientBuilder;
        });
    }

    protected BasicCredentialsProvider getCredentialProvider(ElasticSearchClientConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getOption(AUTH_USER_OPT))) {
            return null;
        }
        String user = config.getOption(AUTH_USER_OPT);
        String password = config.getOption(AUTH_PASSWORD_OPT);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        return credentialsProvider;
    }

    protected SSLContext getSslContext(ElasticSearchClientConfig config) {
        this.checkDeprecatedProperties();
        String trustStorePath = (String)StringUtils.defaultIfBlank((CharSequence)config.getOption(TRUST_STORE_PATH_OPT), (CharSequence)config.getOption(DEPRECATED_TRUST_STORE_PATH_OPT));
        String trustStorePassword = (String)StringUtils.defaultIfBlank((CharSequence)config.getOption(TRUST_STORE_PASSWORD_OPT), (CharSequence)config.getOption(DEPRECATED_TRUST_STORE_PASSWORD_OPT));
        String trustStoreType = (String)StringUtils.defaultIfBlank((CharSequence)config.getOption(TRUST_STORE_TYPE_OPT), (CharSequence)config.getOption(DEPRECATED_TRUST_STORE_TYPE_OPT));
        String keyStorePath = config.getOption(KEY_STORE_PATH_OPT);
        String keyStorePassword = config.getOption(KEY_STORE_PASSWORD_OPT);
        String keyStoreType = config.getOption(KEY_STORE_TYPE_OPT);
        try {
            KeyStore trustStore = this.loadKeyStore(trustStorePath, trustStorePassword, trustStoreType);
            KeyStore keyStore = this.loadKeyStore(keyStorePath, keyStorePassword, keyStoreType);
            if (trustStore == null && keyStore == null) {
                return null;
            }
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (trustStore != null) {
                sslContextBuilder.loadTrustMaterial(trustStore, null);
            }
            if (keyStore != null) {
                sslContextBuilder.loadKeyMaterial(keyStore, StringUtils.isBlank((CharSequence)keyStorePassword) ? null : keyStorePassword.toCharArray());
            }
            return sslContextBuilder.build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new NuxeoException("Cannot setup SSL for RestClient: " + config, (Throwable)e);
        }
    }

    protected void checkDeprecatedProperties() {
        this.checkDeprecatedProperty(DEPRECATED_ES_TRUST_STORE_PATH_PROP, ES_TRUST_STORE_PATH_PROP);
        this.checkDeprecatedProperty(DEPRECATED_ES_TRUST_STORE_PASSWORD_PROP, ES_TRUST_STORE_PASSWORD_PROP);
        this.checkDeprecatedProperty(DEPRECATED_ES_TRUST_STORE_TYPE_PROP, ES_TRUST_STORE_TYPE_PROP);
    }

    protected void checkDeprecatedProperty(String oldProp, String newProp) {
        if (Framework.getRuntime() == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)Framework.getProperty((String)oldProp))) {
            log.warn((Object)("Configuration property " + oldProp + " is deprecated, use " + newProp + " instead"));
        }
    }

    protected KeyStore loadKeyStore(String path, String password, String type) throws GeneralSecurityException, IOException {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        String keyStoreType = (String)StringUtils.defaultIfBlank((CharSequence)type, (CharSequence)KeyStore.getDefaultType());
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        char[] passwordChars = StringUtils.isBlank((CharSequence)password) ? null : password.toCharArray();
        try (InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            keyStore.load(is, passwordChars);
        }
        return keyStore;
    }

    protected int getConnectTimeoutMs(ElasticSearchClientConfig config) {
        return Integer.parseInt(config.getOption(CONNECTION_TIMEOUT_MS_OPT, DEFAULT_CONNECT_TIMEOUT_MS));
    }

    protected int getSocketTimeoutMs(ElasticSearchClientConfig config) {
        return Integer.parseInt(config.getOption(SOCKET_TIMEOUT_MS_OPT, DEFAULT_SOCKET_TIMEOUT_MS));
    }

    protected void checkConnection(RestHighLevelClient client) {
        boolean ping = false;
        try {
            ping = client.ping(RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!ping) {
            throw new IllegalStateException("Fail to ping rest node");
        }
    }
}

