/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.fetcher;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.elasticsearch.fetcher.Fetcher;
import org.nuxeo.elasticsearch.io.DocumentModelReaders;

public class EsFetcher
extends Fetcher {
    protected final HitDocConsumer consumer;

    public EsFetcher(CoreSession session, SearchResponse response, Map<String, String> repoNames) {
        super(session, response, repoNames);
        this.consumer = null;
    }

    public EsFetcher(CoreSession session, SearchResponse response, Map<String, String> repoNames, HitDocConsumer consumer) {
        super(session, response, repoNames);
        this.consumer = consumer;
    }

    @Override
    public DocumentModelListImpl fetchDocuments() {
        DocumentModelListImpl ret = new DocumentModelListImpl(this.getResponse().getHits().getHits().length);
        CoreSession session = this.getSession();
        for (SearchHit hit : this.getResponse().getHits()) {
            Map esHighlights;
            DocumentModel doc = DocumentModelReaders.fromSource(hit.getSourceAsMap()).session(session).getDocumentModel();
            if (this.consumer != null) {
                this.consumer.accept(hit, doc);
            }
            if (!(esHighlights = hit.getHighlightFields()).isEmpty()) {
                HashMap fields = new HashMap();
                for (Map.Entry entry : esHighlights.entrySet()) {
                    String field = (String)entry.getKey();
                    ArrayList<String> list = new ArrayList<String>();
                    for (Text fragment : ((HighlightField)entry.getValue()).getFragments()) {
                        list.add(fragment.toString());
                    }
                    fields.put(field, list);
                }
                doc.putContextData("highlight", (Serializable)fields);
            }
            ret.add((Object)doc);
        }
        return ret;
    }

    @FunctionalInterface
    public static interface HitDocConsumer
    extends BiConsumer<SearchHit, DocumentModel> {
    }
}

