/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.VCSClusterInvalidator;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;

@XObject(value="repository", order={"@name"})
public class RepositoryDescriptor {
    private static final Log log = LogFactory.getLog(RepositoryDescriptor.class);
    @Deprecated
    public static final int DEFAULT_READ_ACL_MAX_SIZE = 4096;
    public static final int DEFAULT_PATH_OPTIM_VERSION = 2;
    public static final String DDL_MODE_IGNORE = "ignore";
    public static final String DDL_MODE_DUMP = "dump";
    public static final String DDL_MODE_EXECUTE = "execute";
    public static final String DDL_MODE_ABORT = "abort";
    public static final String DDL_MODE_COMPAT = "compat";
    public String name;
    @XNode(value="@label")
    public String label;
    @XNode(value="@isDefault")
    private Boolean isDefault;
    @XNode(value="repository")
    public RepositoryDescriptor repositoryDescriptor;
    public NuxeoConnectionManagerConfiguration pool;
    @XNode(value="backendClass")
    public Class<? extends RepositoryBackend> backendClass;
    @XNode(value="clusterInvalidatorClass")
    public Class<? extends VCSClusterInvalidator> clusterInvalidatorClass;
    @XNode(value="cachingMapper@class")
    public Class<? extends CachingMapper> cachingMapperClass;
    @XNode(value="cachingMapper@enabled")
    private Boolean cachingMapperEnabled;
    @XNodeMap(value="cachingMapper/property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> cachingMapperProperties = new HashMap<String, String>();
    @XNode(value="ddlMode")
    private String ddlMode;
    @XNode(value="noDDL")
    private Boolean noDDL;
    @XNodeList(value="sqlInitFile", type=ArrayList.class, componentType=String.class)
    public List<String> sqlInitFiles = new ArrayList<String>(0);
    @XNode(value="softDelete@enabled")
    private Boolean softDeleteEnabled;
    @XNode(value="proxies@enabled")
    private Boolean proxiesEnabled;
    @XNode(value="idType")
    public String idType;
    @XNode(value="clustering@delay")
    private Long clusteringDelay;
    @XNodeList(value="schema/field", type=ArrayList.class, componentType=FieldDescriptor.class)
    public List<FieldDescriptor> schemaFields = new ArrayList<FieldDescriptor>(0);
    @XNode(value="schema/arrayColumns")
    private Boolean arrayColumns;
    @XNode(value="childNameUniqueConstraintEnabled")
    private Boolean childNameUniqueConstraintEnabled;
    @XNode(value="collectionUniqueConstraintEnabled")
    private Boolean collectionUniqueConstraintEnabled;
    private String fulltextAnalyzer;
    private String fulltextCatalog;
    private FulltextDescriptor fulltextDescriptor = new FulltextDescriptor();
    @XNodeList(value="indexing/neverPerDocumentFacets/facet", type=HashSet.class, componentType=String.class)
    public Set<String> neverPerInstanceMixins = new HashSet<String>(0);
    @XNode(value="pathOptimizations@enabled")
    private Boolean pathOptimizationsEnabled;
    @XNode(value="pathOptimizations@version")
    private Integer pathOptimizationsVersion;
    @XNode(value="aclOptimizations@enabled")
    private Boolean aclOptimizationsEnabled;
    @XNode(value="aclOptimizations@readAclMaxSize")
    private Integer readAclMaxSize;
    @XNode(value="usersSeparator@key")
    public String usersSeparatorKey;
    @XNode(value="changeTokenEnabled")
    private Boolean changeTokenEnabled;

    private static boolean defaultFalse(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    private static boolean defaultTrue(Boolean bool) {
        return !Boolean.FALSE.equals(bool);
    }

    @XNode(value="@name")
    public void setName(String name) {
        this.name = name;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    @XNode(value="pool")
    public void setPool(NuxeoConnectionManagerConfiguration pool) {
        pool.setName("repository/" + this.name);
        this.pool = pool;
    }

    public boolean getCachingMapperEnabled() {
        return RepositoryDescriptor.defaultTrue(this.cachingMapperEnabled);
    }

    public String getDDLMode() {
        return this.ddlMode;
    }

    public boolean getNoDDL() {
        return RepositoryDescriptor.defaultFalse(this.noDDL);
    }

    public boolean getSoftDeleteEnabled() {
        return RepositoryDescriptor.defaultFalse(this.softDeleteEnabled);
    }

    protected void setSoftDeleteEnabled(boolean enabled) {
        this.softDeleteEnabled = enabled;
    }

    public boolean getProxiesEnabled() {
        return RepositoryDescriptor.defaultTrue(this.proxiesEnabled);
    }

    protected void setProxiesEnabled(boolean enabled) {
        this.proxiesEnabled = enabled;
    }

    public long getClusteringDelay() {
        return this.clusteringDelay == null ? 0L : this.clusteringDelay;
    }

    protected void setClusteringDelay(long delay) {
        this.clusteringDelay = delay;
    }

    public boolean getArrayColumns() {
        return RepositoryDescriptor.defaultFalse(this.arrayColumns);
    }

    public void setArrayColumns(boolean enabled) {
        this.arrayColumns = enabled;
    }

    public boolean getChildNameUniqueConstraintEnabled() {
        return RepositoryDescriptor.defaultTrue(this.childNameUniqueConstraintEnabled);
    }

    public boolean getCollectionUniqueConstraintEnabled() {
        return RepositoryDescriptor.defaultTrue(this.collectionUniqueConstraintEnabled);
    }

    @XNode(value="indexing/queryMaker@class")
    public void setQueryMakerDeprecated(String klass) {
        log.warn((Object)"Setting queryMaker from repository configuration is now deprecated");
    }

    public String getFulltextAnalyzer() {
        return this.fulltextAnalyzer;
    }

    @XNode(value="indexing/fulltext@analyzer")
    public void setFulltextAnalyzer(String fulltextAnalyzer) {
        this.fulltextAnalyzer = fulltextAnalyzer;
    }

    public String getFulltextCatalog() {
        return this.fulltextCatalog;
    }

    @XNode(value="indexing/fulltext@catalog")
    public void setFulltextCatalog(String fulltextCatalog) {
        this.fulltextCatalog = fulltextCatalog;
    }

    public FulltextDescriptor getFulltextDescriptor() {
        return this.fulltextDescriptor;
    }

    @XNode(value="indexing/fulltext@fieldSizeLimit")
    public void setFulltextFieldSizeLimit(int fieldSizeLimit) {
        this.fulltextDescriptor.setFulltextFieldSizeLimit(fieldSizeLimit);
    }

    @XNode(value="indexing/fulltext@disabled")
    public void setFulltextDisabled(boolean disabled) {
        this.fulltextDescriptor.setFulltextDisabled(disabled);
    }

    @XNode(value="indexing/fulltext@storedInBlob")
    public void setFulltextStoredInBlob(boolean storedInBlob) {
        this.fulltextDescriptor.setFulltextStoredInBlob(storedInBlob);
    }

    @XNode(value="indexing/fulltext@searchDisabled")
    public void setFulltextSearchDisabled(boolean disabled) {
        this.fulltextDescriptor.setFulltextSearchDisabled(disabled);
    }

    @XNodeList(value="indexing/fulltext/index", type=ArrayList.class, componentType=FulltextDescriptor.FulltextIndexDescriptor.class)
    public void setFulltextIndexes(List<FulltextDescriptor.FulltextIndexDescriptor> fulltextIndexes) {
        this.fulltextDescriptor.setFulltextIndexes(fulltextIndexes);
    }

    @XNodeList(value="indexing/excludedTypes/type", type=HashSet.class, componentType=String.class)
    public void setFulltextExcludedTypes(Set<String> fulltextExcludedTypes) {
        this.fulltextDescriptor.setFulltextExcludedTypes(fulltextExcludedTypes);
    }

    @XNodeList(value="indexing/includedTypes/type", type=HashSet.class, componentType=String.class)
    public void setFulltextIncludedTypes(Set<String> fulltextIncludedTypes) {
        this.fulltextDescriptor.setFulltextIncludedTypes(fulltextIncludedTypes);
    }

    public boolean getPathOptimizationsEnabled() {
        return RepositoryDescriptor.defaultTrue(this.pathOptimizationsEnabled);
    }

    protected void setPathOptimizationsEnabled(boolean enabled) {
        this.pathOptimizationsEnabled = enabled;
    }

    public int getPathOptimizationsVersion() {
        return this.pathOptimizationsVersion == null ? 2 : this.pathOptimizationsVersion;
    }

    public boolean getAclOptimizationsEnabled() {
        return RepositoryDescriptor.defaultTrue(this.aclOptimizationsEnabled);
    }

    protected void setAclOptimizationsEnabled(boolean enabled) {
        this.aclOptimizationsEnabled = enabled;
    }

    public int getReadAclMaxSize() {
        return this.readAclMaxSize == null ? 0 : this.readAclMaxSize;
    }

    public boolean isChangeTokenEnabled() {
        return RepositoryDescriptor.defaultFalse(this.changeTokenEnabled);
    }

    public void setChangeTokenEnabled(boolean enabled) {
        this.changeTokenEnabled = enabled;
    }

    public RepositoryDescriptor() {
    }

    public RepositoryDescriptor(RepositoryDescriptor other) {
        this.name = other.name;
        this.label = other.label;
        this.isDefault = other.isDefault;
        this.pool = other.pool == null ? null : new NuxeoConnectionManagerConfiguration(other.pool);
        this.backendClass = other.backendClass;
        this.clusterInvalidatorClass = other.clusterInvalidatorClass;
        this.cachingMapperClass = other.cachingMapperClass;
        this.cachingMapperEnabled = other.cachingMapperEnabled;
        this.cachingMapperProperties = new HashMap<String, String>(other.cachingMapperProperties);
        this.noDDL = other.noDDL;
        this.ddlMode = other.ddlMode;
        this.sqlInitFiles = new ArrayList<String>(other.sqlInitFiles);
        this.softDeleteEnabled = other.softDeleteEnabled;
        this.proxiesEnabled = other.proxiesEnabled;
        this.schemaFields = FieldDescriptor.copyList(other.schemaFields);
        this.arrayColumns = other.arrayColumns;
        this.childNameUniqueConstraintEnabled = other.childNameUniqueConstraintEnabled;
        this.collectionUniqueConstraintEnabled = other.collectionUniqueConstraintEnabled;
        this.idType = other.idType;
        this.clusteringDelay = other.clusteringDelay;
        this.fulltextAnalyzer = other.fulltextAnalyzer;
        this.fulltextCatalog = other.fulltextCatalog;
        this.fulltextDescriptor = new FulltextDescriptor(other.fulltextDescriptor);
        this.neverPerInstanceMixins = other.neverPerInstanceMixins;
        this.pathOptimizationsEnabled = other.pathOptimizationsEnabled;
        this.pathOptimizationsVersion = other.pathOptimizationsVersion;
        this.aclOptimizationsEnabled = other.aclOptimizationsEnabled;
        this.readAclMaxSize = other.readAclMaxSize;
        this.usersSeparatorKey = other.usersSeparatorKey;
        this.changeTokenEnabled = other.changeTokenEnabled;
    }

    public void merge(RepositoryDescriptor other) {
        if (other.name != null) {
            this.name = other.name;
        }
        if (other.label != null) {
            this.label = other.label;
        }
        if (other.isDefault != null) {
            this.isDefault = other.isDefault;
        }
        if (other.pool != null) {
            if (this.pool == null) {
                this.pool = new NuxeoConnectionManagerConfiguration(other.pool);
            } else {
                this.pool.merge(other.pool);
            }
        }
        if (other.backendClass != null) {
            this.backendClass = other.backendClass;
        }
        if (other.clusterInvalidatorClass != null) {
            this.clusterInvalidatorClass = other.clusterInvalidatorClass;
        }
        if (other.cachingMapperClass != null) {
            this.cachingMapperClass = other.cachingMapperClass;
        }
        if (other.cachingMapperEnabled != null) {
            this.cachingMapperEnabled = other.cachingMapperEnabled;
        }
        this.cachingMapperProperties.putAll(other.cachingMapperProperties);
        if (other.noDDL != null) {
            this.noDDL = other.noDDL;
        }
        if (other.ddlMode != null) {
            this.ddlMode = other.ddlMode;
        }
        this.sqlInitFiles.addAll(other.sqlInitFiles);
        if (other.softDeleteEnabled != null) {
            this.softDeleteEnabled = other.softDeleteEnabled;
        }
        if (other.proxiesEnabled != null) {
            this.proxiesEnabled = other.proxiesEnabled;
        }
        if (other.idType != null) {
            this.idType = other.idType;
        }
        if (other.clusteringDelay != null) {
            this.clusteringDelay = other.clusteringDelay;
        }
        for (FieldDescriptor of : other.schemaFields) {
            boolean append = true;
            for (FieldDescriptor f : this.schemaFields) {
                if (!f.field.equals(of.field)) continue;
                f.merge(of);
                append = false;
                break;
            }
            if (!append) continue;
            this.schemaFields.add(of);
        }
        if (other.arrayColumns != null) {
            this.arrayColumns = other.arrayColumns;
        }
        if (other.childNameUniqueConstraintEnabled != null) {
            this.childNameUniqueConstraintEnabled = other.childNameUniqueConstraintEnabled;
        }
        if (other.collectionUniqueConstraintEnabled != null) {
            this.collectionUniqueConstraintEnabled = other.collectionUniqueConstraintEnabled;
        }
        if (other.fulltextAnalyzer != null) {
            this.fulltextAnalyzer = other.fulltextAnalyzer;
        }
        if (other.fulltextCatalog != null) {
            this.fulltextCatalog = other.fulltextCatalog;
        }
        this.fulltextDescriptor.merge(other.fulltextDescriptor);
        this.neverPerInstanceMixins.addAll(other.neverPerInstanceMixins);
        if (other.pathOptimizationsEnabled != null) {
            this.pathOptimizationsEnabled = other.pathOptimizationsEnabled;
        }
        if (other.pathOptimizationsVersion != null) {
            this.pathOptimizationsVersion = other.pathOptimizationsVersion;
        }
        if (other.aclOptimizationsEnabled != null) {
            this.aclOptimizationsEnabled = other.aclOptimizationsEnabled;
        }
        if (other.readAclMaxSize != null) {
            this.readAclMaxSize = other.readAclMaxSize;
        }
        if (other.usersSeparatorKey != null) {
            this.usersSeparatorKey = other.usersSeparatorKey;
        }
        if (other.changeTokenEnabled != null) {
            this.changeTokenEnabled = other.changeTokenEnabled;
        }
    }

    @XObject(value="field")
    public static class FieldDescriptor {
        @XNode(value="@type")
        public String type;
        public String field;
        @XNode(value="@table")
        public String table;
        @XNode(value="@column")
        public String column;

        public FieldDescriptor() {
        }

        public FieldDescriptor(FieldDescriptor other) {
            this.type = other.type;
            this.field = other.field;
            this.table = other.table;
            this.column = other.column;
        }

        public static List<FieldDescriptor> copyList(List<FieldDescriptor> other) {
            ArrayList<FieldDescriptor> copy = new ArrayList<FieldDescriptor>(other.size());
            for (FieldDescriptor fd : other) {
                copy.add(new FieldDescriptor(fd));
            }
            return copy;
        }

        public void merge(FieldDescriptor other) {
            if (other.field != null) {
                this.field = other.field;
            }
            if (other.type != null) {
                this.type = other.type;
            }
            if (other.table != null) {
                this.table = other.table;
            }
            if (other.column != null) {
                this.column = other.column;
            }
        }

        @XNode(value="@name")
        public void setName(String name) {
            if (!StringUtils.isBlank((CharSequence)name) && this.field == null) {
                this.field = name;
            }
        }

        @XNode
        public void setXNodeContent(String name) {
            this.setName(name);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.field + ",type=" + this.type + ",table=" + this.table + ",column=" + this.column + ")";
        }
    }
}

