/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.SharedMetricRegistries;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.storage.lock.LockManagerService;
import org.nuxeo.ecm.core.storage.sql.CachingMapper;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryBackend;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.SoftRefCachingMapper;
import org.nuxeo.ecm.core.storage.sql.VCSClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidationsPropagator;
import org.nuxeo.ecm.core.storage.sql.VCSLockManager;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCBackend;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCClusterInvalidator;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.metrics.MetricsService;

public class RepositoryImpl
implements Repository {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RepositoryImpl.class);
    protected final RepositoryDescriptor repositoryDescriptor;
    private RepositoryBackend backend;
    private final Collection<SessionImpl> sessions;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Counter sessionCount;
    private LockManager lockManager;
    protected boolean selfRegisteredLockManager = false;
    public final VCSInvalidationsPropagator invalidationsPropagator;
    protected VCSClusterInvalidator clusterInvalidator;
    public boolean requiresClusterSQL;
    private Model model;
    public String repositoryId;
    private Reference reference;

    public RepositoryImpl(RepositoryDescriptor repositoryDescriptor) {
        this.repositoryDescriptor = repositoryDescriptor;
        this.sessions = new CopyOnWriteArrayList<SessionImpl>();
        this.invalidationsPropagator = new VCSInvalidationsPropagator();
        this.sessionCount = this.registry.counter(MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "sessions"}).tagged(new String[]{"repository", repositoryDescriptor.name}));
        this.createMetricsGauges();
        this.initRepository();
    }

    protected void createMetricsGauges() {
        MetricName gaugeName = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "size"}).tagged(new String[]{"repository", this.repositoryDescriptor.name});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCacheSize();
            }
        });
        gaugeName = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "pristine"}).tagged(new String[]{"repository", this.repositoryDescriptor.name});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCachePristineSize();
            }
        });
        gaugeName = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "selection"}).tagged(new String[]{"repository", this.repositoryDescriptor.name});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCacheSelectionSize();
            }
        });
        gaugeName = MetricName.build((String[])new String[]{"nuxeo", "repositories", "repository", "cache", "mapper"}).tagged(new String[]{"repository", this.repositoryDescriptor.name});
        this.registry.remove(gaugeName);
        this.registry.register(gaugeName, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return RepositoryImpl.this.getCacheMapperSize();
            }
        });
    }

    protected RepositoryBackend createBackend() {
        Class<? extends RepositoryBackend> backendClass = this.repositoryDescriptor.backendClass;
        if (backendClass == null) {
            backendClass = JDBCBackend.class;
        }
        try {
            return backendClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected Mapper createCachingMapper(Model model, Mapper mapper) {
        try {
            Class<? extends CachingMapper> cachingMapperClass = this.getCachingMapperClass();
            if (cachingMapperClass == null) {
                return mapper;
            }
            CachingMapper cachingMapper = cachingMapperClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            cachingMapper.initialize(this.getName(), model, mapper, this.invalidationsPropagator, this.repositoryDescriptor.cachingMapperProperties);
            return cachingMapper;
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected Class<? extends CachingMapper> getCachingMapperClass() {
        if (!this.repositoryDescriptor.getCachingMapperEnabled()) {
            return null;
        }
        Class<? extends CachingMapper> cachingMapperClass = this.repositoryDescriptor.cachingMapperClass;
        if (cachingMapperClass == null) {
            cachingMapperClass = SoftRefCachingMapper.class;
        }
        return cachingMapperClass;
    }

    public RepositoryDescriptor getRepositoryDescriptor() {
        return this.repositoryDescriptor;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public Model getModel() {
        return this.model;
    }

    public VCSInvalidationsPropagator getInvalidationsPropagator() {
        return this.invalidationsPropagator;
    }

    public boolean isChangeTokenEnabled() {
        return this.repositoryDescriptor.isChangeTokenEnabled();
    }

    @Override
    public SessionImpl getConnection(ConnectionSpec connectionSpec) {
        return this.getConnection();
    }

    @Override
    public synchronized SessionImpl getConnection() {
        if (Framework.getRuntime().isShuttingDown()) {
            throw new IllegalStateException("Cannot open connection, runtime is shutting down");
        }
        SessionPathResolver pathResolver = new SessionPathResolver();
        Mapper mapper = this.newMapper(pathResolver, true);
        SessionImpl session = this.newSession(this.model, mapper);
        pathResolver.setSession(session);
        this.sessions.add(session);
        this.sessionCount.inc();
        return session;
    }

    public Mapper newMapper(Session.PathResolver pathResolver, boolean useInvalidations) {
        return this.backend.newMapper(pathResolver, useInvalidations);
    }

    protected void initRepository() {
        log.debug((Object)"Initializing");
        this.backend = this.createBackend();
        this.prepareClusterInvalidator();
        this.model = this.backend.initialize(this);
        this.initLockManager();
        this.initClusterInvalidator();
        Class<? extends CachingMapper> cachingMapperClass = this.getCachingMapperClass();
        if (cachingMapperClass == null) {
            log.warn((Object)"VCS Mapper cache is disabled.");
        } else {
            log.info((Object)("VCS Mapper cache using: " + cachingMapperClass.getName()));
        }
        this.initRootNode();
    }

    protected void initRootNode() {
        try {
            this.getConnection().close();
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getLockManagerName() {
        return this.getName();
    }

    protected void initLockManager() {
        String lockManagerName = this.getLockManagerName();
        LockManagerService lockManagerService = (LockManagerService)Framework.getService(LockManagerService.class);
        this.lockManager = lockManagerService.getLockManager(lockManagerName);
        if (this.lockManager == null) {
            this.lockManager = new VCSLockManager(this);
            lockManagerService.registerLockManager(lockManagerName, this.lockManager);
            this.selfRegisteredLockManager = true;
        } else {
            this.selfRegisteredLockManager = false;
        }
        log.info((Object)("Repository " + this.getName() + " using lock manager " + this.lockManager));
    }

    protected void prepareClusterInvalidator() {
        if (((ClusterService)Framework.getService(ClusterService.class)).isEnabled()) {
            this.clusterInvalidator = this.createClusterInvalidator();
            this.requiresClusterSQL = this.clusterInvalidator.requiresClusterSQL();
        }
    }

    protected VCSClusterInvalidator createClusterInvalidator() {
        Class<? extends VCSClusterInvalidator> klass = this.repositoryDescriptor.clusterInvalidatorClass;
        if (klass == null) {
            klass = JDBCClusterInvalidator.class;
        }
        try {
            return klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected void initClusterInvalidator() {
        if (this.clusterInvalidator != null) {
            String nodeId = ((ClusterService)Framework.getService(ClusterService.class)).getNodeId();
            this.clusterInvalidator.initialize(nodeId, this);
            this.backend.setClusterInvalidator(this.clusterInvalidator);
        }
    }

    protected SessionImpl newSession(Model model, Mapper mapper) {
        mapper = this.createCachingMapper(model, mapper);
        return new SessionImpl(this, model, mapper);
    }

    public ResourceAdapterMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public RecordFactory getRecordFactory() {
        throw new UnsupportedOperationException();
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public synchronized void close() {
        LockManagerService lms;
        this.closeAllSessions();
        this.model = null;
        this.backend.shutdown();
        if (this.selfRegisteredLockManager && (lms = (LockManagerService)Framework.getService(LockManagerService.class)) != null) {
            lms.unregisterLockManager(this.getLockManagerName());
        }
    }

    protected synchronized void closeAllSessions() {
        for (SessionImpl session : this.sessions) {
            if (!session.isLive()) continue;
            session.closeSession();
        }
        this.sessions.clear();
        this.sessionCount.dec(this.sessionCount.getCount());
        if (this.lockManager != null) {
            this.lockManager.closeLockManager();
        }
    }

    @Override
    public String getName() {
        return this.repositoryDescriptor.name;
    }

    @Override
    public int getActiveSessionsCount() {
        return this.sessions.size();
    }

    @Override
    public int clearCaches() {
        int n = 0;
        for (SessionImpl session : this.sessions) {
            n += session.clearCaches();
        }
        if (this.lockManager != null) {
            this.lockManager.clearLockManagerCaches();
        }
        return n;
    }

    @Override
    public long getCacheSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCacheSize();
        }
        return size;
    }

    public long getCacheMapperSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCacheMapperSize();
        }
        return size;
    }

    @Override
    public long getCachePristineSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCachePristineSize();
        }
        return size;
    }

    @Override
    public long getCacheSelectionSize() {
        long size = 0L;
        for (SessionImpl session : this.sessions) {
            size += session.getCacheSelectionSize();
        }
        return size;
    }

    @Override
    public void processClusterInvalidationsNext() {
    }

    @Override
    public void markReferencedBinaries() {
        try (SessionImpl conn = this.getConnection();){
            conn.markReferencedBinaries();
        }
        catch (ResourceException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cleanupDeletedDocuments(int max, Calendar beforeTime) {
        int n;
        if (!this.repositoryDescriptor.getSoftDeleteEnabled()) {
            return 0;
        }
        SessionImpl conn = this.getConnection();
        try {
            n = conn.cleanupDeletedDocuments(max, beforeTime);
        }
        catch (Throwable throwable) {
            try {
                conn.close();
                throw throwable;
            }
            catch (ResourceException e) {
                throw new RuntimeException(e);
            }
        }
        conn.close();
        return n;
    }

    @Override
    public FulltextConfiguration getFulltextConfiguration() {
        return this.model.getFulltextConfiguration();
    }

    protected void closeSession(SessionImpl session) {
        this.sessions.remove(session);
        this.sessionCount.dec();
    }

    public static class SessionPathResolver
    implements Session.PathResolver {
        private Session session;

        protected void setSession(Session session) {
            this.session = session;
        }

        @Override
        public Serializable getIdForPath(String path) {
            Node node = this.session.getNodeByPath(path, null);
            return node == null ? null : node.getId();
        }
    }
}

