/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.tuple.Pair;
import org.nuxeo.common.utils.BatchUtils;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.PropertyType;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.VCSClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidations;
import org.nuxeo.ecm.core.storage.sql.VCSInvalidationsPropagator;
import org.nuxeo.ecm.core.storage.sql.jdbc.ACLCollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.CollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCConnection;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.ScalarCollectionIO;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Update;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class JDBCRowMapper
extends JDBCConnection
implements RowMapper {
    public static final int UPDATE_BATCH_SIZE = 100;
    public static final int DEBUG_MAX_TREE = 50;
    public static final String COLLECTION_DELETE_BEFORE_APPEND_PROP = "org.nuxeo.vcs.list-delete-before-append";
    private final VCSClusterInvalidator clusterInvalidator;
    private final VCSInvalidationsPropagator invalidationsPropagator;
    private final boolean collectionDeleteBeforeAppend;
    private final CollectionIO aclCollectionIO;
    private final CollectionIO scalarCollectionIO;

    public JDBCRowMapper(Model model, SQLInfo sqlInfo, VCSClusterInvalidator clusterInvalidator, VCSInvalidationsPropagator invalidationsPropagator) {
        super(model, sqlInfo);
        this.clusterInvalidator = clusterInvalidator;
        this.invalidationsPropagator = invalidationsPropagator;
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        this.collectionDeleteBeforeAppend = configurationService.isBooleanTrue(COLLECTION_DELETE_BEFORE_APPEND_PROP);
        this.aclCollectionIO = new ACLCollectionIO(this.collectionDeleteBeforeAppend);
        this.scalarCollectionIO = new ScalarCollectionIO(this.collectionDeleteBeforeAppend);
    }

    @Override
    public VCSInvalidations receiveInvalidations() {
        if (this.clusterInvalidator != null) {
            VCSInvalidations invalidations = (VCSInvalidations)this.clusterInvalidator.receiveInvalidations();
            if (invalidations != null && !invalidations.isEmpty()) {
                this.invalidationsPropagator.propagateInvalidations(invalidations, null);
            }
            return invalidations;
        }
        return null;
    }

    @Override
    public void sendInvalidations(VCSInvalidations invalidations) {
        if (this.clusterInvalidator != null) {
            this.clusterInvalidator.sendInvalidations(invalidations);
        }
    }

    @Override
    public void clearCache() {
    }

    @Override
    public long getCacheSize() {
        return 0L;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.xaresource.rollback(xid);
        }
        catch (XAException e) {
            this.logger.error("XA error on rollback: " + e);
            throw e;
        }
    }

    protected CollectionIO getCollectionIO(String tableName) {
        return tableName.equals("acls") ? this.aclCollectionIO : this.scalarCollectionIO;
    }

    @Override
    public Serializable generateNewId() {
        try {
            return this.dialect.getGeneratedId(this.connection);
        }
        catch (SQLException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<? extends RowId> read(Collection<RowId> rowIds, boolean cacheOnly) {
        ArrayList<RowId> res = new ArrayList<RowId>(rowIds.size());
        if (cacheOnly) {
            for (RowId rowId : rowIds) {
                res.add(new RowId(rowId));
            }
            return res;
        }
        HashMap<String, Set> tableIds = new HashMap<String, Set>();
        for (RowId rowId : rowIds) {
            tableIds.computeIfAbsent(rowId.tableName, k -> new HashSet()).add(rowId.id);
        }
        for (Map.Entry entry : tableIds.entrySet()) {
            List<Object> rows;
            int chunkSize;
            String tableName = (String)entry.getKey();
            HashSet<Serializable> ids = new HashSet<Serializable>((Collection)entry.getValue());
            int size = ids.size();
            if (size > (chunkSize = this.sqlInfo.getMaximumArgsForIn())) {
                void var13_18;
                ArrayList idList = new ArrayList(ids);
                rows = new ArrayList(size);
                boolean bl = false;
                while (var13_18 < size) {
                    int end = var13_18 + chunkSize;
                    if (end > size) {
                        end = size;
                    }
                    ArrayList<Serializable> chunkIds = new ArrayList<Serializable>(idList.subList((int)var13_18, end));
                    List<Row> chunkRows = this.model.isCollectionFragment(tableName) ? this.readCollectionArrays(tableName, chunkIds) : this.readSimpleRows(tableName, chunkIds);
                    rows.addAll(chunkRows);
                    var13_18 += chunkSize;
                }
            } else {
                rows = this.model.isCollectionFragment(tableName) ? this.readCollectionArrays(tableName, ids) : this.readSimpleRows(tableName, ids);
            }
            for (Row row : rows) {
                res.add(row);
                ids.remove(row.id);
            }
            for (Serializable serializable : ids) {
                res.add(new RowId(tableName, serializable));
            }
        }
        return res;
    }

    protected List<Row> readSimpleRows(String tableName, Collection<Serializable> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectFragmentsByIds(tableName, ids.size());
        Map<String, Serializable> criteriaMap = Collections.singletonMap("id", (Serializable)((Object)ids));
        return this.getSelectRows(tableName, select, criteriaMap, null, false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected List<Row> readCollectionArrays(String tableName, Collection<Serializable> ids) {
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        String[] orderBys = new String[]{"id", "pos"};
        HashSet<String> skipColumns = new HashSet<String>(Collections.singleton("pos"));
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectFragmentsByIds(tableName, ids.size(), orderBys, skipColumns);
        String sql = select.sql;
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, ids);
        }
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            LinkedList<Row> linkedList;
            block25: {
                int i = 1;
                for (Serializable id : ids) {
                    this.dialect.setId(ps, i++, id);
                }
                ResultSet rs = ps.executeQuery();
                try {
                    this.countExecute();
                    CollectionIO io = this.getCollectionIO(tableName);
                    PropertyType ftype = this.model.getCollectionFragmentType(tableName);
                    PropertyType type = ftype.getArrayBaseType();
                    Serializable curId = null;
                    ArrayList<Serializable> list = null;
                    Serializable[] returnId = new Serializable[1];
                    int[] returnPos = new int[]{-1};
                    LinkedList<Row> res = new LinkedList<Row>();
                    HashSet<Serializable> remainingIds = new HashSet<Serializable>(ids);
                    while (rs.next()) {
                        Serializable value = io.getCurrentFromResultSet(rs, select.whatColumns, this.model, returnId, returnPos);
                        Serializable newId = returnId[0];
                        if (newId != null && !newId.equals(curId)) {
                            if (list != null) {
                                res.add(new Row(tableName, curId, type.collectionToArray(list)));
                                remainingIds.remove(curId);
                            }
                            curId = newId;
                            list = new ArrayList<Serializable>();
                        }
                        list.add(value);
                    }
                    if (curId != null && list != null) {
                        res.add(new Row(tableName, curId, type.collectionToArray(list)));
                        remainingIds.remove(curId);
                    }
                    if (!remainingIds.isEmpty()) {
                        Serializable[] emptyArray = ftype.getEmptyArray();
                        for (Serializable id : remainingIds) {
                            res.add(new Row(tableName, id, emptyArray));
                        }
                    }
                    if (this.logger.isLogEnabled()) {
                        for (Row row : res) {
                            this.logger.log("  -> " + row);
                        }
                    }
                    linkedList = res;
                    if (rs == null) break block25;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return linkedList;
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not select: " + sql, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Row> getSelectRows(String tableName, SQLInfo.SQLInfoSelect select, Map<String, Serializable> criteriaMap, Map<String, Serializable> joinMap, boolean limitToOne) {
        LinkedList<Row> list = new LinkedList<Row>();
        if (select.whatColumns.isEmpty() && select.whereColumns.size() == 1 && "id".equals(select.whereColumns.get(0).getKey()) && joinMap == null) {
            Row row = new Row(tableName, criteriaMap);
            if (select.opaqueColumns != null) {
                for (Column column : select.opaqueColumns) {
                    row.putNew(column.getKey(), Row.OPAQUE);
                }
            }
            list.add(row);
            return list;
        }
        if (joinMap == null) {
            joinMap = Collections.emptyMap();
        }
        try (PreparedStatement ps = this.connection.prepareStatement(select.sql);){
            LinkedList<Row> linkedList;
            LinkedList<Serializable> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new LinkedList<Serializable>();
            }
            int i = 1;
            for (Column column : select.whereColumns) {
                Serializable v;
                String key = column.getKey();
                if (criteriaMap.containsKey(key)) {
                    v = criteriaMap.get(key);
                } else {
                    if (!joinMap.containsKey(key)) throw new RuntimeException(key);
                    v = joinMap.get(key);
                }
                if (v == null) {
                    throw new NuxeoException("Null value for key: " + key);
                }
                if (v instanceof Collection) {
                    for (Object vv : (Collection)((Object)v)) {
                        column.setToPreparedStatement(ps, i++, (Serializable)vv);
                        if (debugValues == null) continue;
                        debugValues.add((Serializable)vv);
                    }
                    continue;
                }
                column.setToPreparedStatement(ps, i++, v);
                if (debugValues == null) continue;
                debugValues.add(v);
            }
            if (debugValues != null) {
                this.logger.logSQL(select.sql, debugValues);
            }
            try (ResultSet rs = ps.executeQuery();){
                this.countExecute();
                while (rs.next()) {
                    Row row = new Row(tableName, criteriaMap);
                    i = 1;
                    for (Column column : select.whatColumns) {
                        row.put(column.getKey(), column.getFromResultSet(rs, i++));
                    }
                    if (select.opaqueColumns != null) {
                        for (Column column : select.opaqueColumns) {
                            row.putNew(column.getKey(), Row.OPAQUE);
                        }
                    }
                    if (this.logger.isLogEnabled()) {
                        this.logger.logResultSet(rs, select.whatColumns);
                    }
                    list.add(row);
                    if (!limitToOne) continue;
                    LinkedList<Row> linkedList2 = list;
                    return linkedList2;
                }
            }
            if (limitToOne) {
                linkedList = Collections.emptyList();
                return linkedList;
            }
            linkedList = list;
            return linkedList;
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new NuxeoException("Could not select: " + select.sql, (Throwable)e);
        }
    }

    @Override
    public void write(RowMapper.RowBatch batch) {
        if (!batch.deletes.isEmpty()) {
            this.writeDeletes(batch.deletes);
        }
        if (!batch.creates.isEmpty()) {
            this.writeCreates(batch.creates);
        }
        if (!batch.updates.isEmpty()) {
            this.writeUpdates(batch.updates);
        }
    }

    protected void writeCreates(List<Row> creates) {
        LinkedHashMap<String, List> tableRows = new LinkedHashMap<String, List>();
        tableRows.put("hierarchy", new LinkedList());
        for (Row row : creates) {
            tableRows.computeIfAbsent(row.tableName, k -> new LinkedList()).add(row);
        }
        for (Map.Entry entry : tableRows.entrySet()) {
            String tableName = (String)entry.getKey();
            List rows = (List)entry.getValue();
            if (this.model.isCollectionFragment(tableName)) {
                List<RowMapper.RowUpdate> rowus = rows.stream().map(RowMapper.RowUpdate::new).collect(Collectors.toList());
                this.insertCollectionRows(tableName, rowus);
                continue;
            }
            this.insertSimpleRows(tableName, rows);
        }
    }

    protected void writeUpdates(Set<RowMapper.RowUpdate> updates) {
        HashMap<String, List> tableRows = new HashMap<String, List>();
        for (RowMapper.RowUpdate rowu : updates) {
            tableRows.computeIfAbsent(rowu.row.tableName, k -> new ArrayList()).add(rowu);
        }
        ArrayList tables = new ArrayList();
        tables.addAll(tableRows.keySet());
        Collections.sort(tables);
        for (String tableName : tables) {
            List rows = (List)tableRows.get(tableName);
            Collections.sort(rows);
            if (this.model.isCollectionFragment(tableName)) {
                this.updateCollectionRows(tableName, rows);
                continue;
            }
            this.updateSimpleRows(tableName, rows);
        }
    }

    protected void writeDeletes(Collection<RowId> deletes) {
        HashMap<String, Set> tableIds = new HashMap<String, Set>();
        for (RowId rowId : deletes) {
            tableIds.computeIfAbsent(rowId.tableName, k -> new HashSet()).add(rowId.id);
        }
        for (Map.Entry entry : tableIds.entrySet()) {
            String tableName = (String)entry.getKey();
            Set ids = (Set)entry.getValue();
            this.deleteRows(tableName, ids);
        }
    }

    protected void insertSimpleRows(String tableName, List<Row> rows) {
        if (rows.isEmpty()) {
            return;
        }
        String sql = this.sqlInfo.getInsertSql(tableName);
        if (sql == null) {
            throw new NuxeoException("Unknown table: " + tableName);
        }
        boolean batched = this.supportsBatchUpdates && rows.size() > 1;
        Object loggedSql = batched ? sql + " -- BATCHED" : sql;
        List<Column> columns = this.sqlInfo.getInsertColumns(tableName);
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            int batch = 0;
            Iterator<Row> rowIt = rows.iterator();
            while (rowIt.hasNext()) {
                Row row = rowIt.next();
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL((String)loggedSql, columns, row);
                }
                int i = 1;
                for (Column column : columns) {
                    column.setToPreparedStatement(ps, i++, row.get(column.getKey()));
                }
                if (batched) {
                    ps.addBatch();
                    if (++batch % 100 != 0 && rowIt.hasNext()) continue;
                    ps.executeBatch();
                    this.countExecute();
                    continue;
                }
                ps.execute();
                this.countExecute();
            }
        }
        catch (SQLException e) {
            if (e instanceof BatchUpdateException) {
                BatchUpdateException bue = (BatchUpdateException)e;
                if (e.getCause() == null && bue.getNextException() != null) {
                    e.initCause(bue.getNextException());
                }
            }
            this.checkConcurrentUpdate(e);
            throw new NuxeoException("Could not insert: " + sql, (Throwable)e);
        }
    }

    protected void insertCollectionRows(String tableName, List<RowMapper.RowUpdate> rowus) {
        if (rowus.isEmpty()) {
            return;
        }
        String sql = this.sqlInfo.getInsertSql(tableName);
        List<Column> columns = this.sqlInfo.getInsertColumns(tableName);
        CollectionIO io = this.getCollectionIO(tableName);
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            io.executeInserts(ps, rowus, columns, this.supportsBatchUpdates, sql, this);
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new NuxeoException("Could not insert: " + sql, (Throwable)e);
        }
    }

    protected void updateSimpleRows(String tableName, List<RowMapper.RowUpdate> rows) {
        if (rows.isEmpty()) {
            return;
        }
        List batchedPairs = BatchUtils.groupByDerived(rows, rowu -> this.sqlInfo.getUpdateById(tableName, (RowMapper.RowUpdate)rowu), (a, b) -> a.sql.equals(b.sql));
        for (Pair pair : batchedPairs) {
            SQLInfo.SQLInfoSelect update = (SQLInfo.SQLInfoSelect)pair.getLeft();
            List rowUpdates = (List)pair.getRight();
            boolean changeTokenEnabled = this.model.getRepositoryDescriptor().isChangeTokenEnabled();
            boolean batched = this.supportsBatchUpdates && rowUpdates.size() > 1 && (this.dialect.supportsBatchUpdateCount() || !changeTokenEnabled);
            Object loggedSql = batched ? update.sql + " -- BATCHED" : update.sql;
            try {
                PreparedStatement ps = this.connection.prepareStatement(update.sql);
                try {
                    int batch = 0;
                    Iterator rowIt = rowUpdates.iterator();
                    while (rowIt.hasNext()) {
                        RowMapper.RowUpdate rowu2 = (RowMapper.RowUpdate)rowIt.next();
                        if (this.logger.isLogEnabled()) {
                            this.logger.logSQL((String)loggedSql, update.whatColumns, rowu2.row, update.whereColumns, rowu2.conditions);
                        }
                        int i = 1;
                        for (Column column : update.whatColumns) {
                            Serializable value = rowu2.row.get(column.getKey());
                            if (value instanceof Delta) {
                                value = ((Delta)value).getDeltaValue();
                            }
                            column.setToPreparedStatement(ps, i++, value);
                        }
                        boolean hasConditions = false;
                        for (Column column3 : update.whereColumns) {
                            Serializable value;
                            String key = column3.getKey();
                            if (key.equals("id")) {
                                value = rowu2.row.get(key);
                            } else {
                                hasConditions = true;
                                value = rowu2.conditions.get(key);
                            }
                            column3.setToPreparedStatement(ps, i++, value);
                        }
                        if (batched) {
                            ps.addBatch();
                            if (++batch % 100 != 0 && rowIt.hasNext()) continue;
                            int[] nArray = ps.executeBatch();
                            this.countExecute();
                            if (!changeTokenEnabled || !hasConditions) continue;
                            for (int j = 0; j < nArray.length; ++j) {
                                int count = nArray[j];
                                if (count == -2 || count == 1) continue;
                                Serializable id = ((RowMapper.RowUpdate)rowUpdates.get((int)j)).row.id;
                                this.logger.log("  -> CONCURRENT UPDATE: " + id);
                                throw new ConcurrentUpdateException(id.toString());
                            }
                            continue;
                        }
                        int n = ps.executeUpdate();
                        this.countExecute();
                        if (!changeTokenEnabled || !hasConditions || n == -2 || n == 1) continue;
                        Serializable id = rowu2.row.id;
                        this.logger.log("  -> CONCURRENT UPDATE: " + id);
                        throw new ConcurrentUpdateException(id.toString());
                    }
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.checkConcurrentUpdate(e);
                throw new NuxeoException("Could not update: " + update.sql, (Throwable)e);
            }
        }
    }

    protected void updateCollectionRows(String tableName, List<RowMapper.RowUpdate> rowus) {
        HashSet<Serializable> deleteIds = new HashSet<Serializable>();
        for (RowMapper.RowUpdate rowu : rowus) {
            if (rowu.pos != -1 && !this.collectionDeleteBeforeAppend) continue;
            deleteIds.add(rowu.row.id);
        }
        this.deleteRows(tableName, deleteIds);
        this.insertCollectionRows(tableName, rowus);
    }

    protected void deleteRows(String tableName, Set<Serializable> ids) {
        int chunkSize;
        if (ids.isEmpty()) {
            return;
        }
        int size = ids.size();
        if (size > (chunkSize = this.sqlInfo.getMaximumArgsForIn())) {
            ArrayList<Serializable> idList = new ArrayList<Serializable>(ids);
            for (int start = 0; start < size; start += chunkSize) {
                int end = start + chunkSize;
                if (end > size) {
                    end = size;
                }
                ArrayList<Serializable> chunkIds = new ArrayList<Serializable>(idList.subList(start, end));
                this.deleteRowsDirect(tableName, chunkIds);
            }
        } else {
            this.deleteRowsDirect(tableName, ids);
        }
    }

    protected void deleteRowsSoft(List<RowMapper.NodeInfo> nodeInfos) {
        try {
            int size = nodeInfos.size();
            ArrayList<Serializable> ids = new ArrayList<Serializable>(size);
            for (RowMapper.NodeInfo info : nodeInfos) {
                ids.add(info.id);
            }
            int chunkSize = 100;
            if (size <= chunkSize) {
                this.doSoftDeleteRows(ids);
            } else {
                int start = 0;
                while (start < size) {
                    int end = start + chunkSize;
                    if (end > size) {
                        end = size;
                    }
                    this.doSoftDeleteRows(ids.subList(start, end));
                    start = end;
                }
            }
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not soft delete", (Throwable)e);
        }
    }

    protected void doSoftDeleteRows(List<Serializable> ids) throws SQLException {
        Serializable whereIds = this.newIdArray(ids);
        Calendar now = Calendar.getInstance();
        String sql = this.sqlInfo.getSoftDeleteSql();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Arrays.asList(whereIds, now));
        }
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            this.setToPreparedStatementIdArray(ps, 1, whereIds);
            this.dialect.setToPreparedStatementTimestamp(ps, 2, now, null);
            ps.execute();
            this.countExecute();
        }
    }

    protected Serializable newIdArray(Collection<Serializable> ids) {
        if (this.dialect.supportsArrays()) {
            return ids.toArray();
        }
        StringBuilder b = new StringBuilder();
        for (Serializable id : ids) {
            b.append(id);
            b.append('|');
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    protected void setToPreparedStatementIdArray(PreparedStatement ps, int index, Serializable idArray) throws SQLException {
        if (idArray instanceof String) {
            ps.setString(index, (String)((Object)idArray));
        } else {
            Array array = this.dialect.createArrayOf(1111, (Object[])idArray, this.connection);
            ps.setArray(index, array);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int cleanupDeletedRows(int max, Calendar beforeTime) {
        if (max < 0) {
            max = 0;
        }
        String sql = this.sqlInfo.getSoftDeleteCleanupSql();
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Arrays.asList(beforeTime, Long.valueOf(max)));
        }
        try {
            if (sql.startsWith("{")) {
                boolean outFirst = sql.startsWith("{?=");
                int outIndex = outFirst ? 1 : 3;
                int inIndex = outFirst ? 2 : 1;
                try (CallableStatement cs = this.connection.prepareCall(sql);){
                    cs.setInt(inIndex, max);
                    this.dialect.setToPreparedStatementTimestamp(cs, inIndex + 1, beforeTime, null);
                    cs.registerOutParameter(outIndex, 4);
                    cs.execute();
                    int count = cs.getInt(outIndex);
                    this.logger.logCount(count);
                    int n = count;
                    return n;
                }
            }
            try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                int n;
                block24: {
                    ps.setInt(1, max);
                    this.dialect.setToPreparedStatementTimestamp(ps, 2, beforeTime, null);
                    ResultSet rs = ps.executeQuery();
                    try {
                        this.countExecute();
                        if (!rs.next()) {
                            throw new NuxeoException("Cannot get result");
                        }
                        int count = rs.getInt(1);
                        this.logger.logCount(count);
                        n = count;
                        if (rs == null) break block24;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return n;
            }
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not purge soft delete", (Throwable)e);
        }
    }

    protected void deleteRowsDirect(String tableName, Collection<Serializable> ids) {
        String sql = this.sqlInfo.getDeleteSql(tableName, ids.size());
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, ids);
        }
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            int i = 1;
            for (Serializable id : ids) {
                this.dialect.setId(ps, i++, id);
            }
            int count = ps.executeUpdate();
            this.countExecute();
            this.logger.logCount(count);
        }
        catch (SQLException e) {
            this.checkConcurrentUpdate(e);
            throw new NuxeoException("Could not delete: " + tableName, (Throwable)e);
        }
    }

    @Override
    public Row readSimpleRow(RowId rowId) {
        Map<String, Serializable> criteriaMap;
        SQLInfo.SQLInfoSelect select = this.sqlInfo.selectFragmentById.get(rowId.tableName);
        List<Row> maps = this.getSelectRows(rowId.tableName, select, criteriaMap = Collections.singletonMap("id", rowId.id), null, true);
        return maps.isEmpty() ? null : maps.get(0);
    }

    @Override
    public Map<String, String> getBinaryFulltext(RowId rowId) {
        HashMap<String, String> hashMap;
        block21: {
            ArrayList<String> columns = new ArrayList<String>();
            for (String index : this.model.getFulltextConfiguration().indexesAllBinary) {
                String col = "binarytext" + this.model.getFulltextIndexSuffix(index);
                columns.add(col);
            }
            Serializable id = rowId.id;
            HashMap<String, String> ret = new HashMap<String, String>(columns.size());
            String sql = this.dialect.getBinaryFulltextSql(columns);
            if (sql == null) {
                this.logger.info("getBinaryFulltextSql not supported for dialect " + this.dialect);
                return ret;
            }
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singletonList(id));
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                this.dialect.setId(ps, 1, id);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        for (int i = 1; i <= columns.size(); ++i) {
                            ret.put(columns.get(i - 1), rs.getString(i));
                        }
                    }
                    if (this.logger.isLogEnabled()) {
                        this.logger.log("  -> " + ret);
                    }
                }
                hashMap = ret;
                if (ps == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new NuxeoException("Could not select: " + sql, (Throwable)e);
                }
            }
            ps.close();
        }
        return hashMap;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Serializable[] readCollectionRowArray(RowId rowId) {
        String tableName = rowId.tableName;
        Serializable id = rowId.id;
        String sql = this.sqlInfo.selectFragmentById.get((Object)tableName).sql;
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singletonList(id));
        }
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            Serializable[] serializableArray;
            block17: {
                List<Column> columns = this.sqlInfo.selectFragmentById.get((Object)tableName).whatColumns;
                this.dialect.setId(ps, 1, id);
                ResultSet rs = ps.executeQuery();
                try {
                    this.countExecute();
                    CollectionIO io = this.getCollectionIO(tableName);
                    ArrayList<Serializable> list = new ArrayList<Serializable>();
                    Serializable[] returnId = new Serializable[1];
                    int[] returnPos = new int[]{-1};
                    while (rs.next()) {
                        list.add(io.getCurrentFromResultSet(rs, columns, this.model, returnId, returnPos));
                    }
                    PropertyType type = this.model.getCollectionFragmentType(tableName).getArrayBaseType();
                    Serializable[] array = type.collectionToArray(list);
                    if (this.logger.isLogEnabled()) {
                        this.logger.log("  -> " + Arrays.asList(array));
                    }
                    serializableArray = array;
                    if (rs == null) break block17;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return serializableArray;
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not select: " + sql, (Throwable)e);
        }
    }

    @Override
    public List<Row> readSelectionRows(SelectionType selType, Serializable selId, Serializable filter, Serializable criterion, boolean limitToOne) {
        SQLInfo.SQLInfoSelect select;
        SQLInfo.SQLInfoSelection selInfo = this.sqlInfo.getSelection(selType);
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        criteriaMap.put(selType.selKey, selId);
        if (filter == null) {
            select = selInfo.selectAll;
        } else {
            select = selInfo.selectFiltered;
            criteriaMap.put(selType.filterKey, filter);
        }
        if (selType.criterionKey != null) {
            criteriaMap.put(selType.criterionKey, criterion);
        }
        return this.getSelectRows(selType.tableName, select, criteriaMap, null, limitToOne);
    }

    @Override
    public Set<Serializable> readSelectionsIds(SelectionType selType, List<Serializable> values) {
        int chunkSize;
        SQLInfo.SQLInfoSelection selInfo = this.sqlInfo.getSelection(selType);
        HashMap<String, Serializable> criteriaMap = new HashMap<String, Serializable>();
        HashSet<Serializable> ids = new HashSet<Serializable>();
        int size = values.size();
        if (size > (chunkSize = this.sqlInfo.getMaximumArgsForIn())) {
            for (int start = 0; start < size; start += chunkSize) {
                int end = start + chunkSize;
                if (end > size) {
                    end = size;
                }
                ArrayList<Serializable> chunkTodo = new ArrayList<Serializable>(values.subList(start, end));
                criteriaMap.put(selType.selKey, chunkTodo);
                SQLInfo.SQLInfoSelect select = selInfo.getSelectSelectionIds(chunkTodo.size());
                List<Row> rows = this.getSelectRows(selType.tableName, select, criteriaMap, null, false);
                rows.forEach(row -> ids.add(row.id));
            }
        } else {
            criteriaMap.put(selType.selKey, (Serializable)((Object)values));
            SQLInfo.SQLInfoSelect select = selInfo.getSelectSelectionIds(values.size());
            List<Row> rows = this.getSelectRows(selType.tableName, select, criteriaMap, null, false);
            rows.forEach(row -> ids.add(row.id));
        }
        return ids;
    }

    @Override
    public RowMapper.CopyResult copy(RowMapper.IdWithTypes source, Serializable destParentId, String destName, Row overwriteRow, boolean excludeSpecialChildren) {
        VCSInvalidations invalidations = new VCSInvalidations();
        try {
            Serializable invalParentId;
            Serializable overwriteId;
            LinkedHashMap<Serializable, Serializable> idMap = new LinkedHashMap<Serializable, Serializable>();
            HashMap<Serializable, RowMapper.IdWithTypes> idToTypes = new HashMap<Serializable, RowMapper.IdWithTypes>();
            Serializable serializable = overwriteId = overwriteRow == null ? null : overwriteRow.id;
            if (overwriteId != null) {
                String tableName = "hierarchy";
                this.updateSimpleRowWithValues(tableName, overwriteRow);
                idMap.put(source.id, overwriteId);
                invalidations.addModified(new RowId(tableName, overwriteId));
            }
            boolean resetVersion = destParentId != null;
            HashSet<Serializable> recordIds = new HashSet<Serializable>();
            Serializable newRootId = this.copyHierRecursive(source, destParentId, destName, overwriteId, resetVersion, idMap, idToTypes, recordIds, excludeSpecialChildren);
            Serializable serializable2 = invalParentId = overwriteId == null ? destParentId : overwriteId;
            if (invalParentId != null) {
                invalidations.addModified(new RowId("__PARENT__", invalParentId));
            }
            HashSet<Serializable> proxyIds = new HashSet<Serializable>();
            for (Map.Entry<String, Set<Serializable>> entry : this.model.getPerFragmentIds(idToTypes).entrySet()) {
                Boolean invalidation;
                String tableName = entry.getKey();
                if (tableName.equals("hierarchy") || tableName.equals("versions")) continue;
                Set<Serializable> ids = entry.getValue();
                if (tableName.equals("proxies")) {
                    for (Serializable id : ids) {
                        proxyIds.add((Serializable)idMap.get(id));
                    }
                }
                if ((invalidation = this.copyRows(tableName, ids, idMap, overwriteId)) == null) continue;
                if (Boolean.TRUE.equals(invalidation)) {
                    invalidations.addModified(new RowId(tableName, overwriteId));
                    continue;
                }
                invalidations.addDeleted(new RowId(tableName, overwriteId));
            }
            return new RowMapper.CopyResult(newRootId, invalidations, proxyIds, recordIds);
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not copy: " + source.id.toString(), (Throwable)e);
        }
    }

    protected void updateSimpleRowWithValues(String tableName, Row row) {
        Update update = this.sqlInfo.getUpdateByIdForKeys(tableName, row.getKeys());
        Table table = update.getTable();
        String sql = update.getStatement();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            if (this.logger.isLogEnabled()) {
                LinkedList<Serializable> values = new LinkedList<Serializable>();
                values.addAll(row.getValues());
                values.add(row.id);
                this.logger.logSQL(sql, values);
            }
            int i = 1;
            List<String> keys = row.getKeys();
            List<Serializable> values = row.getValues();
            int size = keys.size();
            for (int r = 0; r < size; ++r) {
                String key = keys.get(r);
                Serializable value = values.get(r);
                table.getColumn(key).setToPreparedStatement(ps, i++, value);
            }
            this.dialect.setId(ps, i, row.id);
            ps.executeUpdate();
            this.countExecute();
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not update: " + sql, (Throwable)e);
        }
    }

    protected Serializable copyHierRecursive(RowMapper.IdWithTypes source, Serializable parentId, String name, Serializable overwriteId, boolean resetVersion, Map<Serializable, Serializable> idMap, Map<Serializable, RowMapper.IdWithTypes> idToTypes, Set<Serializable> recordIds, boolean excludeSpecialChildren) throws SQLException {
        Serializable newId;
        idToTypes.put(source.id, source);
        if (overwriteId == null) {
            newId = this.copyHier(source.id, parentId, name, resetVersion, idMap);
        } else {
            newId = overwriteId;
            idMap.put(source.id, newId);
        }
        if (source.isRecord) {
            recordIds.add(newId);
        }
        boolean excludeRegularChildren = parentId == null;
        for (RowMapper.IdWithTypes child : this.getChildrenIdsWithTypes(source.id, excludeSpecialChildren, excludeRegularChildren)) {
            this.copyHierRecursive(child, newId, null, null, resetVersion, idMap, idToTypes, recordIds, excludeSpecialChildren);
        }
        return newId;
    }

    protected Serializable copyHier(Serializable id, Serializable parentId, String name, boolean resetVersion, Map<Serializable, Serializable> idMap) throws SQLException {
        boolean explicitName = name != null;
        SQLInfo.SQLInfoSelect copy = this.sqlInfo.getCopyHier(explicitName, resetVersion);
        try (PreparedStatement ps = this.connection.prepareStatement(copy.sql);){
            Serializable newId = this.generateNewId();
            ArrayList<Object> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new ArrayList<Object>(4);
            }
            int i = 1;
            for (Column column : copy.whatColumns) {
                Object v;
                String key = column.getKey();
                if (key.equals("parentid")) {
                    v = parentId;
                } else if (key.equals("name")) {
                    v = name;
                } else if (key.equals("id")) {
                    v = newId;
                } else if (key.equals("isrecord")) {
                    v = null;
                } else if (key.equals("baseversionid") || key.equals("ischeckedin")) {
                    v = null;
                } else if (key.equals("minorversion") || key.equals("majorversion")) {
                    v = null;
                } else {
                    throw new RuntimeException(column.toString());
                }
                column.setToPreparedStatement(ps, i++, (Serializable)v);
                if (debugValues == null) continue;
                debugValues.add(v);
            }
            Column whereColumn = copy.whereColumns.get(0);
            whereColumn.setToPreparedStatement(ps, i, id);
            if (debugValues != null) {
                debugValues.add(id);
                this.logger.logSQL(copy.sql, debugValues);
            }
            ps.executeUpdate();
            this.countExecute();
            idMap.put(id, newId);
            Serializable serializable = newId;
            return serializable;
        }
    }

    protected List<RowMapper.IdWithTypes> getChildrenIdsWithTypes(Serializable id, boolean excludeSpecialChildren, boolean excludeRegularChildren) throws SQLException {
        LinkedList<RowMapper.IdWithTypes> children = new LinkedList<RowMapper.IdWithTypes>();
        String sql = this.sqlInfo.getSelectChildrenIdsAndTypesSql(excludeSpecialChildren, excludeRegularChildren);
        if (this.logger.isLogEnabled()) {
            this.logger.logSQL(sql, Collections.singletonList(id));
        }
        List<Column> columns = this.sqlInfo.getSelectChildrenIdsAndTypesWhatColumns();
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            LinkedList<CallSite> debugValues = null;
            if (this.logger.isLogEnabled()) {
                debugValues = new LinkedList<CallSite>();
            }
            this.dialect.setId(ps, 1, id);
            try (ResultSet rs = ps.executeQuery();){
                this.countExecute();
                while (rs.next()) {
                    Serializable childId = null;
                    String childPrimaryType = null;
                    String[] childMixinTypes = null;
                    boolean isRecord = false;
                    int i = 1;
                    for (Column column : columns) {
                        String key = column.getKey();
                        Serializable value = column.getFromResultSet(rs, i++);
                        if (key.equals("id")) {
                            childId = value;
                            continue;
                        }
                        if (key.equals("primarytype")) {
                            childPrimaryType = (String)((Object)value);
                            continue;
                        }
                        if (key.equals("mixintypes")) {
                            childMixinTypes = (String[])value;
                            continue;
                        }
                        if (!key.equals("isrecord")) continue;
                        isRecord = Boolean.TRUE.equals(value);
                    }
                    children.add(new RowMapper.IdWithTypes(childId, childPrimaryType, childMixinTypes, isRecord));
                    if (debugValues == null) continue;
                    debugValues.add((CallSite)((Object)(childId + "/" + childPrimaryType + "/" + Arrays.toString(childMixinTypes))));
                }
            }
            if (debugValues != null) {
                this.logger.log("  -> " + debugValues);
            }
            LinkedList<RowMapper.IdWithTypes> linkedList = children;
            return linkedList;
        }
    }

    protected Boolean copyRows(String tableName, Set<Serializable> ids, Map<Serializable, Serializable> idMap, Serializable overwriteId) throws SQLException {
        String copySql = this.sqlInfo.getCopySql(tableName);
        Column copyIdColumn = this.sqlInfo.getCopyIdColumn(tableName);
        String deleteSql = this.sqlInfo.getDeleteSql(tableName);
        try (PreparedStatement copyPs = this.connection.prepareStatement(copySql);){
            Object object;
            block16: {
                PreparedStatement deletePs = this.connection.prepareStatement(deleteSql);
                try {
                    boolean before = false;
                    boolean after = false;
                    object = ids.iterator();
                    while (object.hasNext()) {
                        Serializable id = object.next();
                        Serializable newId = idMap.get(id);
                        boolean overwrite = newId.equals(overwriteId);
                        if (overwrite) {
                            if (this.logger.isLogEnabled()) {
                                this.logger.logSQL(deleteSql, Collections.singletonList(newId));
                            }
                            this.dialect.setId(deletePs, 1, newId);
                            int delCount = deletePs.executeUpdate();
                            this.countExecute();
                            before = delCount > 0;
                        }
                        copyIdColumn.setToPreparedStatement(copyPs, 1, newId);
                        copyIdColumn.setToPreparedStatement(copyPs, 2, id);
                        if (this.logger.isLogEnabled()) {
                            this.logger.logSQL(copySql, Arrays.asList(newId, id));
                        }
                        int copyCount = copyPs.executeUpdate();
                        this.countExecute();
                        if (!overwrite) continue;
                        after = copyCount > 0;
                    }
                    Object object2 = after ? Boolean.TRUE : (object = before ? Boolean.FALSE : null);
                    if (deletePs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (deletePs != null) {
                        try {
                            deletePs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                deletePs.close();
            }
            return object;
        }
    }

    @Override
    public void remove(Serializable rootId, List<RowMapper.NodeInfo> nodeInfos) {
        if (this.sqlInfo.softDeleteEnabled) {
            this.deleteRowsSoft(nodeInfos);
        } else {
            this.deleteRowsDirect("hierarchy", Collections.singleton(rootId));
        }
    }

    @Override
    public List<RowMapper.NodeInfo> getDescendantsInfo(Serializable rootId) {
        LinkedList<RowMapper.NodeInfo> linkedList;
        block21: {
            if (!this.dialect.supportsFastDescendants()) {
                return this.getDescendantsInfoIterative(rootId);
            }
            LinkedList<RowMapper.NodeInfo> descendants = new LinkedList<RowMapper.NodeInfo>();
            String sql = this.sqlInfo.getSelectDescendantsInfoSql();
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singletonList(rootId));
            }
            List<Column> columns = this.sqlInfo.getSelectDescendantsInfoWhatColumns();
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                LinkedList<CallSite> debugValues = null;
                if (this.logger.isLogEnabled()) {
                    debugValues = new LinkedList<CallSite>();
                }
                this.dialect.setId(ps, 1, rootId);
                try (ResultSet rs = ps.executeQuery();){
                    this.countExecute();
                    while (rs.next()) {
                        RowMapper.NodeInfo info = this.getNodeInfo(rs, columns);
                        descendants.add(info);
                        if (debugValues == null || debugValues.size() >= 50) continue;
                        debugValues.add((CallSite)((Object)(info.id + "/" + info.primaryType)));
                    }
                }
                if (debugValues != null) {
                    if (debugValues.size() >= 50) {
                        debugValues.add((CallSite)((Object)("... (" + descendants.size() + ") results")));
                    }
                    this.logger.log("  -> " + debugValues);
                }
                linkedList = descendants;
                if (ps == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new NuxeoException("Failed to get descendants", (Throwable)e);
                }
            }
            ps.close();
        }
        return linkedList;
    }

    /*
     * Could not resolve type clashes
     */
    protected List<RowMapper.NodeInfo> getDescendantsInfoIterative(Serializable rootId) {
        HashSet<Serializable> done = new HashSet<Serializable>();
        ArrayList<Serializable> todo = new ArrayList<Serializable>(Collections.singleton(rootId));
        ArrayList<RowMapper.NodeInfo> descendants = new ArrayList<RowMapper.NodeInfo>();
        while (!todo.isEmpty()) {
            List<Object> infos;
            int chunkSize;
            int size = todo.size();
            if (size > (chunkSize = this.sqlInfo.getMaximumArgsForIn())) {
                infos = new ArrayList();
                for (int start = 0; start < size; start += chunkSize) {
                    int end = start + chunkSize;
                    if (end > size) {
                        end = size;
                    }
                    ArrayList<Serializable> chunkTodo = new ArrayList<Serializable>(todo.subList(start, end));
                    List<RowMapper.NodeInfo> chunkInfos = this.getChildrenNodeInfos(chunkTodo);
                    infos.addAll(chunkInfos);
                }
            } else {
                infos = this.getChildrenNodeInfos(todo);
            }
            todo = new ArrayList();
            for (RowMapper.NodeInfo info : infos) {
                Serializable id = info.id;
                if (!done.add(id)) continue;
                todo.add(id);
                descendants.add(info);
            }
        }
        return descendants;
    }

    protected List<RowMapper.NodeInfo> getChildrenNodeInfos(Collection<Serializable> ids) {
        LinkedList<RowMapper.NodeInfo> linkedList;
        block21: {
            LinkedList<RowMapper.NodeInfo> children = new LinkedList<RowMapper.NodeInfo>();
            SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectChildrenNodeInfos(ids.size());
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(select.sql, ids);
            }
            Column where = select.whereColumns.get(0);
            PreparedStatement ps = this.connection.prepareStatement(select.sql);
            try {
                LinkedList<CallSite> debugValues = null;
                if (this.logger.isLogEnabled()) {
                    debugValues = new LinkedList<CallSite>();
                }
                int ii = 1;
                for (Serializable id : ids) {
                    where.setToPreparedStatement(ps, ii++, id);
                }
                try (ResultSet rs = ps.executeQuery();){
                    this.countExecute();
                    while (rs.next()) {
                        RowMapper.NodeInfo info = this.getNodeInfo(rs, select.whatColumns);
                        children.add(info);
                        if (debugValues == null || debugValues.size() >= 50) continue;
                        debugValues.add((CallSite)((Object)(info.id + "/" + info.primaryType)));
                    }
                }
                if (debugValues != null) {
                    if (debugValues.size() >= 50) {
                        debugValues.add((CallSite)((Object)("... (" + children.size() + ") results")));
                    }
                    this.logger.log("  -> " + debugValues);
                }
                linkedList = children;
                if (ps == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new NuxeoException("Failed to get descendants", (Throwable)e);
                }
            }
            ps.close();
        }
        return linkedList;
    }

    protected RowMapper.NodeInfo getNodeInfo(ResultSet rs, List<Column> columns) throws SQLException {
        Serializable id = null;
        Serializable parentId = null;
        String primaryType = null;
        Boolean isProperty = null;
        Serializable targetId = null;
        Serializable versionableId = null;
        Calendar retainUntil = null;
        boolean isRecord = false;
        boolean hasLegalHold = false;
        boolean isRetentionActive = false;
        int i = 1;
        for (Column column : columns) {
            String key = column.getKey();
            Serializable value = column.getFromResultSet(rs, i++);
            if (key.equals("id")) {
                id = value;
                continue;
            }
            if (key.equals("parentid")) {
                parentId = value;
                continue;
            }
            if (key.equals("primarytype")) {
                primaryType = (String)((Object)value);
                continue;
            }
            if (key.equals("isproperty")) {
                isProperty = (Boolean)value;
                continue;
            }
            if (key.equals("targetid")) {
                targetId = value;
                continue;
            }
            if (key.equals("versionableid")) {
                versionableId = value;
                continue;
            }
            if (key.equals("isrecord")) {
                isRecord = Boolean.TRUE.equals(value);
                continue;
            }
            if (key.equals("retainuntil")) {
                retainUntil = (Calendar)value;
                continue;
            }
            if (key.equals("haslegalhold")) {
                hasLegalHold = Boolean.TRUE.equals(value);
                continue;
            }
            if (!key.equals("isretentionactive")) continue;
            isRetentionActive = Boolean.TRUE.equals(value);
        }
        RowMapper.NodeInfo nodeInfo = new RowMapper.NodeInfo(id, parentId, primaryType, isProperty, versionableId, targetId, isRecord, retainUntil, hasLegalHold, isRetentionActive);
        return nodeInfo;
    }
}

