/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.storage.FulltextQueryAnalyzer;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class DialectMySQL
extends Dialect {
    public DialectMySQL(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) {
        super(metadata, repositoryDescriptor);
    }

    @Override
    public char openQuote() {
        return '`';
    }

    @Override
    public char closeQuote() {
        return '`';
    }

    @Override
    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKeys, String referencedTable, String[] primaryKeys, boolean referencesPrimaryKey) {
        String cols = String.join((CharSequence)", ", foreignKeys);
        return String.format(" ADD INDEX %s (%s), ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s (%s)", constraintName, cols, constraintName, cols, referencedTable, String.join((CharSequence)", ", primaryKeys));
    }

    @Override
    public boolean qualifyIndexName() {
        return false;
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectMySQL.jdbcInfo("VARCHAR(255)", 12);
                }
                if (type.isClob() || type.length > 65535) {
                    return DialectMySQL.jdbcInfo("LONGTEXT", -1);
                }
                return DialectMySQL.jdbcInfo("VARCHAR(%d)", type.length, 12);
            }
            case BOOLEAN: {
                return DialectMySQL.jdbcInfo("BIT", -7);
            }
            case LONG: {
                return DialectMySQL.jdbcInfo("BIGINT", -5);
            }
            case DOUBLE: {
                return DialectMySQL.jdbcInfo("DOUBLE", 8);
            }
            case TIMESTAMP: {
                return DialectMySQL.jdbcInfo("DATETIME(3)", 93);
            }
            case BLOBID: {
                return DialectMySQL.jdbcInfo("VARCHAR(250) BINARY", 12);
            }
            case BLOB: {
                return DialectMySQL.jdbcInfo("LONGBLOB", 2004);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                return DialectMySQL.jdbcInfo("VARCHAR(36) BINARY", 12);
            }
            case SYSNAME: 
            case SYSNAMEARRAY: {
                return DialectMySQL.jdbcInfo("VARCHAR(255) BINARY", 12);
            }
            case TINYINT: {
                return DialectMySQL.jdbcInfo("TINYINT", -6);
            }
            case INTEGER: {
                return DialectMySQL.jdbcInfo("INTEGER", 4);
            }
            case AUTOINC: {
                return DialectMySQL.jdbcInfo("INTEGER AUTO_INCREMENT PRIMARY KEY", 4);
            }
            case FTINDEXED: {
                throw new AssertionError(type);
            }
            case FTSTORED: {
                return DialectMySQL.jdbcInfo("LONGTEXT", -1);
            }
            case CLUSTERNODE: {
                return DialectMySQL.jdbcInfo("BIGINT", -5);
            }
            case CLUSTERFRAGS: {
                return DialectMySQL.jdbcInfo("TEXT", 12);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 12 && actual == -1) {
            return true;
        }
        if (expected == -1 && actual == 12) {
            return true;
        }
        if (expected == -5 && actual == 4) {
            return true;
        }
        if (expected == 4 && actual == -5) {
            return true;
        }
        return expected == 2004 && actual == -4;
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case -1: 
            case 12: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case -5: 
            case 4: {
                ps.setLong(index, ((Number)value).longValue());
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
            case 2004: {
                ps.setBytes(index, (byte[])value);
                return;
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case -1: 
            case 12: {
                return this.getFromResultSetString(rs, index, column);
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
            case 2004: {
                return rs.getBytes(index);
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    protected int getMaxNameSize() {
        return 64;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        String indexedColumns = columns.stream().map(Column::getQuotedName).collect(Collectors.joining(", "));
        return String.format("CREATE FULLTEXT INDEX %s ON %s (%s)", quotedIndexName, table.getQuotedName(), indexedColumns);
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        FulltextQueryAnalyzer.FulltextQuery ft = FulltextQueryAnalyzer.analyzeFulltextQuery((String)(query = query.replace("%", "*")));
        if (ft == null || ft.op == FulltextQueryAnalyzer.Op.NOTWORD) {
            return "DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        StringBuilder sb = new StringBuilder();
        DialectMySQL.translateForMySQL(ft, null, sb);
        return sb.toString();
    }

    protected static void translateForMySQL(FulltextQueryAnalyzer.FulltextQuery ft, FulltextQueryAnalyzer.Op superOp, StringBuilder sb) {
        if (ft.op == FulltextQueryAnalyzer.Op.AND || ft.op == FulltextQueryAnalyzer.Op.OR) {
            if (superOp == FulltextQueryAnalyzer.Op.AND) {
                sb.append('+');
            }
            sb.append('(');
            for (int i = 0; i < ft.terms.size(); ++i) {
                FulltextQueryAnalyzer.FulltextQuery term = (FulltextQueryAnalyzer.FulltextQuery)ft.terms.get(i);
                if (i != 0) {
                    sb.append(' ');
                }
                DialectMySQL.translateForMySQL(term, ft.op, sb);
            }
            sb.append(')');
        } else {
            if (ft.op == FulltextQueryAnalyzer.Op.NOTWORD) {
                sb.append('-');
            } else if (superOp == FulltextQueryAnalyzer.Op.AND) {
                sb.append('+');
            }
            boolean isPhrase = ft.word.contains(" ");
            if (isPhrase) {
                sb.append('\"');
            }
            sb.append(ft.word);
            if (isPhrase) {
                sb.append('\"');
            }
        }
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        String nthSuffix = nthMatch == 1 ? "" : String.valueOf(nthMatch);
        String indexSuffix = model.getFulltextIndexSuffix(indexName);
        Table ft = database.getTable("fulltext");
        Column ftMain = ft.getColumn("id");
        Column stColumn = ft.getColumn("simpletext" + indexSuffix);
        Column btColumn = ft.getColumn("binarytext" + indexSuffix);
        String match = String.format("MATCH (%s, %s)", stColumn.getFullQuotedName(), btColumn.getFullQuotedName());
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        if (nthMatch == 1) {
            info.joins = Collections.singletonList(new Join(1, ft.getQuotedName(), null, null, ftMain.getFullQuotedName(), mainColumn.getFullQuotedName()));
        }
        info.whereExpr = String.format("%s AGAINST (? IN BOOLEAN MODE)", match);
        info.whereExprParam = fulltextQuery;
        info.scoreExpr = String.format("(%s AGAINST (?) / 10)", match);
        info.scoreExprParam = fulltextQuery;
        info.scoreAlias = "_nxscore" + nthSuffix;
        info.scoreCol = new Column(mainColumn.getTable(), null, ColumnType.DOUBLE, null);
        return info;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return false;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 2;
    }

    @Override
    public String getTableTypeString(Table table) {
        return " ENGINE=InnoDB";
    }

    @Override
    public boolean supportsUpdateFrom() {
        return true;
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        return true;
    }

    @Override
    public boolean needsOrderByKeysAfterDistinct() {
        return false;
    }

    @Override
    public boolean needsAliasForDerivedTable() {
        return true;
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?)", idColumnName);
    }

    @Override
    public String getInTreeSql(String idColumnName, String id) {
        return String.format("NX_IN_TREE(%s, ?)", idColumnName);
    }

    @Override
    public String getUpsertSql(List<Column> columns, List<Serializable> values, List<Column> outColumns, List<Serializable> outValues) {
        int i;
        Column keyColumn = columns.get(0);
        Table table = keyColumn.getTable();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(table.getQuotedName());
        sql.append(" (");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append(columns.get(i).getQuotedName());
        }
        sql.append(") VALUES (");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append("?");
            outColumns.add(columns.get(i));
            outValues.add(values.get(i));
        }
        sql.append(") ON DUPLICATE KEY UPDATE ");
        for (i = 1; i < columns.size(); ++i) {
            if (i != 1) {
                sql.append(", ");
            }
            sql.append(columns.get(i).getQuotedName());
            sql.append(" = VALUES(");
            sql.append(columns.get(i).getQuotedName());
            sql.append(")");
        }
        return sql.toString();
    }

    @Override
    public String getInsertOnConflictDoNothingSql(List<Column> columns, List<Serializable> values, List<Column> outColumns, List<Serializable> outValues) {
        int i;
        Column keyColumn = columns.get(0);
        Table table = keyColumn.getTable();
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT IGNORE INTO ");
        sql.append(table.getQuotedName());
        sql.append(" (");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append(columns.get(i).getQuotedName());
        }
        sql.append(") VALUES (");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append("?");
            outColumns.add(columns.get(i));
            outValues.add(values.get(i));
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/mysql.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/mysql.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("idType", (Serializable)((Object)"varchar(36)"));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        properties.put("fulltextSearchEnabled", Boolean.valueOf(!this.fulltextSearchDisabled));
        properties.put("clusteringEnabled", Boolean.valueOf(this.clusteringEnabled));
        return properties;
    }

    @Override
    public boolean isConcurrentUpdateException(Throwable t) {
        do {
            if (!(t instanceof SQLException)) continue;
            String sqlState = ((SQLException)t).getSQLState();
            if ("23000".equals(sqlState)) {
                return true;
            }
            if (!"40001".equals(sqlState)) continue;
            return true;
        } while ((t = t.getCause()) != null);
        return false;
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public boolean isClusteringDeleteNeeded() {
        return true;
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "CALL NX_CLUSTER_INVAL(?, ?, ?, ?)";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "SELECT id, fragments, kind FROM cluster_invals WHERE nodeid = ?";
    }

    @Override
    public boolean supportsPaging() {
        return true;
    }

    @Override
    public String addPagingClause(String sql, long limit, long offset) {
        return sql + String.format(" LIMIT %d OFFSET %d", limit, offset);
    }

    @Override
    public boolean isIdentityAlreadyPrimary() {
        return true;
    }

    @Override
    public String getBinaryFulltextSql(List<String> columns) {
        return "SELECT " + String.join((CharSequence)", ", columns) + " FROM `fulltext` WHERE id=?";
    }

    @Override
    public List<String> checkStoredProcedure(String procName, String procCreate, String ddlMode, Connection connection, JDBCLogger logger, Map<String, Serializable> properties) throws SQLException {
        boolean compatCheck = ddlMode.contains("compat");
        String ifExists = compatCheck ? "IF EXISTS " : "";
        String procDrop = procCreate.toLowerCase().startsWith("create function ") ? "DROP FUNCTION " + ifExists + procName : "DROP PROCEDURE " + ifExists + procName;
        if (compatCheck) {
            return Arrays.asList(procDrop, procCreate);
        }
        try (Statement st = connection.createStatement();){
            List<String> list;
            block21: {
                ResultSet rs;
                block17: {
                    List<String> list2;
                    block20: {
                        block18: {
                            List<String> list3;
                            block19: {
                                String getBody = "SELECT ROUTINE_DEFINITION FROM information_schema.routines WHERE ROUTINE_SCHEMA = DATABASE() AND ROUTINE_NAME = '" + procName + "'";
                                logger.log(getBody);
                                rs = st.executeQuery(getBody);
                                try {
                                    if (!rs.next()) break block17;
                                    String body = rs.getString(1);
                                    if (!DialectMySQL.normalizeString(procCreate).contains(DialectMySQL.normalizeString(body))) break block18;
                                    logger.log("  -> exists, unchanged");
                                    list3 = Collections.emptyList();
                                    if (rs == null) break block19;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return list3;
                        }
                        logger.log("  -> exists, old");
                        list2 = Arrays.asList(procDrop, procCreate);
                        if (rs == null) break block20;
                        rs.close();
                    }
                    return list2;
                }
                logger.log("  -> missing");
                list = Collections.singletonList(procCreate);
                if (rs == null) break block21;
                rs.close();
            }
            return list;
        }
    }

    protected static String normalizeString(String string) {
        return string.replaceAll("-- .*", " ").replaceAll("[ \n\r\t]+", " ").trim();
    }

    @Override
    public Collection<? extends String> getDumpStart() {
        return Collections.singleton("DELIMITER $$");
    }

    @Override
    public Collection<? extends String> getDumpStop() {
        return Collections.singleton("DELIMITER ;");
    }

    @Override
    public String getSQLForDump(String sql) {
        return sql + " $$";
    }
}

