/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.extension.ExternalConverter;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.runtime.api.Framework;

public abstract class CommandLineBasedConverter
implements ExternalConverter {
    protected static final String CMD_NAME_PARAMETER = "CommandLineName";
    protected static final String TMP_PATH_PARAMETER = "TmpDirectory";
    protected Map<String, String> initParameters;

    @Deprecated
    protected CommandLineExecutorService getCommandLineService() {
        return (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
    }

    public String getTmpDirectory(Map<String, Serializable> parameters) {
        String tmp = this.initParameters.get(TMP_PATH_PARAMETER);
        if (parameters != null && parameters.containsKey(TMP_PATH_PARAMETER)) {
            tmp = (String)((Object)parameters.get(TMP_PATH_PARAMETER));
        }
        if (tmp == null) {
            tmp = Environment.getDefault().getTemp().getPath();
        }
        return tmp;
    }

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        String commandName = this.getCommandName(blobHolder, parameters);
        if (commandName == null) {
            throw new ConversionException("Unable to determine target CommandLine name", blobHolder);
        }
        Map<String, Blob> blobParams = this.getCmdBlobParameters(blobHolder, parameters);
        Map<String, String> strParams = this.getCmdStringParameters(blobHolder, parameters);
        CmdReturn result = this.execOnBlob(commandName, blobParams, strParams);
        return this.buildResult(result.output, result.params);
    }

    protected String getCommandName(BlobHolder blobHolder, Map<String, Serializable> parameters) {
        String commandName = this.initParameters.get(CMD_NAME_PARAMETER);
        if (parameters != null && parameters.containsKey(CMD_NAME_PARAMETER)) {
            commandName = (String)((Object)parameters.get(CMD_NAME_PARAMETER));
        }
        return commandName;
    }

    protected abstract Map<String, Blob> getCmdBlobParameters(BlobHolder var1, Map<String, Serializable> var2) throws ConversionException;

    protected abstract Map<String, String> getCmdStringParameters(BlobHolder var1, Map<String, Serializable> var2) throws ConversionException;

    protected abstract BlobHolder buildResult(List<String> var1, CmdParameters var2) throws ConversionException;

    protected CmdReturn execOnBlob(String commandName, Map<String, Blob> blobParameters, Map<String, String> parameters) throws ConversionException {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        CmdParameters params = cles.getDefaultCmdParameters();
        ArrayList<CloseableFile> toClose = new ArrayList<CloseableFile>();
        try {
            ExecResult result;
            if (blobParameters != null) {
                for (String blobParamName : blobParameters.keySet()) {
                    Blob blob = blobParameters.get(blobParamName);
                    Object closeable = blob.getCloseableFile("." + FilenameUtils.getExtension((String)blob.getFilename()));
                    params.addNamedParameter(blobParamName, closeable.getFile());
                    toClose.add((CloseableFile)closeable);
                }
            }
            if (parameters != null) {
                for (String paramName : parameters.keySet()) {
                    params.addNamedParameter(paramName, parameters.get(paramName));
                }
            }
            if (!(result = ((CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class)).execCommand(commandName, params)).isSuccessful()) {
                throw result.getError();
            }
            CmdReturn cmdReturn = new CmdReturn(params, result.getOutput());
            return cmdReturn;
        }
        catch (CommandNotAvailable e) {
            throw new ConversionException("Unable to find targetCommand", (Throwable)e);
        }
        catch (IOException | CommandException e) {
            throw new ConversionException("Error while converting via CommandLineService", e);
        }
        finally {
            for (Closeable closeable : toClose) {
                IOUtils.closeQuietly((Closeable)closeable);
            }
        }
    }

    public void init(ConverterDescriptor descriptor) {
        this.initParameters = descriptor.getParameters();
        if (this.initParameters == null) {
            this.initParameters = new HashMap<String, String>();
        }
    }

    public ConverterCheckResult isConverterAvailable() {
        String commandName = this.getCommandName(null, null);
        if (commandName == null) {
            return new ConverterCheckResult();
        }
        CommandAvailability ca = ((CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class)).getCommandAvailability(commandName);
        if (ca.isAvailable()) {
            return new ConverterCheckResult();
        }
        return new ConverterCheckResult(ca.getInstallMessage(), ca.getErrorMessage());
    }

    protected class CmdReturn {
        protected final CmdParameters params;
        protected final List<String> output;

        protected CmdReturn(CmdParameters params, List<String> output) {
            this.params = params;
            this.output = output;
        }
    }
}

