/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;

public class BTreeIterator
implements Iterator {
    private final Tuple jdbmTuple = new Tuple();
    private TupleBrowser browser;
    private boolean success = false;
    private boolean doAscending = true;

    BTreeIterator(BTree tree, boolean doAscending) throws NamingException {
        this.doAscending = doAscending;
        try {
            this.browser = doAscending ? tree.browse() : tree.browse(null);
            this.prefetch();
        }
        catch (IOException e) {
            LdapNamingException lne = new LdapNamingException("Failure on btree: " + e.getMessage(), ResultCodeEnum.OTHER);
            lne.setRootCause((Throwable)e);
            throw lne;
        }
    }

    private void prefetch() throws IOException {
        this.success = this.doAscending ? this.browser.getNext(this.jdbmTuple) : this.browser.getPrevious(this.jdbmTuple);
    }

    public boolean hasNext() {
        return this.success;
    }

    public Object next() {
        if (!this.success) {
            throw new NoSuchElementException();
        }
        Object next = this.jdbmTuple.getKey();
        try {
            this.prefetch();
        }
        catch (IOException e) {
            throw new NoSuchElementException("Failure on btree: " + e.getMessage());
        }
        return next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

